#include "mbed.h"
#include "AM2320.h"

Serial pc(D1, D0); //tx, rx
AM2320 cap(D4, D5);

AnalogIn fum(A3);
DigitalOut led(D6);
float valFum;
int samplingTime = 280;
int deltaTime = 40;
int sleepTime = 9680;
int val = 0;
int FumEntier = 0;

int main() {
    pc.printf("START\r\n");
    cap.get();
    led = 0;
     wait_us(samplingTime);
     valFum = fum.read()*6;
     wait_us(deltaTime);
     led = 1;
     wait_us(sleepTime);
        
    wait(10);
    while(1) {
        led = 0;
        wait_us(samplingTime);
        valFum = fum.read()*6;
        wait_us(deltaTime);
        led = 1;
        wait_us(sleepTime);
        FumEntier = valFum * 10;
        cap.get();
        pc.printf("AT$SF=%02x%02x%02x00\r\n", cap.temperature()/10, cap.humidity()/10, FumEntier);
        wait(5);
    }
}
