#include "mbed.h"
#include "math.h"
#define PAI 3.141592653589
/*mbedの設定*/
Serial pc(USBTX, USBRX);
Serial gps(p9 , p10);
Serial musen(p28 , p27);
Ticker tic_gps;
/*グローバル変数*/
int cnt_gps = 0;
float now_lat,now_lon,goal_lat,goal_lon,MAX_ALT;
/*プロトタイプ宣言*/
void  _SendGPS();
char c[256];
float _DMS2DEG(float raw_data);
/*main関数*/
int main(){
    pc.baud(115200);
    pc.printf("Hello OSHIMA\r\n");
    tic_gps.attach(&_SendGPS, 1.0);
    int i = 0;
    while(1){
        c[i] = musen.getc();
        if(c[i] == '\n'){
            break;
        }
    }
    sscanf(c,"Lat:%f,Lon:%f,MAX_ALT:%f",&goal_lat,&goal_lon,&MAX_ALT);     
    //度をradに変換
    float delta_lon = (PAI * (goal_lon - now_lon)/180);
    now_lat = (PAI * (now_lat)/180);
    now_lon = (PAI * (now_lon)/180);
    goal_lat = (PAI * (goal_lat)/180);
    goal_lon = (PAI * (goal_lon)/180);
    //距離方位角計算
    float dist = 6378.137 * acos( sin(goal_lat) * sin(now_lat) + cos(goal_lat) * cos(now_lat) * cos(delta_lon));
    float azi = (180.0/3.1415926535)*atan2(sin(delta_lon), cos(now_lat) * tan(goal_lat) - sin(now_lat)*cos(delta_lon));
    if (azi < 0){
        azi = azi + 360.0;
    }
    pc.printf("距離：%f,方位：%f,/r/n",dist,azi);    
}
void _SendGPS(){
    char gps_data[256];
    while(1){
        if(gps.readable()){
            gps_data[cnt_gps] = gps.getc();
            if(gps_data[cnt_gps] == '$' || cnt_gps ==256){
                cnt_gps = 0;
                memset(gps_data,'\0',256);
            }else if(gps_data[cnt_gps] == '\r'){
                float world_time, lon_east, lat_north;
                int rlock, sat_num;
                char lat,lon;
                if(sscanf(gps_data,"GPGGA,%f,%f,%c,%f,%c,%d,%d",&world_time,&lat_north,&lat,&lon_east,&lon,&rlock,&sat_num)>=1){
                    if(rlock==1){
                        now_lat = _DMS2DEG(lat_north);
                        now_lon = _DMS2DEG(lon_east);
                        //pc.printf("%s\r\n",gps_data);
                        //pc.printf("Lat:%f,Lon:%f\r\ntime:%f,sat_num:%d\r\n",now_lat,now_lon,world_time,sat_num);
                        int japan_time = int(world_time) - 9;
                        pc.printf("Lat:%f,Lon:%f\r\n",now_lat,now_lon);
                        break;
                    }
                    else{
                        //pc.printf("%s\r\n",gps_data);
                        pc.printf("NoGPSSignal\r\n");
                        break;
                    }
                }else{
                    //ffpc.printf("No_Satellite_signal\r\n");
                }
            }else{
                cnt_gps++;
            }
        }
    }
}
float _DMS2DEG(float raw_data){
    int d=(int)(raw_data/100);
    float m=(raw_data-(float)d*100);
    return (float)d+m/60;
}   

