#include "mbed.h"
#include "CushionSock.h"

int main() {
    Timer timer;
    CushionSock *cs;
    
    cs=new CushionSock();
    cs->init("ws://www2.minelab.jp:12020/test");
    printf("connect start\n");
    cs->connect();
    printf("connect");

    char msg[64];
    int counter=0;
    timer.start();
    while(1) {
        Net::poll();
        if (timer.read_ms() >= 2000) {
            cs->mess_send(cs->MESS_TEST, "down");
            timer.reset();
            counter++;
        }
        int type = cs->mess_recv(msg);
        if (type >= 0) {
            printf("messtype:%d rcv: %s\r\n",type, msg);
        }
        
        Net::poll();
        
        if(!cs->is_connected()||counter>10)
            break;
    }
    cs->close();
}
