#include "mbed.h"
#include "CushionNodeConnector.h"
#include "EthernetInterface.h"

int main() {
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    
    CushionNodeConnector cnc;
    bool ret = cnc.connect();
    if (!ret)
        exit(1);
        
    char msg[256];
    while(1) {
        int res = cnc.mess_send(1, "down");
        int type=cnc.mess_recv(msg);
        if (type > 0) {
            printf("messtype:%d rcv: %s\r\n",type, msg);
        }
        if(!cnc.is_connected())
            break;
        wait(0.1);       
    }
    cnc.close();
    eth.disconnect();
}
