#ifndef CUSHION_NODE_CONNECTOR_H
#define CUSHION_NODE_CONNECTOR_H

#include "mbed.h"
#include "SocketIO.h"
#include "picojson.h"


class CushionNodeConnector
{
    public:
    int MESS_STOP;
    int MESS_START;
    int MESS_SIT;
    int MESS_FRUST;
    
    /*
        Constructor
        @param hostAndport format : "hostname:port"        
    */
    CushionNodeConnector(char * hostAndPort);
    /*
        Constructor
        if you didn't use any paramators, connect to chikura-server.
    */
    CushionNodeConnector();
    
    
    /*
       connect to server
       @return true if the connection is established, false otherwise
    */
    bool connect();
    
    /*
       send message to server
       @return the number of bytes sent 
       @param type Message type(prease show and choose from line 14 to 17 in souece code)
       @param msg message payload  
    */    
    int mess_send(int type, char * msg);
    
    /*
        Recieve message from server
        @return if recieved succsessful, Message type(prease show and choose from line 14 to 17 in souece code), otherwise returns -1.
        @param msg pointer to the message to be read.
    */
    int mess_recv(char * msg);
    
    /*
     To see if there is a SocketIO connection active
     @return true if there is a connection active
    */
    bool is_connected();
    
    bool close();
    
    private:
    SocketIO *socketio;
    std::map<int,string> type_name;
    std::map<string,int> name_type;
};

#endif
