#include "CushionNodeConnector.h"

CushionNodeConnector::CushionNodeConnector(char * hostAndPort){
    socketio= new SocketIO(hostAndPort);
    MESS_STOP = 0x01;
    MESS_START = 0x02;
    MESS_SIT = 0x11;
    MESS_FRUST = 0x12;
    type_name[MESS_STOP]="stop";
    type_name[MESS_START]="start";
    type_name[MESS_SIT]="status_sit";
    type_name[MESS_FRUST]="status_frust";
    name_type["stop"]=MESS_STOP;
    name_type["start"]=MESS_START;
    name_type["status_sit"]=MESS_SIT;
    name_type["status_frust"]=MESS_FRUST;
}

CushionNodeConnector::CushionNodeConnector(){
    CushionNodeConnector("please enter your default hostname");
}
    
bool CushionNodeConnector::connect(){
     bool ret=socketio->connect();
     return ret;
}
  
int CushionNodeConnector::mess_send(int type, char * msg){
    string name=type_name[type];
    char chname[16];
    std::strncpy(chname, name.c_str(), 16);
    int ret=socketio->emit(chname,msg);
    return ret;
} 
    
int CushionNodeConnector::mess_recv(char * msg){
    picojson::value v;
    char recv[256];
    if (socketio->read(recv)) {
        int type;
        string name;
        string sbuf(recv);
        const char * crecv=sbuf.c_str();
        string err = picojson::parse(v,crecv,crecv+strlen(crecv));
        if(!err.empty())
            return -1;
        name=v.get("name").get<string>();
        strncpy(msg,v.get("args").get<string>().c_str(),256);
        type=name_type[name];
        return type;
    }else{
        return -1;
    }
}
 
bool CushionNodeConnector::is_connected(){
    return socketio->is_connected();
}

bool CushionNodeConnector::close(){
    return socketio->close();
}