#include "mbed.h"
 
class Blinking {
public:
    Blinking(PinName pin) : _pin(pin) {  // _pin(pin) means pass pin to the DigitalOut constructor
        _pin = 0;                                        // default the output to 0
    }
 
    void blink(int n) {
        for(int i=0; i<n*2; i++) {
            _pin = !_pin;
            wait(0.2);
        }
    }
 
private:
    DigitalOut _pin;
};
 
Blinking led(LED2);
Blinking  out(p6);
 
int main() {
    led.blink(5);
    led.blink(2);
    out.blink(10);
}
