#define logMessage printf
#define MQTTCLIENT_QOS2 1

#include <string>
#include "mbed.h"
#include "easy-connect.h"
#include "TCPSocket.h"
#include "DHT.h"
#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"

/* connect this pin to both the CH_PD (aka EN) & RST pins on the ESP8266 just in case */
#define WIFI_HW_RESET_PIN D4

/* See if you can try using a hostname here */
#define MQTT_BROKER_ADDR "192.168.0.9"
#define MQTT_BROKER_PORT 1883

Serial pc(USBTX, USBRX);    // computer to mbed boardSerial esp(D1, D0);
DHT sensor(D7, DHT22);

DigitalOut wifiHwResetPin(WIFI_HW_RESET_PIN);
DigitalOut led2(LED2);

volatile bool flag = false;

Mutex mqttMtx;


char* topic1 = "LED2";
char* topic2 = "Temp";
/*char* topic3 = "setOff";
char* topic4 = "setOn";*/

void task_DHT();

void messageArrived(MQTT::MessageData& md){
    MQTT::Message &message = md.message;


    logMessage("\rMessage arrived: qos %d, retained %d, dup %d, packetid %d\r\n",
    message.qos, message.retained, message.dup, message.id);
    
    logMessage("Payload %.*s\r\n", message.payloadlen, (char*)message.payload);

    char fwdTarget = ((char *)message.payload)[0];
    
    switch(fwdTarget){
        case '0': // turn off
            led2 = 0;
            logMessage("setOff: turn off the Red\r\n\r\n");
            break;
        
        case '1': //turn on
            led2 = 1;
            logMessage("setOff: turn on the Red\r\n\r\n");
            break;
        
        default:
            pc.printf("Unknown MQTT msg\r\n\r\n");
            break;
    }
}

int main(int argc, char* argv[]){
    

    float version = 0.5;
    pc.baud(115200);
    
    logMessage("MQTT example: version is %.2f\r\n", version);
    wait(0.2); //delay startup
    
    pc.printf("\rResetting ESP8266 Hardware...\r\n");
    wifiHwResetPin = 0;
    wait_ms(100);
    wifiHwResetPin = 1;
    
    pc.printf("Starting MQTT example with an ESP8266 wifi device using Mbed OS.\r\n");
    pc.printf("Attempting to connect to access point...\r\n");
    
    NetworkInterface* network = easy_connect(true);
    
    if (!network) {
        pc.printf("Error in east connection\r\n");
        return -1;
    }
    
    MQTTNetwork mqttNetwork(network);
    
    MQTT::Client<MQTTNetwork, Countdown> client(mqttNetwork);
    
    logMessage("Connecting to %s:%d\r\n", MQTT_BROKER_ADDR, MQTT_BROKER_PORT);
    int rc = mqttNetwork.connect(MQTT_BROKER_ADDR, MQTT_BROKER_PORT);
    if (rc != 0)
        logMessage("rc from TCP connect is %d\r\n", rc);
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "mbed-jihyeon";
    data.username.cstring = "user-jihyeon";
    data.password.cstring = "testpassword";

    if ((rc = client.connect(data)) != 0)
        logMessage("rc from MQTT connect is %d\r\n", rc);
    if ((rc = client.subscribe(topic1, MQTT::QOS0, messageArrived))&(rc = client.subscribe(topic2, MQTT::QOS0, messageArrived)) != 0)
        logMessage("rc from MQTT subscribe is %d\r\n", rc);

    int count = 0;
    
    int error = 0;
    int c;

    while(1) {
        error = sensor.readData();

        if (0 == error) {          
            
            c   = sensor.ReadTemperature(CELCIUS);

            Thread::wait(1000);
            char buf[5];
            MQTT::Message message;
            
            if (count == 5) {
                pc.printf("\rPublish: temp(%d *C)\r\n", c);
            
                sprintf(buf, "%d", c);
                message.qos = MQTT::QOS2;
                message.retained = false;
                message.dup = false;
                message.payload = (void*)buf;
                message.payloadlen = strlen(buf)+1;
                mqttMtx.lock();
                rc = client.publish(topic2, message);
                mqttMtx.unlock();
                count = 0;
            }          

            if(!client.isConnected())
                NVIC_SystemReset(); // soft reset
                

            client.yield(10);
            count++;
        } else {            
            printf("Error: %d\r\n", error);
        } 
    }          
        
    return 0;
}

