/*
#include "C12832.h"
#include "easy-connect.h"
#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"
*/

#define logMessage printf
//#define MQTTCLIENT_QOS2 1
#include "mbed.h"
#include "easy-connect.h"
#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"
#include "DHT.h"
/* connect this pin to both the CH_PD (aka EN) & RST pins on the ESP8266 just in case */
#define WIFI_HW_RESET_PIN D4
/* See if you can try using a hostname here */
#define MQTT_BROKER_ADDR "192.168.0.9"
#define MQTT_BROKER_PORT 1883
DHT sensor(D7,DHT22);
DigitalOut wifiHwResetPin(WIFI_HW_RESET_PIN);
DigitalOut led2(LED2);
Serial pc(USBTX, USBRX); // computer to mbedboardSerialesp(D1, D0);




volatile bool flag = false;

Mutex mqttMtx;


float t = 0;

char* topic1 = "LED";
char* topic2 = "TEMP";
char* topic3 = "LEDS";
void messageArrived(MQTT::MessageData& md)
{

    MQTT::Message &message = md.message;
    /* our messaging standard says the first byte denotes which thread to fwdto */
    logMessage("Message arrived: qos%d, retained %d, dup %d, packetid%d\r\n", message.qos, message.retained, message.dup, message.id);
    logMessage("Payload %.*s\r\n", message.payloadlen, (char*)message.payload);

    char fwdTarget= ((char *)message.payload)[0]; 
        switch(fwdTarget)
        {
        case '0': // turn off
        led2 = 0;
        break;

        case '1': //turn on
        led2 = 1;
        break;
        
        case '2': //LED status
        flag = true;
        break;
        
        default:
        pc.printf("Unknown MQTT message\n");
        break;
        }
    }

int main(int argc, char* argv[])
{
    float version = 0.5;
    pc.baud(115200);
    logMessage("MQTT example: version is %.2f\r\n", version);
    wait(0.2); //delay startup
    pc.printf("Resetting ESP8266 Hardware...\r\n");
    wifiHwResetPin= 0;
    wait_ms(500);
    wifiHwResetPin= 1;
    pc.printf("Starting MQTT example with an ESP8266 wifidevice using MbedOS.\r\n");
    pc.printf("Attempting to connect to access point...\r\n");

    NetworkInterface* network = easy_connect(true);
    if (!network) {
        pc.printf("Error in east connection\r\n");
        return -1;
    }

    MQTTNetwork mqttNetwork(network);
    MQTT::Client<MQTTNetwork, Countdown> client(mqttNetwork);
    
    logMessage("Connecting to %s:%d\r\n", MQTT_BROKER_ADDR, MQTT_BROKER_PORT);
    int rc= mqttNetwork.connect(MQTT_BROKER_ADDR, MQTT_BROKER_PORT);

    if (rc!= 0)
    logMessage("rcfrom TCP connect is %d\r\n", rc);

    MQTTPacket_connectData data= MQTTPacket_connectData_initializer;
    data.MQTTVersion= 3;
    data.clientID.cstring= "mbed-ljw";
    data.username.cstring= "user-ljw";
    data.password.cstring= "testpassword";

    if ((rc= client.connect(data)) != 0)
        logMessage("rcfrom MQTT connect is %d\r\n", rc);
    if ((rc= client.subscribe(topic1, MQTT::QOS0, messageArrived)) != 0)
        logMessage("rcfrom MQTT subscribe is %d\r\n", rc);

    int count = 0;

    while(1) {
        Thread::wait(1000);

        char buf[64];
        MQTT::Message message;


        t  = sensor.ReadTemperature(CELCIUS);

        

        if (count == 30) {
            pc.printf("Publish: TEMP\r\n");

            sprintf(buf, "{ \"temp\": \"%.1f\"}\r\n", t);

            message.qos= MQTT::QOS2;
            message.retained= false;
            message.dup= false;
            message.payload= (void*)buf;
            message.payloadlen= strlen(buf)+1;
            mqttMtx.lock();
            rc= client.publish(topic2, message);
            mqttMtx.unlock();
            count = 0;

        }

        if (flag) {
            pc.printf("Publish: LEDS\r\n");

            if (led2 == 0)
                sprintf(buf, "LED OFF");
            else
                sprintf(buf, "LED ON");
            
            message.qos= MQTT::QOS1;
            message.retained= false;
            message.dup= false;
            message.payload= (void*)buf;
            message.payloadlen= strlen(buf)+1;

            mqttMtx.lock();
            rc= client.publish(topic3, message);
            mqttMtx.unlock();
            flag = false;
        }

        if(!client.isConnected())
            NVIC_SystemReset();// soft reset
        /* yield() needs to be called at least once per keepAliveInterval*/
        client.yield(10);
        count++;
        }
    return 0;
}
