/*
Perimeter detection
John Emberson/Tercio Junker

The purpose of this code is to rotate an HC-SR04 and measure the perimeter of a room.
The measurements will then be sent to ThingSpeak to record the data.

*/

#include "mbed.h"
#include "hcsr04.h"
#include "ESP8266.h"
#include "ULN2003.h"
#include "TextLCD.h"



#define IP "184.106.153.149"
#define spr 4096

#define SSID    "IU PublicNet"
#define PW      ""


Serial pc(USBTX,USBRX);                     //Serial Communication with PC
ESP8266 wifi(PTC17, PTC16, 115200);         //Tx Pin:PTC17; Rx Pin:PTC17; Baud rate:115200
ULN2003 sm(D13,D12,D11,D10,spr);            //SM motor (In1,In2,In3,In4,StepsPerRotation=4096)
HCSR04 us(D7,D6);                           //Trig:D7 Echo:D6
TextLCD lcd(D9,D8,D2,D3,D4,D5);             //Rs,E,D4,D5,D6,D7

char snd[255];                      //snd: send command to ESP8266        
char resp[1000];                    //resp: receive response from ESP8266

int dist[]={1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16};

char* API = "Q34TJD14E68FMA7A";     //API key

char comm[300];                     //WIFI command
int timeout = 8000;                 //timeout for wifi commands


int mp=16;                          //The amount of measurements per rotation
int hmp=mp/2;                       //Half a rotation
int delta=spr/mp;                   //setting up 16 points to take a measurment This is the amount of steps per measurement
int speed=500;                      //speed in steps per second
int delay=(delta/speed)/1000;       //(steps % (steps per second))/1000 = milliseconds
                        
void MotorFront(){                  //Move motor forward half a rotation
    for (int i=1;i<(hmp+1);i++){
        sm.moveForward(delta,speed);
        wait_ms(delay);
        us.start();
        wait_ms(500);
        dist[i]=us.get_dist_cm();
        pc.printf("dist%d=%d\r\n",i,dist[i]);
        }
        }
 void MotorBack(){                  //Move motor reverse half a rotations
    for (int i=mp;i>(hmp);i--){
        sm.moveForward(delta,speed);
        wait_ms(delay);
        us.start();
        wait_ms(500);
        dist[i]=us.get_dist_cm();
        pc.printf("dist%d=%d\r\n",i,dist[i]);
        }
        }   

void ConnWIFI(){                            //Connect to wifi
    wifi.SetMode(1);        
    wifi.SendCMD(snd);
    wifi.RcvReply(resp, 5000);
    wait(1);
    pc.printf("%s\r", resp);
    wifi.Join(SSID,PW);
    wifi.RcvReply(resp, 5000);
    wait(1);
    pc.printf("%s\r\n", resp);
    pc.printf("Connecting to WIFI...");
    lcd.cls();
    lcd.printf("Connecting to   WIFI");
    wifi.setTransparent();          
    wait(1);    
    pc.printf("...");
    lcd.printf("...");
    wifi.SetSingle();             
    wifi.RcvReply(resp, timeout);
    wait(1);
    }
    
void ConnTS1(){                                             //Connect to ThingSpeak
    pc.printf("\r\nConnecting to ThingSpeak\r\n");
    lcd.cls();
    lcd.printf("Connecting to   ThingSpreak");
    wifi.startTCPConn(IP,80);                               //cipstart
    wifi.RcvReply(resp, timeout);
    wait(1);
    sprintf(snd,"https://api.thingspeak.com/update?api_key=%s&field1=%d&field2=%d&field3=%d&field4=%d&field5=%d&field6=%d&field7=%d&field8=%d\r\n",API,dist[1],dist[2],dist[3],dist[4],dist[5],dist[6],dist[7],dist[8]);
    pc.printf("Sending data to ThingSpeak\r\n");
    lcd.cls();
    lcd.printf("Sending data to ThingSpeak");
    wifi.sendURL(snd, comm);                                //cipsend and get command
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while sending URL \r\n");
    wait_ms(5000);
    }
     
void ConnTS2(){                                             //Connect to ThingSpeak for second back of data
    pc.printf("\r\nSending second batch of data...");
    lcd.cls();
    lcd.printf("Sending second  batch of data");
    wifi.startTCPConn(IP,80);                               //cipstart
    wifi.RcvReply(resp, timeout);
    wait(1);
    sprintf(snd,"https://api.thingspeak.com/update?api_key=%s&field1=%d&field2=%d&field3=%d&field4=%d&field5=%d&field6=%d&field7=%d&field8=%d\r\n",API,dist[9],dist[10],dist[11],dist[12],dist[13],dist[14],dist[15],dist[16]); 
    pc.printf("...\r\n");
    lcd.printf("...");
    wifi.sendURL(snd, comm);                                //cipsend and get command
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while sending URL \r\n");
}
    
    
int main()
{
    pc.baud(115200);                        //Baud Rate of 115200 for Tera Term
    pc.printf("Scanning measurments of room");   
    lcd.cls();                              //Clear LCD Screen           
    lcd.printf("Scanning measurments of room");
    wait_ms(2000);
    MotorFront();                           //Scan first 8 steps
    sm.moveReverse(spr,600);                //Rotates camera opposite to prevent wire tangle
    wait_ms(250);                           
    MotorBack();                            //Scan last 8 steps
    ConnWIFI();                             //Connecting to WIFI
    ConnTS1();                              //Sending first 8 steps to ThingSpeak
    ConnTS2();                              //Sending last 8 steps to ThingSpeak
    pc.printf("Done");
    lcd.cls();
    lcd.printf("Done");
}