#include "mbed.h"
#include "N5110.h"

//change this to alter tolerance of joystick direction
#define DIRECTION_TOLERANCE 0.05

Serial serial (USBTX,USBRX);               // TEST OF JOYSTICK
N5110 lcd(p7, p8, p9, p10, p11, p13, p26); // N5110

int printFlag = 0;      

int Bird_X=5;           // define bird-x
int Bird_Y=20;          // define bird-y

int Wallup_x = 20;      //define UP wall-x
int Wallup_y = 1;       //define UP wall-Y
int Walldown_x = 60;    //define DOWN wall-x
int Walldown_y = 20;    //define DOWN wall-Y

//connections for button A nad button B
InterruptIn buttonA(p29);
InterruptIn buttonB(p28);

//connections for buzzer
PwmOut buzzer(p21);
//Jigglypuff's Song
float frequency[]= {440,659,554,440,492,554,600,554,494,554,440};
float beat[]= {1,3,3,3,1,3,1.5,1,3,1.5,0.5};          // speed x 1 (just choose one)
//float beat[]={2,6,6,6,2,6,3,2,6,3,1};               // speed x 2 (just choose one)
//float beat[]={3,9,9,9,3,9,4.5,3,9,4.5,1.5};         // speed x 3 (just choose one)

//connections for joystick
AnalogIn xPot(p15);
AnalogIn yPot(p16);

//timer to regularly read the joystick
Ticker pollJoystick;

// create enumerated type (0,1,2,3 etc. for direction)
// could be extended for diagonals etc.
enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
};

// struct for Joystick
typedef struct JoyStick Joystick;
struct JoyStick {
    float x;    // current x value
    float x0;   // 'centred' x value
    float y;    // current y value
    float y0;   // 'centred' y value
    int button; // button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  // current direction
};
// create struct variable
Joystick joystick;

// function prototypes
void calibrateJoystick();
void updateJoystick();

// read default positions of the joystick to calibrate later readings
void calibrateJoystick()
{
    //button.mode(PullDown);
    // must not move during calibration
    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}
void updateJoystick()
{
    // read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.x = xPot - joystick.x0;
    joystick.y = yPot - joystick.y0;
    // read button state
    //joystick.button = button;
    // calculate direction depending on x,y values
    // tolerance allows a little lee-way in case joystick not exactly in the stated direction
    if ( fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = CENTRE;

    } else if ( joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = DOWN;
        Bird_Y=Bird_Y+3; // The bird's down movement of Y-axis is 3 for each refresh time   [change the value here to change the value of joystick]

    } else if ( joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = UP;
        Bird_Y = Bird_Y-4; // The bird's up movement of Y-axis is 4 for each refresh time   [change the value here to change the value of joystick]

    } else if ( joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = RIGHT;

    } else if ( joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = LEFT;

    } else {
        joystick.direction = UNKNOWN;
    }
    printFlag = 1;
}

void Bird(int bird_x, int bird_y)   // Draw my bird
{
    for (int i=bird_y; i<=bird_y+5; i++) {
        lcd.setPixel(bird_x,i);     // left line of bird's body
        lcd.setPixel(bird_x+5,i);   // right line of bird's body
    }

    for (int j=bird_x+1; j<=bird_x+5; j++)

    {
        lcd.setPixel(j,bird_y);     // up line of bird's body
        lcd.setPixel(j,bird_y+5);   // down line of bird's body
    }

    lcd.setPixel(bird_x+3,bird_y+2);// eye of bird

    lcd.setPixel(bird_x-2,bird_y+3);// tail of bird
    lcd.setPixel(bird_x-2,bird_y+4);
    lcd.setPixel(bird_x-1,bird_y+4);

    lcd.setPixel(bird_x+6,bird_y+3);// mouth of bird
    lcd.setPixel(bird_x+6,bird_y+4);

    lcd.refresh();
}


void Wall(int x, int y)         // Drow the wall
{

    for (int k=1; k<=100; k++) {                        // set the time of wall
        for (int i=x; i<=x+8; i++) {                    // set teh width of wall      
            for (int j=y; j<=y+28; j++) {               // set the high of wall
                lcd.setPixel(80*k+i, j);                // present wall 
//-------------------------when bird hit on the wall-----------------------
                if (Bird_X == 80*k+i-6 && Bird_Y == j-3 ) {
                    lcd.clear();
                    lcd.printString("Game Over",15,2);
                    lcd.refresh();
                    wait(5.0);
                }
                
                else if (Bird_X == 80*k+i-5 && Bird_Y == j ) {
                    lcd.clear();
                    lcd.printString("Game Over",15,2);
                    lcd.refresh();
                    wait(5.0);
                }
                
                else if (Bird_X == 80*k+i-4 && Bird_Y == j ) {
                    lcd.clear();
                    lcd.printString("Game Over",15,2);
                    lcd.refresh();
                    wait(5.0);  
                }
                
                else if (Bird_X == 80*k+i-3 && Bird_Y == j ) {
                    lcd.clear();
                    lcd.printString("Game Over",15,2);
                    lcd.refresh();
                    wait(5.0);
                }
                
                else if (Bird_X == 80*k+i-2 && Bird_Y == j ) {
                    lcd.clear();
                    lcd.printString("Game Over",15,2);
                    lcd.refresh();
                    wait(5.0);
                }
                
                else if (Bird_X == 80*k+i-1 && Bird_Y == j ) {
                    lcd.clear();
                    lcd.printString("Game Over",15,2);
                    lcd.refresh();
                    wait(5.0);
                }
                
                else if (Bird_X == 80*k+i && Bird_Y == j ) {
                    lcd.clear();
                    lcd.printString("Game Over",15,2);
                    lcd.refresh();
                    wait(5.0);
                }
//-------------------------when bird hit on the wall-----------------------
            }
        }
    }
    lcd.refresh();
}

//------------------define button----------------------------------------------

//Button A
int buttonFlagA = 0;
//Button B
int buttonFlagB = 0;


void buttonAPressed()
{
    buttonFlagA = 1;
}


void buttonBPressed()
{
    buttonFlagB = 1;
}

//------------------define button----------------------------------------------

int main()
{
    lcd.init();

    //present the bird
    Bird(Bird_X , Bird_Y);

    // square of the screen
    lcd.drawLine(0,0,83,0,1);
    lcd.drawLine(0,47,83,47,1);
    lcd.drawLine(0,1,0,46,1);
    lcd.drawLine(83,1,83,46,1);

    // show the words of  "Flappy Bird"
    lcd.printString("Flappy",26,2);
    lcd.printString("Bird",32,4);

    lcd.refresh();

    // read the buzzer
   for (int i= 0; i< (sizeof(frequency) / sizeof(int)); i++) {
            buzzer.period(1.0 / frequency[i]);
            buzzer.write(0.5);
            wait(1.0 / beat[i]);
            buzzer.write(0);
            wait(0.05);
        }
    
    calibrateJoystick();                                    // get centred values of joystick
    pollJoystick.attach(&updateJoystick,1.0/10.0);          // read joystick 10 times per second

    int speed = 0;  //change speed of wall down

    buttonA.rise(&buttonAPressed);                          //buttonA rise
    buttonB.rise(&buttonBPressed);                          //buttonB rise                       

    while(1) {
        
        lcd.clear();
//---------------------------------------bird hit on top and bottom--------------------------

        if (Bird_Y <= -4) {
            lcd.printString("Game Over",15,2);
            lcd.refresh();
        } else if (Bird_Y >= 42) {
            lcd.printString("Game Over",15,2);
            lcd.refresh();
            wait(5);
        }
    else
        {
//---------------------------------------bird hit on top and bottom--------------------------

//---------------------button to change the speed of the wall--------------------------------
        

            if (buttonFlagA==1) {
                buttonFlagA=0;
                speed--;
                lcd.refresh();
            }

            if (buttonFlagB==1) {
                buttonFlagB=0;
                speed++;
                lcd.refresh();
            }

//---------------------button to change the speed of the wall---------------------------------

            lcd.drawLine(0,0,83,0,1);           //present the top line
            lcd.drawLine(0,47,83,47,1);         //present the botton line

            Bird_Y = Bird_Y + 2;
            Bird(Bird_X,Bird_Y);                //present the bird

            Wallup_x = Wallup_x + speed -1;     //up wall moving function
            Walldown_x = Walldown_x + speed -1; //down wall moving function 
            
            Wall(Wallup_x, Wallup_y);           //draw the wall
            Wall(Walldown_x, Walldown_y);       //draw the wall

            wait(0.1);
        }
    }
}
