/*#################################################################################

Program Name    : SIM808 GPS 
Author          : Crispin Mukalay
Date Modified   : 31/08/2018
Compiler        : ARMmbed
Tested On       : NUCLEO-F446RE

Description     : Demonstrates the use of the SIM808 Shield to read the GPS
                  satellite fix, latitude, longitude, MSL altitude, 
                  speed (Km/Hour) over ground coordinates and heading (0-360deg).
                  
Requirements    : * NUCLEO-F446RE Board
                  * SIM808 GSM/GPS Module
              
Circuit         : * The SIM808 module is connected as follows:
                    VCC/5V/VIN                      -   5V
                    GND                             -   GND
                    RXD                             -   PA0 (F446's Serial4_TX pin)
                    TXD                             -   PA1 (F446's Serial4_RX pin)

####################################################################################*/

#include "mbed.h"
#include "Adafruit_FONA.h"

Adafruit_FONA gps(PA_0, PA_1, PA_6, PA_7);     //Create a Adafruit_FONA object called gps
//                TX    RX    RST    RI
//Not all SIM808-based boards have a RST (Reset) and RI (Ring Indicator) pin,
//but when initializing the object one needs to specify them, even if they
//are not there.  In our case we just used two unused pins (PA_6 & PA_7) as "dummy" pins.

Serial pc(SERIAL_TX, SERIAL_RX);    //to use the PC as a console (display output)

int main() {
    
    int SIM808Success;
    bool gpsSuccess, gpsCoordinates;
    float fix, latitude, longitude, MSL_altitude, speed_kph, heading;
      
    pc.printf("Program Started...\n");
    
    /* create connection to SIM808 */
    pc.printf("\nConnecting to SIM808...\n");
    SIM808Success = gps.begin(9600);              //connect to SIM808 device at 9600 baud rate and return if successful(=1) or not (=0) 
    
    if(SIM808Success == 1) 
        pc.printf("\nSIM808 detected successfully...\n");
    else {
        pc.printf("\nSIM808 not detected!\n");
        while(1);                           //program stops/freezes at this point if SIM808 not detected
    }
    
    /* Enable GPS*/
    gpsSuccess = gps.enableGPS(true);
     
    if (gpsSuccess == true) 
       pc.printf("\nGPS enable successful...\n");
    else
       pc.printf("\nGPS enable failed!\n");
    
    
    while(1) {
        wait(2);
        
        /* Read coordinates from GPS*/
        gpsCoordinates = gps.getGPS(&fix, &latitude, &longitude, &MSL_altitude, &speed_kph, &heading);
        
        if(gpsCoordinates == true){
            
            if(fix == 1.0f){
                pc.printf("\n");
                pc.printf("Latitude: %.6f\n", latitude);
                pc.printf("Longitude: %.6f\n", longitude);
                pc.printf("MSL altitude: %.6f\n", MSL_altitude);
                pc.printf("Speed: %.6f kph\n", speed_kph);
                pc.printf("Heading: %.6f \n", heading);
            }else{
                pc.printf("Waiting for satellite fix...\n");
            }
                 
        }else{
            pc.printf("Waiting for satellite fix...\n");
        }
    }
}