#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"
#include "keller_pressure.h"
#include "sensirion_sf04.h"
#include "PID.h"
#include "coil-driver.h"
#include "VL6180.h"

//Timer From Start of the Script
Timer t1;
float t;

//High Speed Pressure
AnalogIn analog_value(A3);
Thread HighSpeedPressure;
float High_Speed_Pressure=0.00;

// Mbed application shield display
#include "C12832A1Z.h"
#include "Small_7.h"
#include "Fonts/ArialR12x14.h"

//C12832A1Z lcd(D11, D13, D12, D7, D10); // MOSI, SCK, Reset, A0, CS
// LCD width and height (minus 1)
#define lcdWidth 127
#define lcdHeight 31

// ISO/SEV pressure: 10psi, DES: 25-30psi
#define pumpSetPointPSI 45
#define pumpMinPSI 0
#define pumpMaxPSI 85
//#define pumpHystPSI 2

// Gas flow sensor defines
#define MAINFLOW_ADDR 0x40
#define LOOPFLOW_ADDR 0x40
// End gas flow sensor defines

// Liquid pump defines
// PID settings
#define pumpPIDRate .2 // Pump PID computation interval (seconds)
float pumpKp = 4.0;
float pumpKi = 1.0;
#define pumpKd 0
#define pumpPwmFrequency 1000 // Frequency of PWM signal supplied to pump
#define pumpTachPoles 6 // 6 pulses per revolution
#define pumpTachPin PA_10 // Pump tach input (green wire)
#define pumpCtrlPin PB_13 // Pump control (white wire)
// End Liquid pump defines

Thread print_process_values_t, update_pressures_t, update_flow1_t, update_flow2_t, update_shutoff_t;
Mutex i2c1_m, i2c2_m, i2c3_m, stdio_m;

Serial pc(USBTX, USBRX, 250000); // tx, rx, baud

// an I2C sub-class that provides a constructed default
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl, int freq) : I2C(sda, scl) {
        frequency(freq);
    };
};

//I2CPreInit gI2C1(I2C_SDA, I2C_SCL, I2C frequency);
I2CPreInit i2c1(PB_3, PB_10, 100000);

// Sensirion gas flow sensor object (i2c object, i2c address, calibration field, resolution 9-16 bit)
SF04 mainflow(i2c1, MAINFLOW_ADDR, 0, 16);
// Mbed application shield
AnalogIn pot2(A1);
PwmOut pump(pumpCtrlPin);

PID pump_control_PID(pumpKp, pumpKi, pumpKd, pumpPIDRate);

VL6180 level(i2c1); //I2C object
float agentlevel = 0;
#endif