#include "mbed.h"
#include "N5110.h"
#define dp23 P0_0

N5110 lcd(dp4, dp24, dp23, dp25, dp2, dp6, dp18);

AnalogIn VRx (dp11);
AnalogIn VRy (dp10);

InterruptIn SW (dp9);

Timer timer;
Timer seed;

Timeout t1, t2, cp;

struct Point
{
    int x;
    int y;    
};

Point p[9] = {{14, 9}, {41, 9}, {68, 9}, {14, 24}, {41, 24}, {68, 24}, {14, 39}, {41, 39}, {68, 39}};

int currentPointX = 1;
int currentPointY = 1;

int fields[9] = {0,0,0,0,0,0,0,0,0};
int computer, gameType = 1;
bool turnX = true;

enum State {Menu, Turn, AITurn, Pause, End};
State state = Menu;

bool canMove = true;

int winner;

int RandomNumber()
{
    return seed.read_ms();    
}

void DrawRow(int y)
{
    for(int i = 0; i < 84; i++)
    {
        lcd.setPixel(i, y);    
    }
}

void DrawColumn(int x)
{
    for(int i = 0; i < 48; i++)
    {
        lcd.setPixel(x, i);    
    }    
}

void DrawBorder()
{
    DrawRow(0);
    DrawRow(1);
    DrawRow(46);
    DrawRow(47);
    DrawColumn(0);
    DrawColumn(1);
    DrawColumn(82);
    DrawColumn(83);    
}

void DrawGrid()
{
    DrawBorder();
    DrawColumn(28);
    DrawColumn(55);
    DrawRow(16);
    DrawRow(31);    
}

void DrawX(int t)
{
    fields[t-1] = 1;
    int x = p[t-1].x;
    int y = p[t-1].y;
    lcd.setPixel(x,y);
    lcd.setPixel(x+1, y);
    lcd.setPixel(x, y-1);
    lcd.setPixel(x+1, y-1);
    for(int i = 0; i < 4; i++)
    {
        lcd.setPixel(x-1, y+1);
        lcd.setPixel(x+2, y+1);
        lcd.setPixel(x-1, y-2);
        lcd.setPixel(x+2, y-2);
        
        lcd.setPixel(x-2, y+2);
        lcd.setPixel(x+3, y+2);
        lcd.setPixel(x-2, y-3);
        lcd.setPixel(x+3, y-3);
        
        lcd.setPixel(x-3, y+3);
        lcd.setPixel(x+4, y+3);
        lcd.setPixel(x-3, y-4);
        lcd.setPixel(x+4, y-4); 
        
        lcd.setPixel(x-4, y+4);
        lcd.setPixel(x+5, y+4);
        lcd.setPixel(x-4, y-5);
        lcd.setPixel(x+5, y-5);      
    }
    lcd.refresh();  
}

void DrawO(int t)
{
    fields[t-1] = 2;
    int x = p[t-1].x;
    int y = p[t-1].y-1;
    for(int i = x-2; i < x+4; i++)
    {
        lcd.setPixel(i, y-4);
        lcd.setPixel(i, y+5);
    }
    
    for(int i = y-1; i < y+3; i++)
    {
        lcd.setPixel(x-5, i);
        lcd.setPixel(x+6, i);
    }
    for(int i = 0; i < 2; i++)
    {
        lcd.setPixel(x-4, y-2);
        lcd.setPixel(x-3, y-3);
        
        lcd.setPixel(x-4, y+3);
        lcd.setPixel(x-3, y+4);
        
        lcd.setPixel(x+5, y-2);
        lcd.setPixel(x+4, y-3);
        
        lcd.setPixel(x+5, y+3);
        lcd.setPixel(x+4, y+4);
    }
    lcd.refresh();
}

void DrawSelector(int t)
{
    int x = p[t-1].x;
    int y = p[t-1].y-1;
    
    for(int i = x-11; i < x+13; i++)
    {
        lcd.setPixel(i, y-6);
        lcd.setPixel(i, y+7);    
    }
    
    for(int i = y-5; i < y+7; i++)
    {
        lcd.setPixel(x-12, i);
        lcd.setPixel(x+13, i);    
    }
    lcd.refresh();
}

void DeleteSelector(int t)
{
    int x = p[t-1].x;
    int y = p[t-1].y-1;
    
    for(int i = x-11; i < x+13; i++)
    {
        lcd.clearPixel(i, y-6);
        lcd.clearPixel(i, y+7);    
    }
    
    for(int i = y-5; i < y+7; i++)
    {
        lcd.clearPixel(x-12, i);
        lcd.clearPixel(x+13, i);    
    }
    lcd.refresh();
}

bool WinX(){
    if(fields[0]==1 && fields[1]==1 && fields[2]==1) return true;
    else if(fields[3]==1 && fields[4]==1 && fields[5]==1) return true;    
    else if(fields[6]==1 && fields[7]==1 && fields[8]==1) return true;
    else if(fields[0]==1 && fields[3]==1 && fields[6]==1) return true;
    else if(fields[1]==1 && fields[4]==1 && fields[7]==1) return true;
    else if(fields[2]==1 && fields[5]==1 && fields[8]==1) return true;
    else if(fields[0]==1 && fields[4]==1 && fields[8]==1) return true;
    else if(fields[2]==1 && fields[4]==1 && fields[6]==1) return true;
    return false;
}
bool WinO(){
    if(fields[0]==2 && fields[1]==2 && fields[2]==2) return true;
    else if(fields[3]==2 && fields[4]==2 && fields[5]==2) return true;    
    else if(fields[6]==2 && fields[7]==2 && fields[8]==2) return true;
    else if(fields[0]==2 && fields[3]==2 && fields[6]==2) return true;
    else if(fields[1]==2 && fields[4]==2 && fields[7]==2) return true;
    else if(fields[2]==2 && fields[5]==2 && fields[8]==2) return true;
    else if(fields[0]==2 && fields[4]==2 && fields[8]==2) return true;
    else if(fields[2]==2 && fields[4]==2 && fields[6]==2) return true;
    return false;
}

bool TieCheck()
{
    for(int i = 0; i < 9; i++)
    {
        if(fields[i] == 0)
            return false;    
    }    
    return true;
}

void Start();

void Reset()
{
    state = Menu;
    SW.rise(&Start);
    for(int i = 0; i < 9; i++)
        fields[i] = 0;
    currentPointX = 1;
    currentPointY = 1; 
    turnX = true;  
    gameType = 1;
}


void DrawMeni(){
    Reset();
    lcd.clear();
    DrawBorder();
    lcd.printString ("TIC-TAC-TOE" , 10,1);
    lcd.printString ("1 player " , 20,3);
    lcd.printString ("2 players" , 20,4);
    lcd.setPixel(15, 28);
    lcd.setPixel(15, 27);
    lcd.setPixel(14, 27);
    lcd.setPixel(14, 28);
    lcd.refresh();
}    
void DrawWin(){
    state = End;
    lcd.clear();
    DrawBorder();
    if(winner == 0) 
    {
        lcd.printString("Winner is" ,15 ,2);
        if(gameType == 0)
            lcd.printString("Player 1" ,15 ,4);
        else
            lcd.printString("Player" ,15 ,4);
    }
    if(winner == 1) 
    {
        lcd.printString("Winner is" ,15 ,2);
        if(gameType == 0)
            lcd.printString("Player 2" ,15 ,4);
        else
            lcd.printString("Player" ,15 ,4);
    }
    if(winner == 2) 
    {
        lcd.printString("Winner is" ,15 ,2);
        lcd.printString("Computer" ,15 ,4);
    }
    if(winner == 3) lcd.printString ("It's a tie!" ,15 ,3);
    lcd.refresh();
    t2.attach(&DrawMeni, 3.0);
}

void ComputerTurn()
{
    if(state != AITurn)
        return;
    int field = -1;
    int player = (computer%2)+1;
    if(fields[0] == computer)
    {
        if(fields[1] == computer && fields[2] == 0)
        {
            field = 2;
        }
        else if(fields[2] == computer && fields[1] == 0)
        {
            field = 1;
        }
        else if(fields[3] == computer && fields[6] == 0)
        {
            field = 6;
        }
        else if(fields[6] == computer && fields[3] == 0)
        {
            field = 3;
        }
        else if(fields[4] == computer && fields[8] == 0)
        {
            field = 8;
        }
        else if(fields[8] == computer && fields[4] == 0)
        {
            field = 4;
        }      
    }
    if(fields[1] == computer && field == -1)
    {
        if(fields[4] == computer && fields[7] == 0)
        {
            field = 7;
        }
        else if(fields[7] == computer && fields[4] == 0)
        {
            field = 4;
        }
        else if(fields[2] == computer && fields[0] == 0)
        {
            field = 0;
        }
    }
    if(fields[2] == computer && field == -1)
    {
        if(fields[5] == computer && fields[8] == 0)
        {
            field = 8;
        }
        else if(fields[8] == computer && fields[5] == 0)
        {
            field = 5;
        }
        else if(fields[4] == computer && fields[6] == 0)
        {
            field = 6;
        }
        else if(fields[6] == computer && fields[4] == 0)
        {
            field = 4;
        }
    }
    if(fields[3] == computer && field == -1)
    {
        if(fields[6] == computer && fields[0] == 0)
        {
            field = 0;
        }
        else if(fields[4] == computer && fields[5] == 0)
        {
            field = 5;
        }
        else if(fields[5] == computer && fields[4] == 0)
        {
            field = 4;
        }
    }
    if(fields[4] == computer && field == -1)
    {
        if(fields[5] == computer && fields[3] == 0)
        {
            field = 3;
        }
        else if(fields[7] == computer && fields[1] == 0)
        {
            field = 1;
        }
        else if(fields[8] == computer && fields[0] == 0)
        {
            field = 0;
        }
        else if(fields[6] == computer && fields[2] == 0)
        {
            field = 2;
        }
    }
    if(fields[5] == computer && field == -1)
    {
        if(fields[8] == computer && fields[2] == 0)
        {
            field = 2;
        }
    }
    if(fields[6] == computer && field == -1)
    {
        if(fields[7] == computer && fields[8] == 0)
        {
            field = 8;
        }
        if(fields[8] == computer && fields[7] == 0)
        {
            field = 7;
        }
    }
    if(fields[7] == computer && field == -1)
    {
        if(fields[8] == computer && fields[6] == 0)
        {
            field = 6;
        }
    }
    if(fields[0] == player)
    {
        if(fields[1] == player && fields[2] == 0)
        {
            field = 2;
        }
        else if(fields[2] == player && fields[1] == 0)
        {
            field = 1;
        }
        else if(fields[3] == player && fields[6] == 0)
        {
            field = 6;
        }
        else if(fields[6] == player && fields[3] == 0)
        {
            field = 3;
        }
        else if(fields[4] == player && fields[8] == 0)
        {
            field = 8;
        }
        else if(fields[8] == player && fields[4] == 0)
        {
            field = 4;
        }      
    }
    if(fields[1] == player && field == -1)
    {
        if(fields[4] == player && fields[7] == 0)
        {
            field = 7;
        }
        else if(fields[7] == player && fields[4] == 0)
        {
            field = 4;
        }
        else if(fields[2] == player && fields[0] == 0)
        {
            field = 0;
        }
    }
    if(fields[2] == player && field == -1)
    {
        if(fields[5] == player && fields[8] == 0)
        {
            field = 8;
        }
        else if(fields[8] == player && fields[5] == 0)
        {
            field = 5;
        }
        else if(fields[4] == player && fields[6] == 0)
        {
            field = 6;
        }
        else if(fields[6] == player && fields[4] == 0)
        {
            field = 4;
        }
    }
    if(fields[3] == player && field == -1)
    {
        if(fields[6] == player && fields[0] == 0)
        {
            field = 0;
        }
        else if(fields[4] == player && fields[5] == 0)
        {
            field = 5;
        }
        else if(fields[5] == player && fields[4] == 0)
        {
            field = 4;
        }
    }
    if(fields[4] == player && field == -1)
    {
        if(fields[5] == player && fields[3] == 0)
        {
            field = 3;
        }
        else if(fields[7] == player && fields[1] == 0)
        {
            field = 1;
        }
        else if(fields[8] == player && fields[0] == 0)
        {
            field = 0;
        }
        else if(fields[6] == player && fields[2] == 0)
        {
            field = 2;
        }
    }
    if(fields[5] == player && field == -1)
    {
        if(fields[8] == player && fields[2] == 0)
        {
            field = 2;
        }
    }
    if(fields[6] == player && field == -1)
    {
        if(fields[7] == player && fields[8] == 0)
        {
            field = 8;
        }
        if(fields[8] == player && fields[7] == 0)
        {
            field = 7;
        }
    }
    if(fields[7] == player && field == -1)
    {
        if(fields[8] == player && fields[6] == 0)
        {
            field = 6;
        }
    }
    if(field == -1)
    {
        do{
            field = RandomNumber()%9;
        }
        while(fields[field] != 0);  
    }
    
    if(turnX)
        DrawX(field+1);
    else 
        DrawO(field+1);
        
    if(WinX() || WinO())
    {
        state = End;
        winner = 2;
        t1.attach(&DrawWin, 1.0);
    }
    else if(TieCheck())
    {
        state = End;
        winner = 3; 
        t1.attach(&DrawWin, 1.0);   
    }
    
    state = Turn;
    turnX = !turnX;
}

void Move()
{
    if(state != Turn && state != Menu)
        return;
    if(state == Turn)
    {    
        if(VRy > 1.0/3.0 && VRy < 2.0/3.0 && canMove)
            {
                bool change = false;
                bool inc;
                if(VRx < 1.0/3.0 && currentPointX > 0)
                {
                    currentPointX--;
                    inc = false;
                    change = true;
                    canMove = false;
                }
                
                if(VRx > 2.0/3.0 && currentPointX < 2)
                {
                    currentPointX++;
                    inc = true;
                    change = true; 
                    canMove = false;   
                }
                
                if(change)
                {
                    if(!inc)
                    {
                        DeleteSelector(currentPointY*3 + currentPointX+2);    
                    }
                    else
                    {
                        DeleteSelector(currentPointY*3 + currentPointX);  
                    }
                    DrawSelector(currentPointY*3 + currentPointX+1);
                }
            }
            else if(VRx > 1.0/3.0 && VRx < 2.0/3.0 && canMove)
            {
                bool change = false;
                bool inc;
                if(VRy < 1.0/3.0 && currentPointY > 0)
                {
                    currentPointY--;
                    inc = false;
                    change = true;
                    canMove = false;
                }
                
                if(VRy > 2.0/3.0 && currentPointY < 2)
                {
                    currentPointY++;
                    inc = true;
                    change = true; 
                    canMove = false;   
                }
                
                if(change)
                {
                    if(!inc)
                    {
                        DeleteSelector((currentPointY+1)*3 + currentPointX+1);    
                    }
                    else
                    {
                        DeleteSelector((currentPointY-1)*3 + currentPointX+1);  
                    }
                    DrawSelector(currentPointY*3 + currentPointX+1);
                }
            }
            else if(!canMove && VRx > 1.0/3.0 && VRx < 2.0/3.0 && VRy > 1.0/3.0 && VRy < 2.0/3.0)
            {
                canMove = true;
            }
        }
        else if(state == Menu)
        {
            if(VRy < 1.0/3.0 && gameType == 1)
            {
                gameType = 0;
                lcd.setPixel(15, 35);
                lcd.setPixel(15, 34);
                lcd.setPixel(14, 34);
                lcd.setPixel(14, 35);
                lcd.clearPixel(15, 28);
                lcd.clearPixel(15, 27);
                lcd.clearPixel(14, 27);
                lcd.clearPixel(14, 28);
                lcd.refresh();
            }
            
            if(VRy > 2.0/3.0 && gameType == 0)
            {
                gameType = 1;
                lcd.setPixel(15, 28);
                lcd.setPixel(15, 27);
                lcd.setPixel(14, 27);
                lcd.setPixel(14, 28);
                lcd.clearPixel(15, 35);
                lcd.clearPixel(15, 34);
                lcd.clearPixel(14, 34);
                lcd.clearPixel(14, 35);
                lcd.refresh();
            }
        }
}

void PlayerTurn()
{
    if(state != Turn)
        return;
    int f = currentPointY*3 + currentPointX;
    if(fields[f] != 0)
    {
        return;
    }
     
    state = Pause; 
     
    if(turnX == true)
        DrawX(f+1);
    else
        DrawO(f+1);
        
    turnX = !turnX;
     
    if(WinX())
    {
        if(gameType == 0){
            winner = 0;
        }
        else{
            if(computer != 1)
                winner = 0;
            else
                winner = 2;
        }
        state = End;
        t1.attach(&DrawWin, 1.0);    
    }
    else if(WinO())
    {
        if(gameType == 0){
            winner = 1;
        }
        else{
            if(computer != 2)
                winner = 1;
            else
                winner = 2;
        }
        state = End;
        t1.attach(&DrawWin, 1.0);
    }
    else if(TieCheck())
    {
        state = End;
        winner = 3;
        t1.attach(&DrawWin, 1.0); 
    }else{  
        if(gameType == 1)
        {
            state = AITurn;
            cp.attach(&ComputerTurn, 0.5);
        }
        else 
        {
            state = Turn;    
        }     
    }
}

void Start()
{
    if(state != Menu)
        return;
    state = Pause;
    timer.start();
    lcd.clear();
    DrawBorder();
    DrawGrid();
    DrawSelector(5);
    
    if(gameType == 1)
    {
        computer = RandomNumber()%2+1;
        if(computer == 1)
        {
            state = AITurn;
            wait(0.5);
            ComputerTurn();
        }
        else
        {
            state = Turn;    
        }
    }
    else
    {
        state = Turn;    
    }
    lcd.refresh();
}

int main() {
    state = Menu;
    lcd.init();
    lcd.refresh();
    SW.mode(PullUp);
    DrawMeni();
    seed.start();
    while(1) {
        Move();
        if(timer.read_ms() > 1000)
        {
            SW.rise(&PlayerTurn);
            timer.reset();
            timer.stop();
        }
        if(seed.read_ms() == 100000)
        {
            seed.reset();
            seed.start();
        }
    }
}
