const express = require('express');
const router = express.Router();

const User = require('../models/user');

router.post('/add', async (req, res) => {
    if (!req.body.rfid || !req.body.firstName || !req.body.lastName) {
        return res.status(400).send('All required data not found in header');
    }

    const newUser = new User({
        rfID: req.body.rfid,
        firstName: req.body.firstName,
        lastName: req.body.lastName
    });

    await newUser.save();
    return res.status(200).send('User saved in database');
});

router.post('/addBalance', async (req, res) => {
    if (!req.body.rfid) {
        return res.status(400).send('RFID ID not found in header');
    }

    User.findOne({ rfID: req.body.rfid }, (err, foundUser) => {
        if (err) {
            console.log(err);
            return res.status(400).send('Some error occured');
        }

        if (foundUser === null) {
            return res.status(400).send('User not found');
        }

        foundUser.addToBalance(req.body.amount);
        return res.status(200).send('Balance updated');
    });
});

router.post('/takeBalance', async (req, res) => {
    if (!req.body.rfid) {
        return res.status(400).send('RFID ID not found in header');
    }

    User.findOne({ rfID: req.body.rfid }, (err, foundUser) => {
        if (err) {
            console.log(err);
            return res.status(400).send('Some error occured');
        }

        if (foundUser === null) {
            return res.status(400).send('User not found');
        }

        //User.updateOne({ _id: foundUser._id }, ())

        foundUser.takeFromBalance(req.body.amount);
        return res.status(200).send('Balance updated');
    });
});

router.post('/swipeCard', (req, res) => {
    if (!req.body.rfid) {
        return res.status(403).send('Access Unauthorized');
    }

    User.findOne({ rfID: req.body.rfid }, (err, foundUser) => {
        if (err) {
            console.log(err);
            return res.status(400).send('Some error occured');
        }

        if ('timeEntered' in foundUser && foundUser['timeEntered'] !== null) {
            const code = foundUser.checkout();
            return res.sendStatus(code);
        }

        foundUser.checkin();
        return res.status(200).send('User checked in');
    });
});

router.get('/getUser', (req, res) => {
    if (!req.query.rfid) {
        return res.status(403).send('Access Unauthorized');
    }

    User.findOne({ rfID: req.query.rfid }).lean().exec((err, foundUser) => {
        if (err) {
            console.log(err);
            return res.status(400).send('Some error occured');
        }

        res.status(200).json(foundUser);
    });
});

module.exports = router;




var express = require('express');
var router = express.Router();

/* GET home page. */
router.get('/', function(req, res, next) {
  res.render('index', { title: 'Express' });
});

module.exports = router;

const mongoose = require('mongoose');
const Schema = mongoose.Schema;

const userShema = new Schema({
    rfID: {
        type: String,
        required: true
    },
    firstName: {
        type: String,
        required: true
    },
    lastName: {
        type: String,
        required: true
    },
    balance: {
        type: Number,
        required: true,
        default: 0,
        min: 0
    },
    timeEntered: {
        type: Date,
        required: false,
        default: null
    }
});

userShema.methods.addToBalance = function(amount) {
    console.log(this.balance, Number(amount));
    this.balance = this.balance + Number(amount);
    this.save();
};

userShema.methods.takeFromBalance = function(amount) {
    this.balance = this.balance - Number(amount);
    this.save();
};

userShema.methods.checkin = function() {
    this.timeEntered = Date.now();
    this.save();
}

userShema.methods.checkout = function() {
    const timeSpent = Math.round((Date.now() - this.timeEntered) / 1000 / 10) + 1;
    console.log(timeSpent);
    if (this.balance >= timeSpent) {
        this.balance -= timeSpent;
        this.timeEntered = null;
        this.save();

        return 200;
    }

    return 400;
}

const User = mongoose.model('user', userShema);

module.exports = User;