#include "mbed.h"

#include "stdio.h"
#include "SPI_TFT_ILI9341.h"
#include "Arial28x28.h"

SPI_TFT_ILI9341 TFT(D11, D12, D13, D4, D3, D5, "TFT");
//mosi, miso, clk, cs, res, dc

//240x320
unsigned char pticaBitmap[]={0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x08,0x7d,0x29,0x4e,0x08,0x7a,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x18,0xcd,0x08,0x61,0x10,0xa7,0x00,0x3f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x08,0x68,0x08,0x61,0x08,0x41,0x10,0xb1,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x18,0xff,0x18,0xdf,0x00,0x1f,0x00,0x1f,0x10,0xb1,0x08,0x41,0x08,0x41,0x08,0x62,0x08,0x78,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x08,0x5d,0x18,0xd3,0x21,0x2b,0x21,0x25,0x10,0x82,0x10,0xa2,0x29,0x47,0x18,0xed,0x10,0xb6,0x18,0xee,0x08,0x61,0x08,0x41,0x18,0xc6,0x00,0x1e,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x3f,0x21,0x31,0x10,0xa3,0x4a,0x21,0x94,0x21,0xbd,0x60,0xd6,0x21,0xcd,0xc0,0xb5,0x20,0x7b,0xa1,0x21,0x01,0x29,0x46,0x21,0x24,0x08,0x41,0x08,0x41,0x18,0xef,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x10,0xbc,0x18,0xe8,0x52,0x41,0xcd,0xe0,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xee,0xe0,0x6b,0x41,0x08,0x61,0x08,0x61,0x08,0x41,0x08,0x41,0x08,0x41,0x08,0x61,0x10,0xb8,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x08,0x7c,0x10,0x85,0x8b,0xe1,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xf7,0x00,0x5a,0xa1,0x31,0xa6,0xce,0x78,0xef,0x7c,0xa5,0x33,0x18,0xe3,0x08,0x61,0x08,0x61,0x10,0xa6,0x08,0x5f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x08,0x5c,0x10,0x73,0x08,0x72,0x10,0x90,0x10,0xb0,0x08,0x72,0x10,0x87,0x5a,0xc1,0xee,0xe0,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xa4,0xc0,0x29,0x65,0xef,0x5b,0xff,0xfd,0xff,0xfd,0xff,0xfd,0xde,0xd9,0x31,0x65,0x08,0x61,0x08,0x41,0x18,0xd5,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x21,0x2a,0x31,0x85,0x42,0x27,0x5a,0xa8,0x52,0x88,0x42,0x27,0x39,0xc5,0x10,0xa2,0x21,0x01,0x8c,0x00,0xee,0xe0,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xf7,0x00,0x42,0x01,0xad,0x54,0xff,0xdd,0xff,0xfd,0xff,0xfd,0xff,0xfd,0xff,0xfd,0xde,0xd9,0x18,0xe3,0x08,0x41,0x18,0xd5,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x21,0x0a,0xce,0x33,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xf7,0x77,0x9c,0xcf,0x21,0x24,0x4a,0x21,0xee,0xe0,0xf7,0x00,0xf7,0x00,0xf7,0x00,0x18,0xc2,0xef,0x3c,0xff,0xdd,0xff,0xfd,0xff,0xfd,0xff,0xfd,0xf7,0x9c,0x94,0x91,0x9c,0xd2,0x18,0xe6,0x00,0x3f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x18,0xec,0xb5,0x91,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xef,0x36,0x42,0x06,0x73,0x41,0xf7,0x00,0xf7,0x00,0xee,0xe0,0x29,0x45,0xef,0x5d,0xf7,0xbd,0xff,0xfd,0xff,0xfd,0xff,0xfd,0x94,0xb1,0x08,0x41,0xbd,0xd5,0x21,0x24,0x08,0x7c,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x10,0xaf,0x9c,0xae,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xe7,0x15,0x18,0xe2,0xd6,0x40,0xf7,0x00,0xef,0x00,0x18,0xc3,0xef,0x7d,0xf7,0x7d,0xff,0xfd,0xff,0xfd,0xff,0xfd,0x73,0x8d,0x08,0x61,0x94,0x91,0x73,0xae,0x18,0xf3,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x10,0x92,0x7b,0xcc,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0x73,0x8b,0x8c,0x00,0xf7,0x00,0xf7,0x00,0x31,0x61,0xce,0x58,0xef,0x5d,0xff,0xdd,0xff,0xfd,0xff,0xfd,0x7b,0xce,0x08,0x61,0x94,0xb1,0xb5,0xb5,0x21,0x0c,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x08,0x57,0x5a,0xc9,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xad,0x70,0x63,0x01,0xf7,0x00,0xf7,0x00,0x73,0x61,0x73,0x8d,0xef,0x5d,0xef,0x7d,0xff,0xdd,0xff,0xfd,0xb5,0x95,0x08,0x61,0xd6,0x98,0xe7,0x1a,0x18,0xc6,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x08,0x5c,0x29,0x64,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xbd,0xce,0x5a,0xc1,0xf7,0x00,0xf7,0x00,0xde,0x80,0x18,0xe1,0x8c,0x71,0xef,0x7d,0xef,0x5d,0xf7,0xbd,0xff,0xfd,0xc6,0x37,0xff,0xfd,0xff,0xdd,0x18,0xe4,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x08,0x5f,0x18,0xe5,0xde,0x8f,0xff,0xb3,0xff,0xb6,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb7,0xff,0xb3,0x8c,0x4a,0x7b,0x81,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xbd,0x80,0x18,0xe1,0x31,0x86,0x73,0xad,0x84,0x0f,0x73,0x8d,0x5a,0xca,0x52,0x89,0x39,0xe7,0x10,0x82,0x21,0x18,0x18,0xda,0x08,0x7e,0x00,0x1f
,0x00,0x1f,0x18,0xcb,0x63,0x07,0xff,0x91,0xff,0xb1,0xff,0xb3,0xff,0xb4,0xff,0xb5,0xff,0xb5,0xff,0xb2,0xf7,0x71,0x29,0x64,0xbd,0x80,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xf7,0x00,0x83,0xe1,0x08,0x61,0x08,0x61,0x08,0x61,0x08,0x61,0x08,0x61,0x08,0x41,0x08,0x41,0x08,0x41,0x08,0x61,0x08,0x61,0x10,0xa4,0x10,0x9b
,0x00,0x1f,0x10,0x91,0x08,0x61,0x94,0x6b,0xff,0x91,0xff,0xb1,0xff,0xb1,0xff,0xb1,0xff,0xb1,0xff,0x91,0x73,0x88,0x4a,0x21,0xf7,0x00,0xf7,0x00,0xf7,0x00,0xf7,0x00,0x9c,0x60,0x20,0x82,0x89,0x85,0x91,0xa5,0xa1,0xc5,0xa1,0xc5,0xa1,0xc5,0xa9,0xc6,0xc2,0x06,0xc2,0x06,0xda,0x47,0xda,0x47,0x71,0x44,0x10,0x8b
,0x00,0x1f,0x08,0x58,0x31,0x42,0x18,0xa1,0x5a,0xc7,0xc5,0xed,0xf7,0x71,0xff,0xb2,0xe6,0xf0,0x73,0x88,0x20,0xc1,0xd5,0xe0,0xf6,0xe0,0xf7,0x00,0xf7,0x00,0xde,0x60,0x18,0xc1,0xb1,0xe6,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xd2,0x27,0x18,0xe5
,0x00,0x1f,0x08,0x7f,0x31,0x44,0xcc,0xe1,0x5a,0x21,0x10,0x81,0x08,0x61,0x08,0x61,0x08,0x61,0x39,0x81,0xcc,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xc0,0x72,0xe1,0x61,0x24,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xda,0x47,0xd2,0x27,0xd2,0x27,0xd2,0x27,0xd2,0x27,0xd2,0x27,0x79,0x64,0x10,0xaa
,0x00,0x1f,0x00,0x1f,0x18,0xcb,0xbc,0x62,0xf5,0xa0,0xed,0x60,0xc4,0x80,0xc4,0x80,0xd5,0x00,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0x31,0x41,0xc2,0x06,0x59,0x03,0x28,0xa2,0x18,0x81,0x18,0x81,0x18,0x81,0x10,0x61,0x08,0x61,0x08,0x61,0x08,0x61,0x08,0x61,0x08,0x61,0x10,0x82,0x08,0x79
,0x00,0x1f,0x00,0x1f,0x10,0x96,0x5a,0x42,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0x39,0x61,0xb1,0xe6,0x99,0xa5,0x89,0x85,0x89,0x85,0x91,0xa5,0xa1,0xc5,0xa1,0xc5,0xa1,0xc5,0xa1,0xc5,0xb1,0xe6,0xc2,0x06,0xa1,0xc5,0x18,0x82,0x08,0x7e
,0x00,0x1f,0x00,0x1f,0x00,0x3f,0x21,0x06,0xcc,0xc1,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0x83,0x21,0x48,0xe3,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xe2,0x47,0xe2,0x47,0x40,0xe3,0x18,0xda
,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x08,0x76,0x41,0xc2,0xf5,0x81,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xed,0x60,0x29,0x21,0x51,0x03,0xc2,0x06,0xd2,0x27,0xd2,0x27,0xd2,0x27,0xd2,0x27,0xca,0x27,0xc2,0x06,0xb9,0xe6,0xb9,0xe6,0x91,0xa5,0x18,0x82,0x10,0x9d
,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x10,0xab,0x7a,0xe2,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xd5,0x00,0x41,0xa1,0x08,0x61,0x08,0x61,0x08,0x61,0x08,0x61,0x08,0x61,0x08,0x41,0x08,0x41,0x08,0x41,0x08,0x61,0x10,0xa3,0x18,0xd3,0x00,0x1f
,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x08,0x7e,0x10,0xa7,0x8b,0x42,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xdd,0x00,0xcc,0xc0,0x52,0x01,0x18,0xc8,0x21,0x1b,0x21,0x1b,0x21,0x1b,0x21,0x1b,0x18,0xdd,0x08,0x7f,0x00,0x1f,0x00,0x1f
,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x08,0x7c,0x18,0xc6,0x6a,0x82,0xe5,0x61,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xf5,0xa0,0xd4,0xe1,0x41,0xc1,0x18,0xc9,0x08,0x5e,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x08,0x7d,0x21,0x0b,0x20,0xc1,0x72,0xa1,0xa3,0xc1,0xc4,0xa1,0xdd,0x00,0xe5,0x40,0xd5,0x00,0xc4,0x81,0x9b,0xa1,0x5a,0x41,0x10,0x82,0x21,0x11,0x00,0x3f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x08,0x5a,0x18,0xef,0x21,0x09,0x18,0xe3,0x08,0x41,0x08,0x41,0x08,0x41,0x18,0xe4,0x21,0x0a,0x18,0xd2,0x08,0x5d,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f,0x00,0x1f
};

// koristena slika sa googla i konvertor  http://www.digole.com/tools/PicturetoC_Hex_converter.php

void skoci();
void reset();

AnalogIn analogni1(A0);

bool pause = false;
bool game_over = false;
bool latch = false;

void ucitajDzojstik() {

    float v1=analogni1*3.3;
    if (v1 > 2.8) {
        if (!latch) {
            skoci();
            if (pause) {
                game_over = true;
                reset();
            }
            latch = true;
        }
    } else latch = false;
}

void ekrantext() {
    const char * game_over_text[3] = {"Game over\n", "Pritisnite gore\n", "za restart\n"};
    const char * new_game[3] =  {"Nova igra\n", "Pritisnite gore\n", "za pocetak\n"};
    
    for (int i = 0; i < 3; i++) {
        TFT.locate(50, 50 + i*28);
        printf(game_over ? game_over_text[i] : new_game[i]);
    }
}



const int debljina = 40;
void pipa(int visina, int x, int boja) {
    TFT.line(x, 31, x, visina - debljina, boja);
    TFT.line(x, visina + debljina, x, 239, boja);
}

void nacrtajPticu(int x,int y){
    TFT.Bitmap(x,y,30,30,pticaBitmap);
}

int v_prva, v_druga;

bool prva = false;


int ptica, ptica_prosli, skok, scroll, score;

Ticker framer;

void frame();

void pocetniScreen();

void reset() {
    scroll = 320;
    
    pause = false;
    v_prva = 100;
    v_druga = 150;
    
    prva = false;
    
    ptica = 74;
    ptica_prosli = 30;
    skok = 0; 
    score = 0;
    pocetniScreen();
    framer.attach(frame, 1.0/60);
}

void skor() {
    TFT.locate(100,2);
    TFT.printf("%d\n", score);
}

void pocetniScreen(){
    TFT.background(Blue);
    TFT.cls();
    TFT.fillrect(0,0,320,30, Orange);
    TFT.background(Orange);
    TFT.foreground(Black);
    
    if (!game_over) {
        pause = true;
        ekrantext();
    }
    
    TFT.locate(2,2);
    printf("Score: \n");
    skor();
}



void skoci() { if (skok == 0) skok = 10; }

void frame() {
    ucitajDzojstik();
    if (pause) return;
    
    ptica_prosli = ptica;
    if (skok == 0) ptica+=2;
    else {
        ptica -= skok/2;
        skok--;
    }
    scroll--;
    if (scroll == -1) { 
        scroll = 319;
    }
    if (scroll == 159) prva = true;
    
    if (prva && (scroll == 160 || scroll == 0)) {
        score++;
        skor();
    }
    
    if (ptica >= 240-30 || ptica < 31) {
        pause = true;
        game_over = true;
        ekrantext();
        return;
    }
    
    int xprva1 = (scroll + 160) % 320;
    int xdruga1 = (scroll) % 320;
    
    int xprva2 = (xprva1 + 30) % 320;
    int xdruga2 = (xdruga1 + 30) % 320;
    
    int granica, visina;
    if (prva && xprva1 < xdruga1) {
        granica = xprva1;
        visina = v_prva;
    } else {
        granica =  xdruga1;
        visina = v_druga;
    }
    
    int xptica = 30; 
    
    bool vanix = xptica + 30 < granica;
    bool vaniy = ptica > visina - debljina && ptica + 30 < visina + debljina;
    if (!vanix && !vaniy) {
        pause = true;
        game_over = true;
        ekrantext();
        return;
    }
    
    
    // crtanje

    if (prva)
        pipa(v_prva, xprva1 , Green);    
    pipa(v_druga, xdruga1, Green);
    
    if (prva)
        pipa(v_prva, xprva2, Blue);
    pipa(v_druga, xdruga2, Blue);

    nacrtajPticu(xptica, ptica);
    if (ptica > ptica_prosli)
        TFT.fillrect(xptica, ptica_prosli, xptica + 30, ptica, Blue);
    
    if (ptica < ptica_prosli)
        TFT.fillrect(xptica, ptica+30, xptica + 30, ptica_prosli+30, Blue);
}

int main ()
{
    // Inicijalizacija ;
    TFT.claim(stdout);
    TFT.set_orientation(1);
    TFT.set_font((unsigned char *) Arial28x28);
    
    unsigned char * ptica = pticaBitmap;
    /*
    for (int i = 0; i < 30*30/4; i++) {
        char temp1 = ptica[i];
        ptica[i] = ptica[i+3];
        ptica[i+3] = temp1;
        
        char temp2 = ptica[i+1];
        ptica[i+1] = ptica[i+2];
        ptica[i+2] = temp2;
    }
    */
    
    for (int i = 0; i < 30*30*2; i++) {
        char temp1 = ptica[i];
        ptica[i] = ptica[i+1];
        ptica[i+1] = temp1;
    }
    

    
    unsigned short * ptica_short = (unsigned short *) ptica;
    /*
    for (int i = 0; i <30*30; i++) {
        //ptica_short[i] = ~ptica_short[i];
        if (ptica_short[i] == 0) ptica_short[i] = Blue;
    }
    */
    for (int red = 0; red < 15; red++) {
        for (int kol = 0; kol < 30; kol++) {
            int obrnuti = 30-red-1;
            unsigned short temp = ptica_short[red * 30 + kol];
            ptica_short[red * 30 + kol] = ptica_short[obrnuti * 30 + kol];
            ptica_short[obrnuti * 30 + kol] = temp;
        }
    }
    reset();
    //Ticker skok;
    //skok.attach(skoci, 0.5);
    
    while (1) {    
        
    }
}