#include "mbed.h"
//#include "stdio.h"
#include "SPI_TFT_ILI9341.h"
#include "string"
#include "Arial12x12.h"

#define _A 10
#define _B 11
#define _C 12
#define _D 13
#define _zvijezda 14
#define _taraba 15

#define dp23 P0_0

//Banggood 240x320

BusOut redovi(dp16, dp15, dp17, dp18);
BusIn kolone(dp9, dp10, dp11, dp13);

int daLiJeIsteklo(0);

int trenutniSati(0), trenutneMinute(0), trenutneSekunde(0);
int trenutniDan(14), trenutniMjesec(6), trenutnaGodina(2018);
int preostaliSati(-1), preostaleMinute(-1), preostaleSekunde(-1);
int preostaliDani(-1), preostaliMjeseci(-1), preostaleGodine(-1);
int mjeseciDuzina[] = {31,28,31,30,31,30,31,31,30,31,30,31};
//std::string mjeseciNaziv[] = {"Januar", "Februar", "Mart", "April", "Maj", "Juni", "Juli", "August", "Septembar", "Oktobar", "Novembar", "Decembar"};

//InterruptIn dugmeModifikacije(dp13);

//InterruptIn taster1(dp1);
//InterruptIn taster2(dp2);

Ticker tickerTastatura;
Ticker tickerVrijeme;

SPI_TFT_ILI9341 TFT(dp2, dp1, dp6, dp24, dp23, dp25, "TFT");

DigitalOut enable(dp14);

DigitalOut zvucnik(dp26);

int pritisnutoDugme(-1);

bool darkMode(true);
bool alarmAktivan(false);
bool vrijemeIsteklo(false);

bool postavljanjeVremena(false);
bool postavljanjeAlarma(false);

Timer timer;

int koraciPostavljanja(0);

const int tastatura[4][4] = 
{ 
    {1, 2, 3, _A}, 
    {4, 5, 6, _B}, 
    {7, 8, 9, _C},
    {_zvijezda, 0, _taraba, _D}
};

void updateDisplay() {
    
    TFT.set_orientation(1);
    //240x320
    if(darkMode) {
        TFT.background(Black);
        TFT.foreground(White);
    
    } else {
        //light mode
        TFT.background(White);
        TFT.foreground(Black);
    }
    
    TFT.cls();
    TFT.set_font((unsigned char *) Arial12x12);
    
    TFT.locate(112,50);
    printf("%02d:%02d", trenutniSati, trenutneMinute);

    TFT.locate(100,75);
    //onaj osjecaj kad nemas dovoljno rama pa moras hardkodirati
    if(trenutniMjesec == 1) {
        printf("Januar %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 2) {
        printf("Februar %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 3) {
        printf("Mart %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 4) {
        printf("April %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 5) {
        printf("Maj %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 6) {
        printf("Juni %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 7) {
        printf("Juli %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 8) {
        printf("August %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 9) {
        printf("Septembar %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 10) {
        printf("Oktobar %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 11) {
        printf("Novembar %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 12) {
        printf("Decembar %02d %04d", trenutniDan, trenutnaGodina);
    }
    //printf("%s %02d %04d", mjeseciNaziv[trenutniMjesec-1].c_str(), trenutniDan, trenutnaGodina);
    
    if(alarmAktivan) {
        TFT.locate(10,120);
        if(preostaliSati < 0) {
            vrijemeIsteklo = true;
            daLiJeIsteklo = 5;
            return;
            //printf("OOOOOOOOOOOO UpdateDisplay");
            //return;
        }
        
        if(preostaliSati == 0) {
            if(preostaleMinute == 0) {
                printf("Preostalo vrijeme: manje od 1 minute");
            } else {
                printf("Preostalo vrijeme: %d minuta", preostaleMinute);
            }
        } else if(preostaliSati%10 == 1) {
            printf("Preostalo vrijeme: %d sat i %d minuta", preostaliSati, preostaleMinute);
        } else if(preostaliSati%10 == 2 or preostaliSati%10 == 3 or preostaliSati%10 == 4) {
            printf("Preostalo vrijeme: %d sata i %d minuta", preostaliSati, preostaleMinute);
        } else {
            printf("Preostalo vrijeme: %d sati i %d minuta", preostaliSati, preostaleMinute);
        }
    }
    
    TFT.locate(10,195);
    printf("A - Postavi vrijeme i datum");
    
    TFT.locate(10,215);
    printf("B - Postavi alarm");
    
    TFT.locate(175,215);
    printf("D - Switch mode");
    
}

void meniPostavljanjeVremena() {
    
    TFT.cls();
    koraciPostavljanja = 12;
    TFT.locate(60,10);
    printf("Postavljanje vremena i datuma:");
    
    TFT.locate(60,110);
    printf("Vrijeme hh:ss -");
    
    TFT.locate(200,110);
    printf(":");
    
    TFT.locate(10,130);
    printf("Datum dd/mm/gggg -");
    
    TFT.locate(200,130);
    printf("/");
    
    TFT.locate(230,130);
    printf("/");
        
}

void meniPostavljanjeAlarma() {
    
    TFT.cls();
    koraciPostavljanja = 12;
    TFT.locate(90,10);
    printf("Postavljanje alarma:");
    
    TFT.locate(60,110);
    printf("Vrijeme hh:ss -");
    
    TFT.locate(200,110);
    printf(":");
    
    TFT.locate(10,130);
    printf("Datum dd/mm/gggg -");
    
    TFT.locate(200,130);
    printf("/");
    
    TFT.locate(230,130);
    printf("/");
        
}

void azurirajPostavljanjeVremena() {
    
    if(koraciPostavljanja == 12) {
        trenutniSati = 10*pritisnutoDugme;
        TFT.locate(178,110);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 11) {
        trenutniSati += pritisnutoDugme;
        TFT.locate(188,110);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 10) {
        trenutneMinute = 10*pritisnutoDugme;
        TFT.locate(204,110);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 9) {
        trenutneMinute += pritisnutoDugme;
        TFT.locate(214,110);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 8) {
        trenutniDan = 10*pritisnutoDugme;
        TFT.locate(170,130);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 7) {
        trenutniDan += pritisnutoDugme;
        TFT.locate(185,130);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 6) {
        trenutniMjesec = 10*pritisnutoDugme;
        TFT.locate(202,130);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 5) {
        trenutniMjesec += pritisnutoDugme;
        TFT.locate(215,130);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 4) {
        trenutnaGodina = 1000*pritisnutoDugme;
        TFT.locate(235,130);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 3) {
        trenutnaGodina += 100*pritisnutoDugme;
        TFT.locate(250,130);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 2) {
        trenutnaGodina += 10*pritisnutoDugme;
        TFT.locate(265,130);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 1) {
        trenutnaGodina += 1*pritisnutoDugme;
        TFT.locate(280,130);
        printf("%d", pritisnutoDugme);
    }
    
}

void azurirajPostavljanjeAlarma() {
    
    if(koraciPostavljanja == 12) {
        preostaliSati = 10*pritisnutoDugme;
        TFT.locate(178,110);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 11) {
        preostaliSati += pritisnutoDugme;
        TFT.locate(188,110);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 10) {
        preostaleMinute = 10*pritisnutoDugme;
        TFT.locate(204,110);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 9) {
        preostaleMinute += pritisnutoDugme;
        TFT.locate(214,110);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 8) {
        preostaliDani = 10*pritisnutoDugme;
        TFT.locate(170,130);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 7) {
        preostaliDani += pritisnutoDugme;
        TFT.locate(185,130);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 6) {
        preostaliMjeseci = 10*pritisnutoDugme;
        TFT.locate(202,130);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 5) {
        preostaliMjeseci += pritisnutoDugme;
        TFT.locate(215,130);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 4) {
        preostaleGodine = 1000*pritisnutoDugme;
        TFT.locate(235,130);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 3) {
        preostaleGodine += 100*pritisnutoDugme;
        TFT.locate(250,130);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 2) {
        preostaleGodine += 10*pritisnutoDugme;
        TFT.locate(265,130);
        printf("%d", pritisnutoDugme);
    } else if(koraciPostavljanja == 1) {
        preostaleGodine += 1*pritisnutoDugme;
        TFT.locate(280,130);
        printf("%d", pritisnutoDugme);
    }
    
}

void pritisnutoA() {
    
    if(!postavljanjeVremena and !postavljanjeAlarma) {
        postavljanjeVremena = true;
        
        meniPostavljanjeVremena();
        
    }
}

void pritisnutoB() {
    
    if(!postavljanjeVremena and !postavljanjeAlarma) {
        postavljanjeAlarma = true;
        
        meniPostavljanjeAlarma();
        
    }
}

void pritisnutoD() {
    
    if(!postavljanjeVremena and !postavljanjeAlarma) {
        darkMode = !darkMode;
        updateDisplay();
    }
    
}

void pritisnutBroj() {
    
    if(postavljanjeVremena) {
        
        azurirajPostavljanjeVremena();
        
        koraciPostavljanja--;
        if(koraciPostavljanja == 0) {
            trenutneSekunde = 0;
            postavljanjeVremena = false;
            wait(0.5);
            updateDisplay();
        }
        
    } else if(postavljanjeAlarma) {
        
        azurirajPostavljanjeAlarma();
        
        koraciPostavljanja--;
        if(koraciPostavljanja == 0) {
            preostaleSekunde = 0;
            preostaleSekunde -= trenutneSekunde;
            int hours = ((preostaleGodine-trenutnaGodina)*365 + (preostaliMjeseci-trenutniMjesec)*30 + preostaliDani-trenutniDan)*24 + preostaliSati-trenutniSati;
            int minutes = preostaleMinute-trenutneMinute;
            if(minutes < 0) {
                minutes += 60;
                hours--;
            }
            preostaliSati = hours;
            preostaleMinute = minutes;
            if(preostaleSekunde < 0) {
                preostaleMinute--;
                preostaleSekunde += 60;
            }
            alarmAktivan = true;
            postavljanjeAlarma = false;
            wait(0.5);
            updateDisplay();
        }
        
    }
    
}

void ocitaj() {
    for(int i = 0; i <= 3; i++) {
        redovi = 1 << i;  
            for(int j = 0; j <= 3; j++)
                if(kolone & (1 << j)) {
                    if(timer.read_ms() > 200) {
                    
                        pritisnutoDugme = tastatura[i][j];
                        
                        tickerTastatura.detach();
                        while(kolone & (1 << j));
                        tickerTastatura.attach(&ocitaj,0.01);
                        
                        if(pritisnutoDugme == _A) {
                            pritisnutoA();
                        } else if(pritisnutoDugme == _B) {
                            pritisnutoB();
                        } else if(pritisnutoDugme == _D) {
                            pritisnutoD();
                        } else if(pritisnutoDugme >= 0 and pritisnutoDugme <=9) {
                            pritisnutBroj();
                        }
                        timer.reset();
                        //TFT.locate(10,10);
                        //printf("Pritisnuto je dugme %d", pritisnutoDugme);
                        return;
                        
                    }
                    
                }
    }
    pritisnutoDugme = -1;
}

void updateFebruar() {

    if(trenutnaGodina%4 == 0) {
        if(trenutnaGodina%100 == 0 and trenutnaGodina%400 == 0 or trenutnaGodina%100 != 0) {
            mjeseciDuzina[1] = 29;
            return;
        }
    }
    mjeseciDuzina[1] = 28;
}

void updateVrijeme() {
    
    TFT.locate(112,50);
    printf("%02d:%02d", trenutniSati, trenutneMinute);

    

}


void updateDatum() {
    
    if(darkMode) {
        TFT.fillrect(95,73,300,90, Black);
    } else {
        TFT.fillrect(95,73,300,90, White);
    }
    
    TFT.locate(100,75);
    //onaj osjecaj kad nemas dovoljno rama pa moras hardkodirati
    if(trenutniMjesec == 1) {
        printf("Januar %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 2) {
        printf("Februar %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 3) {
        printf("Mart %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 4) {
        printf("April %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 5) {
        printf("Maj %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 6) {
        printf("Juni %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 7) {
        printf("Juli %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 8) {
        printf("August %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 9) {
        printf("Septembar %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 10) {
        printf("Oktobar %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 11) {
        printf("Novembar %02d %04d", trenutniDan, trenutnaGodina);
    } else if(trenutniMjesec == 12) {
        printf("Decembar %02d %04d", trenutniDan, trenutnaGodina);
    }

}

void updateVrijemeAlarma() {
    
    if(preostaliSati < 0) {
            vrijemeIsteklo = true;
            daLiJeIsteklo = 5;
            return;
            //printf("OOOOOOOOOOOO UpdateVrijemeAlarma");
            //return;
    }
    TFT.locate(10,120);
    if(preostaliSati == 0) {
        if(preostaleMinute == 0) {
            printf("Preostalo vrijeme: manje od 1 minute");
        } else {
            printf("Preostalo vrijeme: %d minuta", preostaleMinute);
        }
    } else if(preostaliSati%10 == 1) {
        printf("Preostalo vrijeme: %d sat i %d minuta", preostaliSati, preostaleMinute);
    } else if(preostaliSati%10 == 2 or preostaliSati%10 == 3 or preostaliSati%10 == 4) {
        printf("Preostalo vrijeme: %d sata i %d minuta", preostaliSati, preostaleMinute);
    } else {
        printf("Preostalo vrijeme: %d sati i %d minuta", preostaliSati, preostaleMinute);
    }

}

void vrijeme() {

    bool trebaUpdateVrijeme(false);
    bool trebaUpdateDatum(false);
    bool trebaUpdateVrijemeAlarma(false);
    if(!postavljanjeVremena) {
        trenutneSekunde++;
    
        if(trenutneSekunde == 60) {
            trenutneSekunde = 0;
            trenutneMinute++;
            trebaUpdateVrijeme = true;
            
            if(trenutneMinute == 60) {
                trenutneMinute = 0;
                trenutniSati++;
                
                if(trenutniSati == 24) {
                    trenutniSati = 0;    
                    trenutniDan++;
                    trebaUpdateDatum = true;
                    if(trenutniDan > mjeseciDuzina[trenutniMjesec-1]) {
                        trenutniDan = 1;
                        trenutniMjesec++;
                        
                        if(trenutniMjesec == 13) {
                            trenutniMjesec = 1;
                            trenutnaGodina++;
                            updateFebruar();
                        }
                        
                    }
                }
                
            }
            
        }
        updateFebruar();
        
        if(alarmAktivan) {
            preostaleSekunde--;
        
            if(preostaleSekunde == -1) {
                preostaleSekunde = 59;
                preostaleMinute--;
                trebaUpdateVrijemeAlarma = true;
                if(preostaleMinute == -1) {
                    preostaleMinute = 59;
                    preostaliSati--;
                    if(preostaliSati < 0) {
                        vrijemeIsteklo = true;
                        daLiJeIsteklo = 5;
                        return;
                    }
                }
            }
        
        }
        
        if(!postavljanjeAlarma) {
            //updateDisplay();
            
            if(trebaUpdateVrijeme) {
                updateVrijeme();
            }
            
            if(trebaUpdateDatum) {
                updateDatum();
            }
            
            if(trebaUpdateVrijemeAlarma) {
                updateVrijemeAlarma();
            }
        }
    }
}

void ugasiUredjaj() {
    tickerTastatura.detach();
    tickerVrijeme.detach();
    
    TFT.cls();
    TFT.locate(88, 40);
    printf("Alarm aktiviran!");
    TFT.locate(30, 80);
    printf("Uredjaj ce se ugasiti za: ");
    TFT.locate(305, 80);
    for(int i=3; i>0; i--) {
        printf("%d", i);
    }
}

void aktivirajAlarm() {
    tickerTastatura.detach();
    //tickerVrijeme.detach();
    
    TFT.cls();
    TFT.locate(88, 40);
    printf("Alarm aktiviran!");
    for(int i=5; i>0; i--) {
        TFT.locate(155, 80);
        printf("%d", i);
        wait(1);
    }
    
}

int main() {
    
    timer.start();
    enable = 1;
    tickerTastatura.attach(&ocitaj,0.01);
    tickerVrijeme.attach(&vrijeme, 1);
    
    //dugmeModifikacije.fall(&dugmeAFun);
    //taster1.fall(&fun);
    //taster2.fall(&fun);
    
    TFT.claim(stdout);
    TFT.set_orientation(1);
    TFT.background(Black);
    TFT.foreground(White);
    TFT.cls();
    TFT.set_font((unsigned char *) Arial12x12);
    //printf("Pritisnuto je dugme %d", pritisnutoDugme);
    updateDisplay();
    
    while(!vrijemeIsteklo or daLiJeIsteklo == 0) {
        wait(1);
        //TFT.locate(10,10);
        //printf("%d %d", vrijemeIsteklo, daLiJeIsteklo);
        if(vrijemeIsteklo or daLiJeIsteklo == 5) {
            aktivirajAlarm();
            tickerTastatura.attach(&ocitaj,0.01);
            alarmAktivan = false;
            updateDisplay();
            
            vrijemeIsteklo = false;
            daLiJeIsteklo = 0;
        }
    }
    
    //ugasiUredjaj();
}