# include "mbed.h"
# define dp23 P0_0
# include "stdio.h"
# include "SPI_TFT_ILI9341.h"
# include "string"
# include "Arial12x12.h"
#include "stdlib.h"
#include "time.h"

Timer t;

SPI_TFT_ILI9341 TFT ( dp2 , dp1 , dp6 , dp24 , dp23 , dp25 ," TFT ");
AnalogIn VRx1(dp11); 
AnalogIn VRy1(dp10);
InterruptIn SW1(dp9);

AnalogIn VRx2(dp4); 
AnalogIn VRy2(dp13);
InterruptIn SW2(dp15);

enum Pozicija{Centar, Desno, Lijevo, Gore, Dolje};
Pozicija pozicija1 = Centar, pozicija2 = Centar, pozicija = Centar;
Pozicija redSnakePos(Desno), yellowSnakePos(Lijevo);
//dimenzije prostora za igru;
int najmanja_x=0, najmanja_y=0, najveca_x=320, najveca_y=240;
int diff(0);
int multiply[2] = {10,  50};
int delay[2] = {300,100};
bool gubitnik(2);

void ReadDifficulty(){
    Pozicija izbor;
    if(VRx1 < 1.0 / 3.0) izbor=Lijevo;
    else if(VRx1 > 2.0 / 3.0) izbor=Desno;
    else if(VRx1>1.0/3.0 && VRx1<2.0/3.0  && VRy1>1.0/3.0 && VRy1<2.0/3.0) izbor = Centar;
    if(izbor != pozicija) pozicija = izbor;
}

void LarinIzbor(){
    ReadDifficulty();
    if(pozicija == Desno && diff < 1) diff++;
    else if(pozicija == Lijevo && diff > 0) diff--;
}

 void ReadPosition1(){
    Pozicija nova_pozicija1;            
    if(VRx1 < 1.0 / 3.0) nova_pozicija1=Lijevo;
    else if(VRx1 > 2.0 / 3.0) nova_pozicija1=Desno;
    else if(VRy1 < 1.0 / 3.0) nova_pozicija1=Gore;
    else if(VRy1  > 2.0 / 3.0) nova_pozicija1=Dolje;
   
    if(nova_pozicija1 != pozicija1){
        pozicija1 = nova_pozicija1;
    }
}

void ReadPosition2(){
    Pozicija nova_pozicija2;            
    if(VRx2 < 1.0 / 3.0) nova_pozicija2=Lijevo;
    else if(VRx2 > 2.0 / 3.0) nova_pozicija2=Desno;
    else if(VRy2 < 1.0 / 3.0) nova_pozicija2=Gore;
    else if(VRy2 > 2.0 / 3.0) nova_pozicija2=Dolje;
    
    if(nova_pozicija2 != pozicija2){
        pozicija2 = nova_pozicija2;
    }
}

//koordinate jednog dijela zmije ili njene hrane;
struct gameItem{
    int X;
    int Y;
};

//default velicina zmije;
unsigned int yellow_snake_velicina=5;
unsigned int red_snake_velicina=5;
bool sw1(true);

//sirina i duzina jednog dijela zimje ili njene hrane;
const unsigned int dimenzija=5;

//niz za dijelove zmije;
gameItem red_snake[100]; // random broj 100
gameItem yellow_snake[100];

//hrana
gameItem njamnjam;

//stanja igre;
enum GameState{Welcome, Begin, Proces, MainScreen, GameOver};

GameState stanje=Welcome;
//funkcije za ispis WelcomeScreena
void statScreen(){
    LarinIzbor();
    TFT.fillrect(10,20,310,220,Yellow);
    TFT.locate(70,70);
    TFT.set_font (( unsigned char *) Arial12x12);
    TFT.printf("Double Snake");
    TFT.locate(70,90);
    TFT.printf("Difficulty:");
    TFT.locate(70,130);
    TFT.printf("Press the button");
    TFT.locate(70,150);
    TFT.printf(" to start.");
}
void WelcomeScreen(){
    TFT.set_font (( unsigned char *) Arial12x12);
    TFT.fillrect(70,110,320,122,Yellow);
    TFT.locate(70,110);
    if(diff == 0) TFT.printf("Low");
    else if(diff == 1) TFT.printf("High");
}
//Funkcije za crtanje
void crtajCrvenuZmiju(){
    TFT.fillrect(red_snake[0].X, red_snake[0].Y, red_snake[0].X + dimenzija, red_snake[0].Y + dimenzija, Red);
    TFT.fillrect(red_snake[1].X, red_snake[1].Y, red_snake[1].X + dimenzija, red_snake[1].Y + dimenzija, Green);
    TFT.fillrect(red_snake[red_snake_velicina-1].X, red_snake[red_snake_velicina-1].Y, red_snake[red_snake_velicina-1].X + dimenzija, red_snake[red_snake_velicina-1].Y + dimenzija, Green);
    for(int i=1; i<red_snake_velicina; i++){
            TFT.rect(red_snake[i].X, red_snake[i].Y, red_snake[i].X + dimenzija, red_snake[i].Y + dimenzija, Red);
        }
}
void crtajZutuZmiju(){
    TFT.fillrect(yellow_snake[0].X, yellow_snake[0].Y, yellow_snake[0].X+dimenzija, yellow_snake[0].Y+dimenzija,Yellow);
    TFT.fillrect(yellow_snake[1].X, yellow_snake[1].Y, yellow_snake[1].X+dimenzija, yellow_snake[1].Y+dimenzija, Green);
    TFT.fillrect(yellow_snake[yellow_snake_velicina-1].X, yellow_snake[yellow_snake_velicina-1].Y, yellow_snake[yellow_snake_velicina-1].X+dimenzija, yellow_snake[yellow_snake_velicina-1].Y+dimenzija, Green);
    for(int i=1; i<yellow_snake_velicina; i++){
            TFT.rect(yellow_snake[i].X, yellow_snake[i].Y, yellow_snake[i].X+dimenzija, yellow_snake[i].Y+dimenzija, Yellow);
        }
    
}
void crtajHranu(){
    TFT.fillrect(njamnjam.X, njamnjam.Y, njamnjam.X + dimenzija, njamnjam.Y + dimenzija, Blue);    
}
//funkcija za slucajeve koji dovode do GameOver stanja
void Sudari(){
    //sudar zmije same sa sobom
    for(int i=1; i<red_snake_velicina; i++){
            if(red_snake[0].X == red_snake[i].X && red_snake[0].Y == red_snake[i].Y){
                stanje=GameOver;
                gubitnik = 0;
                }  
        }
    for(int i=1; i<yellow_snake_velicina; i++){
            if(yellow_snake[0].X == yellow_snake[i].X && yellow_snake[0].Y == yellow_snake[i].Y){
                stanje=GameOver;
                gubitnik = 1;
                }
                
        }
    //sudar zmije sa zidom
    if((red_snake[0].X < najmanja_x || red_snake[0].X > najveca_x || red_snake[0].Y < najmanja_y || red_snake[0].Y > najveca_y )) {
        stanje=GameOver;
        gubitnik = 0;
        }
    if((yellow_snake[0].X<najmanja_x || yellow_snake[0].X>najveca_x || yellow_snake[0].Y<najmanja_y || yellow_snake[0].Y>najveca_y )) {
        stanje=GameOver;
        gubitnik = 1;
        }
    // sudar dvije zmije
    for(int i=0; i<yellow_snake_velicina; i++){
            if(red_snake[0].X == yellow_snake[i].X && red_snake[0].Y == yellow_snake[i].Y){
                stanje=GameOver;
                
                }
        }
    for(int i=0; i<red_snake_velicina; i++){
            if(yellow_snake[0].X == red_snake[i].X && yellow_snake[0].Y == red_snake[i].Y){
                stanje=GameOver;
                }
        }
    
}
//funkcije za postavljanje hrane i zmija
void spawnFood(){
    njamnjam.X += 50;
    njamnjam.Y += 50;
    if(njamnjam.X > najveca_x) njamnjam.X = 10;
    if(njamnjam.Y > najveca_y) njamnjam.Y = 10;
}
void spawnSnake(){
    red_snake[0].X = najmanja_x + 4*dimenzija;
    red_snake[0].Y = najmanja_y;
    yellow_snake[0].X = najveca_x - 30;
    yellow_snake[0].Y = najveca_y-10;
    
    int defaultSize = 5;
    for(int i=1; i<defaultSize; i++){
        red_snake[i].X = red_snake[i-1].X - dimenzija; 
        red_snake[i].Y = red_snake[i-1].Y;
    }
    for(int i=1; i<defaultSize; i++){
        yellow_snake[i].X = yellow_snake[i-1].X + dimenzija; 
        yellow_snake[i].Y = yellow_snake[i-1].Y;
    }
    red_snake_velicina = defaultSize;
    yellow_snake_velicina = defaultSize;
    
}
void Setup(){
    redSnakePos=Desno;
    yellowSnakePos=Lijevo;
    spawnSnake();
    spawnFood();
    stanje=Proces;
}
//funkcija za ispis GameOver ekrana
void prodavnicaGame(){
    TFT.cls();
    TFT.locate(100,100);
    TFT.set_font (( unsigned char *) Arial12x12);
    TFT.printf("GAME OVER!");
    TFT.locate(100,150);
    TFT.printf("Score player 1: %d", (red_snake_velicina-5)*multiply[diff]);
    TFT.locate(100,170);
    TFT.printf("Score player 2: %d", (yellow_snake_velicina-5)*multiply[diff]);
    TFT.locate(120,190);
    if(gubitnik == 0) TFT.printf("Winner is: Yellow Player");
    else if(gubitnik == 1) TFT.printf("Winner is: Red Player");
    else{
        if(red_snake_velicina>yellow_snake_velicina) TFT.printf("Winner is: Red Player");
        else if(red_snake_velicina<yellow_snake_velicina) TFT.printf("Winner is: Yellow Player");
        else TFT.printf("Draw");
    }
}
//trenutak kad zmija pojede hranu
void JediBraco(){
    if(red_snake[0].X == njamnjam.X && red_snake[0].Y == njamnjam.Y){
            red_snake_velicina++;
            TFT.fillrect(njamnjam.X,njamnjam.Y, njamnjam.X + dimenzija, njamnjam.Y + dimenzija, Green);
            spawnFood();
        }
    if(yellow_snake[0].X == njamnjam.X && yellow_snake[0].Y == njamnjam.Y){
            yellow_snake_velicina++;
            TFT.fillrect(njamnjam.X,njamnjam.Y, njamnjam.X + dimenzija, njamnjam.Y + dimenzija, Green);
            spawnFood();
        }
}
void crtaj(){
    crtajCrvenuZmiju();
    crtajZutuZmiju();
    crtajHranu();
    Sudari();
}
//Funckije za upravljanje smjerom zmija
void redSnakeMovement(){
    ReadPosition1();
    if(pozicija1 == Desno && redSnakePos != Lijevo) {
        redSnakePos=Desno;
    }
    else if(pozicija1 == Lijevo && redSnakePos != Desno){
        redSnakePos = Lijevo;
    }
    else if(pozicija1 == Gore && redSnakePos != Dolje){
        redSnakePos = Gore;    
    }
    else if(pozicija1 == Dolje && redSnakePos != Gore){
        redSnakePos = Dolje;    
    }
}

void yellowSnakeMovement(){
    ReadPosition2();
    if(pozicija2 == Desno && yellowSnakePos != Lijevo) {
        yellowSnakePos=Desno;
    }
    else if(pozicija2 == Lijevo && yellowSnakePos != Desno){
        yellowSnakePos = Lijevo;
    }
    else if(pozicija2 == Gore && yellowSnakePos != Dolje){
        yellowSnakePos = Gore;    
    }
    else if(pozicija2 == Dolje && yellowSnakePos != Gore){
        yellowSnakePos = Dolje;    
    }
}

void snakeMovement(){
    redSnakeMovement();
    yellowSnakeMovement();
  //  Sudari();
    stanje=MainScreen;
}

void updateRedMovement(){
    TFT.rect(red_snake[red_snake_velicina-1].X, red_snake[red_snake_velicina-1].Y, red_snake[red_snake_velicina-1].X+dimenzija, red_snake[red_snake_velicina-1].Y+dimenzija,Green);
    for(int i=red_snake_velicina - 1; i > 0; i--){
            red_snake[i].X = red_snake[i-1].X;
            red_snake[i].Y = red_snake[i-1].Y;
        }
    if(redSnakePos == Lijevo) red_snake[0].X -= dimenzija;
    else if(redSnakePos == Desno) red_snake[0].X += dimenzija;
    else if(redSnakePos == Dolje) red_snake[0].Y += dimenzija;
    else if(redSnakePos == Gore) red_snake[0].Y -= dimenzija;
   // TFT.fillrect(red_snake[red_snake_velicina-1].X, red_snake[red_snake_velicina-1].Y, red_snake[red_snake_velicina-1].X+dimenzija, red_snake[red_snake_velicina-1].Y+dimenzija,Green);
}

void updateYellowMovement(){
    TFT.rect(yellow_snake[yellow_snake_velicina-1].X, yellow_snake[yellow_snake_velicina-1].Y, yellow_snake[yellow_snake_velicina-1].X+dimenzija, yellow_snake[yellow_snake_velicina-1].Y+dimenzija,Green);
    for(int i=yellow_snake_velicina - 1; i > 0; i--){
            yellow_snake[i].X = yellow_snake[i-1].X;
            yellow_snake[i].Y = yellow_snake[i-1].Y;
        }
    if(yellowSnakePos == Lijevo) yellow_snake[0].X -= dimenzija;
    else if(yellowSnakePos == Desno) yellow_snake[0].X += dimenzija;
    else if(yellowSnakePos == Dolje) yellow_snake[0].Y += dimenzija;
    else if(yellowSnakePos == Gore) yellow_snake[0].Y -= dimenzija;
   // TFT.fillrect(yellow_snake[yellow_snake_velicina-1].X, yellow_snake[yellow_snake_velicina-1].Y, yellow_snake[yellow_snake_velicina-1].X+dimenzija, yellow_snake[yellow_snake_velicina-1].Y+dimenzija,Green);
}

void updateMovement() {
    updateRedMovement();
    updateYellowMovement();
    JediBraco();
    //Sudari();
    stanje=Proces;
}
void Igraj(){
    stanje=Begin;
}
void Resetuj(){
    TFT.cls();
    stanje=Welcome;    
}
int main() {
    SW1.mode(PullUp);
    SW2.mode(PullUp);
    TFT.set_orientation(3);
    TFT.background(Green);
    TFT.foreground(Blue );
    TFT.cls();
    SW1.fall(&Igraj);
    SW2.fall(&Resetuj);
    stanje=Welcome;
    sw1=true;
    t.start();
    njamnjam.X=10;
    njamnjam.Y=30;
    while(1) {
            switch(stanje){
            case Welcome: 
                LarinIzbor();
                if(t.read_ms()%3000==0) {statScreen(); WelcomeScreen(); }
                break;
            case Begin:
                TFT.cls();
                Setup();
                break;
            case Proces:
                snakeMovement();
                wait_ms(5);
                break;
            case MainScreen:
                updateMovement();
                crtaj();
                wait_ms(delay[diff]);
                break;
            case GameOver:
                prodavnicaGame();
            }
    }
}