#include "myBitmap.h"

myBitmap::myBitmap () {
    clearMap();
}

int myBitmap::getBit (int x, int y) {
    if (x >= 0 && x < 84 && y >= 0 && y < 48) {
        return map[x][y/8] & (1 << y%8);    
    } else {
        return 0;
    }
}

void myBitmap::setBit0 (int x, int y) {
    if (x >= 0 && x < 84 && y >= 0 && y < 48) {
        map[x][y/8] &= ~(1 << y%8);
    }
}

void myBitmap::setBit1 (int x, int y) {
    if (x >= 0 && x < 84 && y >= 0 && y < 48) {
        map[x][y/8] |= (1 << y%8);
    }
}

int myBitmap::getByte (int x, int y) {
    if (x >= 0 && x < 84 && y >= 0 && y < 6) {
        return map[x][y];    
    } else {
        return 0;
    }
}

void myBitmap::setByte (int x, int y, unsigned char value) {
    if (x >= 0 && x < 84 && y >= 0 && y < 6 && value < 256) {
        map[x][y] = value;
    }
}
   
void myBitmap::clearMap () {
    for (int i(0); i < 84; i++) {
        for (int j(0); j < 6; j++) {
            map[i][j] = 0;
        }
    }
}