#include "mbed.h"
#include "N5110.h"
#include "myBitmap.h"
#define dp23 P0_0

//Nokia display(VCC,SCE,RST,DC,MOSI,SCLK,LED)
N5110 lcd(dp4, dp24, dp23, dp25, dp2, dp6, dp18);

//Analogni ulazi sa dzojstika
AnalogIn    VRx(dp11);
AnalogIn    VRy(dp10);

//Taster sa dzojstika
InterruptIn SW(dp9);

//Izlaz na led diode
DigitalOut enable(dp14);

//Serijski port (tx, rx)
Serial pc(USBTX, USBRX);

//Tickeri za blinkanje i joystick
Ticker tBlink;
Ticker tJoystick;

//timeri za debouncing
Timer debouncer;
Timer debouncer2;


unsigned int x = 0, y = 0;
bool isSet = true;
bool edit = false;
char c, temp;

myBitmap bitmap;


void Blink ();
void Joystick ();
void ClearBuffer();
void UcitajMapu();
void IspisiMapu();
void PosaljiMapu();
void tasterSW(void);

int main() {
    debouncer.start();
    debouncer2.start();
    SW.mode(PullUp);
    SW.rise(&tasterSW);                                  //interupt za taster na dzojstiku
    enable = 1;                                          //deaktivacija led
        
    tBlink.attach(&Blink, 0.4);                          //blinkaj na lokaciji (x, y) svakih 0.5 s
    tJoystick.attach(&Joystick, 0.2);                    //provjeravaj da li je dzojstik aktivan
    
    lcd.init();                                          //inicijalizacija displeja
    lcd.printString("Pocetak...", 0, 0);                 //provjera da li displej radi OK
    wait (1);
    lcd.clear();
    
    while(1) {
       if (pc.readable()) { 
            c = pc.getc();
            
            while (!(c == '1' || c == '2' || c == '3')) {
                c = pc.getc();
            }
            
            switch (c) {
                case '1':
                    UcitajMapu();                     
                    lcd.clear();
                    IspisiMapu();
                    ClearBuffer();
                    break;
                case '2':
                    edit = !edit;
                    ClearBuffer();
                    break;
                case '3':
                    PosaljiMapu();
                    ClearBuffer();
                    break;
            }
        }
    }
}

void Blink () {
    if (edit) {
        if(!isSet){    
            lcd.setPixel(x, y);
        } else {
            lcd.clearPixel(x, y);
        }
        lcd.refresh();
        wait (0.2);
        IspisiMapu();
        
        isSet = !isSet;
    }
    //IspisiMapu();
}

void Joystick () {
    if (edit) {
        int stariPiksel = bitmap.getBit(x, y), _x(x), _y(y);
        if (VRx < 1.0/3.0 && debouncer2.read_ms() >= 100) {
            _x--;
            debouncer2.reset();
        }
        else if (VRx > 2.0/3.0 && debouncer2.read_ms() >= 100) {
            _x++;
            debouncer2.reset();
        }
        
        if (VRy < 1.0/3.0 && debouncer2.read_ms() >= 100) {
            _y--;
            debouncer2.reset();
        }
        else if (VRy > 2.0/3.0 && debouncer2.read_ms() >= 100) {
            _y++;
            debouncer2.reset();
        }
        
        if (x != _x || y != _y) {                       //ako se desila promjena kursora koordinata, trebamo vratiti na staro stanje
            if (stariPiksel == 0) {
                bitmap.setBit0(x, y);
            } else {
                bitmap.setBit1(x, y);
            }
        }
        
        x = _x %= 84;
        y = _y %= 48;
        
        IspisiMapu();
    }
    
}

void ClearBuffer() { 
    while (pc.readable()) { 
        temp = pc.getc(); 
    }  
}

void UcitajMapu() {
    bitmap.clearMap();
    char temp;
    for(int i = 0; i < 84; i++){
        for(int j = 0; j < 6; j++){
            temp = pc.getc();
            bitmap.setByte(i, j, temp);
        }
    }
    ClearBuffer();
}

void IspisiMapu() {
    lcd.clear();
    for (int i = 0; i < 84; i++) {
        for (int j = 0; j < 48; j++) {
            if (bitmap.getBit(i, j) != 0) {
                lcd.setPixel(i, j);
            } else {
                lcd.clearPixel(i, j);
            }
        }
    }
    lcd.refresh();
}

void PosaljiMapu() {
    ClearBuffer();
    if(pc.writeable()){
        char temp;
        for (int i = 0 ; i < 84; i++) {
            for (int j = 0; j < 6; j++) {
                temp = bitmap.getByte(i,j);
                pc.putc(temp);
            }
        }
    }
}

void tasterSW() {
    if (debouncer.read_ms() >= 200) {                   //trenutni piksel/bit treba promijeniti
        if (bitmap.getBit(x, y) == 0) {                 //treba bit postaviti na 1
            bitmap.setBit1(x, y); 
        } else {                                        //treba bit postaviti na 0               
            bitmap.setBit0(x, y);
        }
        IspisiMapu();
    }
    debouncer.reset();
}
