#include "mbed.h"
#include "N5110.h"


#define dp23 P0_0
#define NUMOFMEASURES 15

DigitalIn switchButton(dp1);
DigitalOut enable(dp14);
AnalogIn aIn(dp9);
N5110 display(dp4, dp24, dp23, dp25, dp2, dp6, dp18);

int measureType(0), measureNum(0);
float measured[NUMOFMEASURES], avg(0);

void Button()
{
    static int oldValue(0);
    
    if(oldValue == 0 && switchButton == 1)
        measureType++;
        if(measureType==2) measureType = 0;
        
        oldValue = switchButton;
}

void TakeMeasure()
{
    if(measureNum < NUMOFMEASURES)
    {
        measured[measureNum] = aIn;
        measureNum++;
        return;
    }
    
    float sumOfMeasures(0);
    for(int i = 0; i < NUMOFMEASURES - 1; i++)
    {
        measured[i] = measured[i+1];
        sumOfMeasures+=measured[i];
    }
    
    measured[measureNum- 1] = aIn;
    sumOfMeasures+=aIn;
    avg = sumOfMeasures / NUMOFMEASURES;
}

void RefreshDisplay()
{
    char placeholder[10];
    
    
    if(measureType == 0)
    {
        sprintf(placeholder, "%.2f V", (avg * 3.3));  
    }else if (measureType == 1)
    {
        sprintf(placeholder, "%.2f Ohm", (10000*(avg)));
    }
    
    display.printString("                ", 0, 0); 
    display.printString(placeholder, 0, 0);
    
    
}


int main()
{
    enable = 1;
    display.init();
    
    display.printString("Agent 16796", 0 , 2);
    display.printString("Agent 17345", 0 , 3);
    while(1) {
        Button();
        TakeMeasure();
        RefreshDisplay();
        wait(0.1);
    }
    
    return 0;
}
