#include "mbed.h"
#include "MFRC522.h"
#include "ssd1306.h"


DigitalOut LedRed   (LED2);
DigitalOut LedGreen (LED1);
SSD1306 lcd (D7,D6);
Serial     pc(USBTX, USBRX);
MFRC522    RfChip   (D11, D12, D13, PTE0, D10);
Ticker tiempo1;
static const char tar[]={0xD7,0x4F,0x88,0x19};
static const char llav[]={0x27,0x57,0xC1,0x7B};
int q,a,b,h;
void conteo()
{
    if(h!=0) {
        q=q+1;
    }
}
int main(void)
{
    tiempo1.attach(&conteo,1);
    q=1590029272;
    q=q-((5*60)*60);
    lcd.init();
    lcd.speed (SSD1306::Fast);
    lcd.cls();
    lcd.locate (3,1);
    lcd.printf ("Escaner RF");
    lcd.locate (4,1);
    lcd.printf ("Andres Arevalo");
    lcd.locate (5,1);
    lcd.printf ("Andres castano");
    lcd.redraw();
    wait(3);
    lcd.cls();
    RfChip.PCD_Init();
    h=1;

    while (true) {
        
        set_time(q);
        lcd.locate (1,0);
        time_t seconds = time(NULL);
        lcd.printf("fecha %s",ctime(&seconds));
        lcd.redraw();
        
        LedRed   = 1;
        LedGreen = 1;
        char buffer2[32];
        strftime(buffer2, 32, "%m/%d/%y", localtime(&seconds));
        pc.printf("%s", buffer2);
        
        char buffer1[32];
        strftime(buffer1, 32, "%H:%M:%S", localtime(&seconds));
        pc.printf(" , %s", buffer1);
        pc.printf(" , 0 \n\r");

        if ( ! RfChip.PICC_IsNewCardPresent()) {
            wait_ms(500);
            continue;
        }
      
        LedRed   = 0;

        if ( ! RfChip.PICC_ReadCardSerial()) {
            wait_ms(500);
            continue;
        }

        lcd.cls();
        set_time(q);
        lcd.locate (1,0);
        lcd.printf("fecha %s",ctime(&seconds));
        lcd.redraw();

        LedRed   = 1;
        LedGreen = 0;
        
        a=0;
        b=0;
         for (uint8_t i = 0; i < RfChip.uid.size; i++) {
            
         if(uint8_t (tar[i])==RfChip.uid.uidByte[i]){
            a=a+1;
            }else{
                a=0;
                }
        }
         for (uint8_t i = 0; i < RfChip.uid.size; i++) {
            
         if(uint8_t (llav[i])==RfChip.uid.uidByte[i]){
            b=b+1;
            }else{
                b=0;
                }
        }
        
         strftime(buffer2, 32, "%m/%d/%y", localtime(&seconds));
        pc.printf("%s", buffer2);
        strftime(buffer1, 32, "%H:%M:%S", localtime(&seconds));
        pc.printf(" , %s", buffer1);
        pc.printf(" , ");
        
        lcd.locate (5,1);
        
        if(a==4){
            
        lcd.printf("Tarjeta          ");
        pc.printf("1");  
            }else if(b==4){
                lcd.printf("Lavero          ");  
                pc.printf("2");  
            }else{
                lcd.printf("Sitp             "); 
                pc.printf("3"); 
                }
                    
        lcd.locate (6,1);
        for (uint8_t i = 0; i < RfChip.uid.size; i++) {
            lcd.printf(" %x ", RfChip.uid.uidByte[i]);

        }
        pc.printf("\n\r");
        lcd.redraw();
        wait(1);
    }
}

