#include "mbed.h"
#include "HCSR04.h"
#include "rtos.h"
#include "Servo.h"
#include "max6675.h"
#include "TextLCD.h"
BusOut display7Seg(PTC10, PTC7, PTC6, PTC4, PTC0, PTB19, PTB18);
DigitalOut display1(PTC11);
DigitalOut display2(PTC13);

HCSR04 ultrasonido(PTA7,PTA6);
Servo servomotor(PTA13);
TextLCD lcd(D7, D6, 0x4E);
max6675 sensor(D12,D13,D5);
Serial pc(USBTX,USBRX);
Thread thread;
Thread thread1;
Thread thread2;
Thread thread3;

int anodeComun[10] = {
    0b0000001, // 0
    0b1001111, // 1
    0b0010010, // 2
    0b0000110, // 3
    0b1001100, // 4
    0b0100100, // 5
    0b0100000, // 6
    0b0001111, // 7
    0b0000000, // 8
    0b0001100, // 9
};

void ultra()
{
    while(1) {
        float distancia=ultrasonido.getCm();
        printf("%2.f\n",distancia);
        Thread::wait(1000);
    }
}
void servo()
{

    servomotor.calibrate(0.001, 180);

    while(1) {
        for(int i=0; i<100; i++) {
            servomotor = i*0.01;
            printf("%d",i);
            Thread::wait(1000);
        }
        for(int i=100; i>0; i--) {
            servomotor = i*0.01;
            printf("%d",i);
            Thread::wait(1000);
        }
    }
}
void temp_hora()
{
    set_time(1256729737);
    int cf = 0;
    while (1) {
        time_t seconds = time(NULL);
        float temp = sensor.gettemp(cf);
        printf("%d", seconds);
        printf("Fecha= %s", ctime(&seconds));

        char buffer[32];
        strftime(buffer, 32, "%H:%M:%S   ", localtime(&seconds));
        printf("%s", buffer);


        if (cf) {
            printf("%4.2f%cF \n\033[2K\033[1A",temp,176);
            lcd.printf("%4.2f%cF \n\033[2K\033[1A",temp,176);
        } else {
            printf("%4.2f%cC \n",temp,176);
            lcd.printf("%4.2f%cC \n",temp,176);
        }


        Thread::wait(1000);
    }
}
void seg()
{
    float distancia=ultrasonido.getCm();
    while(1) {
        int d,u,n;
        n=int(distancia);

        d = n /10;
        u = n % 10;

        display1=1;
        display2=0;
        display7Seg=anodeComun[d];
        Thread::wait(1000);

        display1=0;
        display2=1;
        display7Seg=anodeComun[u];
        Thread::wait(1000);
    }
}
int main()
{
 
    thread.start((ultra));
    thread1.start ((servo));
    thread2.start ((temp_hora));
    thread3.start ((seg));

}
