#include "mbed.h"
#include "rtos.h"
#include "hcsr04.h"
#include "TextLCD.h"
#include "MMA8451Q.h"
#define MMA8451_I2C_ADDRESS (0x1d<<1)

BusOut Dis7seg(PTE20,PTB2,PTB0,PTE21,PTE23,PTB3,PTB1);
DigitalOut unidad(PTE2);
DigitalOut decena(PTE3);
DigitalOut centena(PTE5);
Serial pc(USBTX, USBRX); // tx, rx
HCSR04  usensor(PTD0,PTD5); // Trigger, Echo
PwmOut servo(PTA13);
DigitalOut led_1(LED1);
SPI spi(PTD2, NC, PTD1);          // puertos (MOSI, MISO, SCLK)
DigitalOut cs(PTE31);                // Chip select
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS); //(SDA,SCL,Direc)
// I2C Communication
I2C i2c_lcd(PTE0,PTE1); // SDA, SCL
// LCD instantiation
TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD16x2, TextLCD::WS0010);

unsigned int dist;
int distancias[12];
int incremento;
int Decremento;
int uni =5;
int dec =2;
int n=0;
int p=0;

Thread thread;
Thread thread1;
Thread thread2;
Thread thread3;

void numeros()
{
    switch(n) {
        case 0:
            Dis7seg=0x01;
            break;
        case 1:
            Dis7seg=0x4F;
            break;
        case 2:
            Dis7seg=0x12;
            break;
        case 3:
            Dis7seg=0x06;
            break;
        case 4:
            Dis7seg=0x4C;
            break;
        case 5:
            Dis7seg=0x24;
            break;
        case 6:
            Dis7seg=0x60;
            break;
        case 7:
            Dis7seg=0x0F;
            break;
        case 8:
            Dis7seg=0x00;
            break;
        case 9:
            Dis7seg=0x0C;
            break;
    }
}
void lidar()
{
    servo.period_ms(20);
    while(true) {
        for(int i=0; i<=12; i++) {
            incremento= i*159;
            usensor.start();
            dist=usensor.get_dist_cm();
            distancias[i]=dist;
            servo.pulsewidth_us(600+incremento);
            Thread::wait(120);
        }
        for(int i=0; i<=12; i++) {
            Decremento= i*159;
            usensor.start();
            usensor.get_dist_cm();
            distancias[i]=dist;
            servo.pulsewidth_us(2508-Decremento);
            Thread::wait(120);
        }
    }
}
void Lcd_I2C()
{

    lcd.cls();
    lcd.locate(0,0);
    lcd.setBacklight(TextLCD::LightOn);
    while(true) {
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("cm:%u hola mundo",dist);
        Thread::wait(100);
    }
}
void Seg()
{
    while (true) {
        unidad=0b1;
        decena=0b0;
        n=uni;
        numeros();
        Thread::wait(5);
        unidad=0b0;
        decena=0b1;
        n=dec;
        numeros();
        Thread::wait(5);
    }
}
int main()
{
    thread.start((numeros));
    //thread.set_priority (osPriorityNormal);
    thread1.start ((lidar));
    thread2.start ((Lcd_I2C));
    thread3.start((Seg));
    thread.join();
}
