/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */
//librerias
#include "mbed.h"
#include "Servo.h"
#include "TextLCD.h"
#include <FastPWM.h>

//pines
Servo myservo(PTE20);
PwmOut mypwm(PTA5);
Serial pc(USBTX, USBRX);
TextLCD lcd(PTB8,PTB9,PTB10,PTB11,PTE2,PTE3,TextLCD::LCD16x2);
//algunas variables
int l=0;
float range = 0.0005;
float position = 0.5;
int dato6,dato3,dato4,dato5,dato;
char dato1,dato2;
int flag=0;

void servo()
{
    switch(pc.getc()) {
         case 'l':
           // dato1=pc.getc();//datos char
    dato2=pc.getc();//datos char
    dato3=pc.getc();//datos enteros recibidos en codigo ASCII
    dato4=pc.getc();//datos enteros recibidos en codigo ASCII
    dato5=pc.getc();//datos enteros recibidos en codigo ASCII
    dato6=pc.getc();//datos enteros recibidos en codigo ASCII
    if(dato2=='A'){//numero de dos digitos
                    dato=(dato3-48)*10+dato4-48;
                }else{//numero de tres digitos(recomendacion enviar @ ).
                    dato=(dato3-48)*100+(dato4-48)*10+dato5-48;
                }
                l=dato;
            break;
        case 'c':
           // dato1=pc.getc();//datos char
    dato2=pc.getc();//datos char
    dato3=pc.getc();//datos enteros recibidos en codigo ASCII
    dato4=pc.getc();//datos enteros recibidos en codigo ASCII
    dato5=pc.getc();//datos enteros recibidos en codigo ASCII
    dato6=pc.getc();//datos enteros recibidos en codigo ASCII
    if(dato2=='A'){//numero de dos digitos
                    dato=(dato3-48)*10+dato4-48;
                }else{//numero de tres digitos(recomendacion enviar @ ).
                    dato=(dato3-48)*100+(dato4-48)*10+dato5-48;
                }
                lcd.cls();// borrar antes de mostrar el dato. 
                 lcd.locate(0,1); //(columna, fila)
                lcd.printf("slider %d ",dato);//se imprime el dato de la comunicacion serial.
              
            break;
        case 'd':
            position = 0.0;
            break;
        case 'w':
            position = 0.5;
            break;
        case 'a':
            position = 1.0;
            break;
        case 'e':
            range += 0.0001;
            break;
        case 'q':
            range -= 0.0001;
            break;
    }
    printf("position = %.1f, range = +/-%0.4f\n", position, range);
    myservo.calibrate(range, 45.0);
    myservo = position;
    lcd.locate(3,0);
    
}


void led ()
{
   
   mypwm.period_us(5000); //20khz (estandar)
  mypwm.write(l*0.01); 
 // mypwm.pulsewidth(1);
    //  mypwm.write(i); //duty cycle entre cero y uno
   // mypwm.write(100/100); //(entrada%*0.01) duty cycle is sense in percentage since 0 to 100  
}
int main()
{
    
    printf("Servo Calibration Controls:\n");
    printf("1,2,3 - Position Servo (full left, middle, full right)\n");
    printf("4,5 - Decrease or Increase range\n");
    while(1) {
           
          led();
       servo();
    }
}
