#include "mbed.h"
#include "C12832.h"
#include "ESP-call.h"
#include "communication.h"

//================================================================
Serial pc(USBTX, USBRX, 115200);

using namespace std;
char esp_data;
char esp_arr[20];
char arr_time[20] = "0:0:0";
int index = 0;
int mbedMode = 0;
int tempMode = 2;
bool trans_status = 0;
PwmOut led_r(D5);
PwmOut led_g(D9);

AnalogIn sensor(A0);
DigitalOut led(D3);

Thread thread_led;
Thread thread_lcd;
Ticker ticker;

void ledSet();

#define MAIN 0
#define COM 1
#define ALARM 2
#define ALARM_SET 29
#define PERM 3

#define ALARM_SOUND 21
#define ALARM_LED 22
#define ALARM_SOUND_LED 23
#define ALARM_ERROR 24

#define PERM_SOUND 31
#define PERM_LED 32
#define PERM_SOUND_LED 33
#define PERM_ERROR 34

int send_count = 0;

//================================ LCD ================================
C12832 lcd(D11, D13, D12, D7, D10); // lcd = (MOSI, SCK, RESET, A0, nCS)

bool alarm_stop_lcd = 0;

// LCD 초기화
void lcdInit();
// LCD의 x, y 좌표에 str을 출력
void writeLcdCLS(const char*, int, int);
// LCD의 x, y 좌표에 str을 출력 cls (x)
void writeLcd(const char*, int, int);
// LCD에 digital clock 출력
void writeTime();
// LCD에 alarm 출력
void writeAlarm();

//================================ Alarm ================================
Thread thread_Alarm;
Timer timer;
Timer trans_timer;

int a_time = 0; // alarm 시간
int a_time_temp = 0;

int a_tm = 0;
int a_hour = 0;
int a_mins = 0;
int a_sec = 0;

int start_alarm = 0;
int end_alarm = 0;


int a_temp = 0;
int a_temp_h = 0;
int a_temp_m = 0;
int a_temp_s = 0;

// Timer 동작(thread)
void timerSet();
// Timer 초기화
void timerReset();
// alarm 설정
void alarmSet();
void alarmStart();
void alarmCount();

//================================ Clock ================================
Thread thread_Clock;

int c_hour = 0;
int c_mins = 0;
int c_sec = 0;

//digital clock 초기화
void clockInit();
//현재 시각 가져옴
void getTime();
//digital clock 출력
void writeTime();

//================================ Joystick ================================
InterruptIn up(A2);
InterruptIn down(A3);
InterruptIn left(A4);
InterruptIn rite(A5);
InterruptIn center(D4);
InterruptIn sw2(SW2);
InterruptIn sw3(SW3); // permanent 중지

void ISR_center();
void ISR_up();
void ISR_down();
void ISR_left();
void ISR_rite();
void ISR_sw2();

void perm_Stop();

    //main
bool main_center = 0; 
    
    //communication
bool com_left = 0;
bool com_right = 0;
bool com_center = 0;  
    
    //alarm set (알람 설정)
bool alarm_set_up = 0;
bool alarm_set_down = 0;
bool alarm_set_left = 0;
bool alarm_set_right = 0;
bool alarm_set_center = 0; 

    //alarm(다음 선택)
bool alarm_left = 0;
bool alarm_right = 0;
bool alarm_center = 0;  
    
    //permanent
bool perm_left = 0;
bool perm_right = 0;
bool perm_center = 0;  
    
    //common (마지막 layer들 뒤로가기 기능 통일)
bool button_back = 0; //sw2 

    //permanent 송신 중단
bool perm_stop = 0;


//================================ Communication ================================


bool alarm_trans_status = 0;
int alarm_trans_mode = 0;

bool perm_trans_status = 0;
int perm_trans_mode = 0;

//=====================================
//LCD

void lcdPrint(){
    switch(mbedMode){
        case MAIN:
            writeLcd("COMMUNICATION DEVICE", 0, 6);
            writeTime();
            if(main_center){
                mbedMode = COM;
                tempMode = ALARM_SET;
                main_center = 0;
                lcd.cls();
            }
            break;
            
        case COM:
            if(alarm_stop_lcd){
                writeLcdCLS("Alarm Mode is finished...", 0, 6);
                thread_sleep_for(1500);
                alarm_stop_lcd = 0;
                lcd.cls();
            }
        
            writeLcd("COMMUNICATION DEVICE", 0, 6);
            writeLcd("Select", 0, 16);
            
            if(com_left || com_right){
                if(tempMode == ALARM_SET){
                    writeLcd("Select  Permanent          ", 0, 16);
                    tempMode = PERM;
                }else{
                    writeLcd("Select  Alarm          ", 0, 16);
                    tempMode = ALARM_SET;
                }   
                com_left = 0;
                com_right = 0;
            }else if(com_center){
                mbedMode = tempMode;
                
                if(tempMode == ALARM_SET){
                    if(perm_trans_status){
                        mbedMode = COM;
                        writeLcdCLS("Permanent mode is running...", 0, 6);
                        thread_sleep_for(500);
                        lcd.cls();
                    }else if(alarm_trans_status){
                        mbedMode = alarm_trans_mode;
                    }else{
                        tempMode = ALARM_SET;
                    }
                }else if(tempMode == PERM){
                    if(alarm_trans_status){
                        mbedMode = COM;
                        writeLcdCLS("Alarm mode is running...", 0, 6);
                        thread_sleep_for(500);
                        lcd.cls();
                    }else if(perm_trans_status){
                        mbedMode = perm_trans_mode;
                    }else{
                        tempMode = PERM_SOUND;
                    }
                }
                
                lcd.cls();
                com_center = 0;
            }else if(button_back){
                lcd.cls();
                mbedMode = MAIN;
                button_back = 0;
            }
            break;
            
        case ALARM_SET: // alarm_set_~
            writeLcd("Alarm Set Mode", 0, 6);
            alarmSet();
            a_temp_h = a_temp / 3600;
            a_temp %= 3600;
            a_temp_m = a_temp / 60;
            a_temp %= 60;
            a_temp_s = a_temp;
            lcd.locate(0, 16);
            lcd.printf("Time = %d : %d : %d     ", a_temp_h, a_temp_m, a_temp_s);
            if(alarm_set_center){
                mbedMode = ALARM;
                tempMode = ALARM_SOUND;
                alarm_set_center = 0;
                lcd.cls();   
            }else if(button_back){
                mbedMode = COM;
                tempMode = ALARM_SET;
                button_back = 0;
                lcd.cls();
            }
            
            break;
        case ALARM: // alarm_~
            writeLcd("Alarm Mode", 0, 6);
            writeLcd("Select", 0, 16);
            
            if(alarm_left){
                if(tempMode == ALARM_SOUND){
                    writeLcd("Select  Sound+Led     ", 0, 16);
                    tempMode = ALARM_SOUND_LED;   
                }else if(tempMode == ALARM_LED){
                    writeLcd("Select  Sound         ", 0, 16);
                    tempMode = ALARM_SOUND;
                }else if(tempMode == ALARM_SOUND_LED){
                    writeLcd("Select  Led           ", 0, 16);
                    tempMode = ALARM_LED;
                }
                alarm_left = 0;   
            }else if(alarm_right){
                if(tempMode == ALARM_SOUND){
                    writeLcd("Select  Led            ", 0, 16);
                    tempMode = ALARM_LED ;
                }else if(tempMode == ALARM_LED){
                    writeLcd("Select  Sound+Led      ", 0, 16);
                    tempMode = ALARM_SOUND_LED;
                }else if(tempMode == ALARM_SOUND_LED){
                    writeLcd("Select  Sound          ", 0, 16);
                    tempMode = ALARM_SOUND;
                }
                alarm_right = 0;
            }else if(alarm_center){
                alarmStart();
                mbedMode = tempMode;
                alarm_center = 0;
                lcd.cls();
            }else if(button_back){
                mbedMode = ALARM_SET;
                tempMode = ALARM_SET;
                button_back = 0;
                lcd.cls();
            }
            break;
            
        case PERM:
            writeLcd("Permanent Mode         ", 0, 6);
            writeLcd("Select", 0, 16);

            if(button_back){
                mbedMode = COM;
                tempMode = PERM;
                trans_status = 0;
                button_back = 0;
                lcd.cls();
            }else if(perm_left){
                if(tempMode == PERM_SOUND){
                    writeLcd("Select  Sound+Led     ", 0, 16);
                    tempMode = PERM_SOUND_LED;
                }else if(tempMode == PERM_LED){
                    writeLcd("Select  Sound         ", 0, 16);
                    tempMode = PERM_SOUND;
                }else if(tempMode == PERM_SOUND_LED){
                    writeLcd("Select  Led           ", 0, 16);
                    tempMode = PERM_LED;
                }
                perm_left = 0;
            }else if(perm_right){
                if(tempMode == PERM_SOUND){
                    writeLcd("Select  Led           ", 0, 16);
                    tempMode = PERM_LED;
                }else if(tempMode == PERM_LED){
                    writeLcd("Select  Sound+Led     ", 0, 16);
                    tempMode = PERM_SOUND_LED;
                }else if(tempMode == PERM_SOUND_LED){
                    writeLcd("Select  Sound         ", 0, 16);
                    tempMode = PERM_SOUND;
                }
                perm_right = 0;
            }else if(perm_center){
                mbedMode = tempMode;
                lcd.cls();
                perm_center = 0;   
            }
            break;
        
        case ALARM_SOUND:
            writeLcd("Alarm Sound Mode      ", 0, 6);
            writeAlarm();
            
            if(!alarm_trans_status){
                alarm_trans_status = 1;
                alarm_trans_mode = ALARM_SOUND;
                thread_sleep_for(1000);
                writeLcdCLS("Not Supported", 0, 6);
                alarmStart();
            }
            
            
            if(button_back){
                mbedMode = COM;
                tempMode = ALARM_SET;
                lcd.cls();
                button_back = 0;
            }
            break;
            
        case ALARM_LED:
            writeLcd("Alarm Led Mode        ", 0, 6);
            writeAlarm();
            
            if(!alarm_trans_status){  
                alarm_trans_status = 1;
                alarm_trans_mode = ALARM_LED;
                alarmStart();
                //send_count = 1;
                //if(!send_count){
                    //mutex.lock();
                    //send_count=1;
                    send(led, sensor);
                    //mutex.unlock();
                //}

            }
            
            if(button_back){
                mbedMode = COM;
                tempMode = ALARM_SET;
                lcd.cls();
                button_back = 0;   
            }
            
            break;
            
        case ALARM_SOUND_LED:
            writeLcd("Alarm Sound+Led Mode      ", 0, 6);
            writeAlarm();
        
            if(!alarm_trans_status){ 
                alarm_trans_status = 1;
                alarm_trans_mode = ALARM_SOUND_LED;
                alarmStart();
                thread_sleep_for(1000);
                writeLcdCLS("Not Supported      ", 0, 6);
            }
            
            if(button_back){
                mbedMode = COM;
                tempMode = ALARM_SET;
                lcd.cls();
                button_back = 0;
            }
            break;
            
        case ALARM_ERROR:
            writeLcd("Error                 ", 0, 6);
            writeLcd("Please Push Back Button", 0, 16);
            if(button_back){
                tempMode = ALARM_SET;
                mbedMode = COM;
                button_back = 0;
            }
            break;
            
        case PERM_SOUND:
            writeLcd("Permanent Sound Mode      ", 0, 6);
            
            if(!perm_trans_status){
                perm_trans_status = 1;
                perm_trans_mode = PERM_SOUND;
                writeLcd("Not Supported         ", 0, 16);
            }
            
            if(button_back){
                mbedMode = COM;
                tempMode = PERM;
                button_back = 0;
                lcd.cls();   
            }
            
            if(perm_stop){
                perm_Stop();
                perm_stop = 0;
            }
            
            break;
            
        case PERM_LED:
            writeLcd("Permanent Led Mode        ", 0, 6);
            
            if(!perm_trans_status){
                perm_trans_status = 1;
                perm_trans_mode = PERM_LED; 
                mutex.lock();  
                writeLcd("Receiving...          ", 0, 16);
                recv(led, sensor); 
                mutex.unlock();
            }
            
            if(button_back){
                mbedMode = COM;
                tempMode = PERM;
                button_back = 0;
                lcd.cls();   
            }
            
            if(perm_stop){
                perm_Stop(); 
                perm_stop = 0;
            }
            
            break;
            
        case PERM_SOUND_LED:
            writeLcd("Permanent Sound+Led Mode  ", 0, 6);
            
            if(!perm_trans_status){
                perm_trans_status = 1;
                perm_trans_mode = PERM_SOUND_LED; 
                writeLcd("Not Supported         ", 0, 16);
            }
            
            if(button_back){
                mbedMode = COM;
                tempMode = PERM;
                button_back = 0;
                lcd.cls();   
            }
            
            if(perm_stop){
                perm_Stop();   
                perm_stop = 0;
            }
            
            break;
            
        case PERM_ERROR:
            writeLcd("Error                 ", 0, 6);
            writeLcd("Please Push Back Button", 0, 16);
            if(button_back){
                tempMode = PERM;
                mbedMode = COM;
                button_back = 0;
            }
            break;
            
        default:
            break;   
    }        
}

void writeLcdCLS(const char* str, int x, int y){
    lcd.locate(x, y);
    lcd.cls();
    lcd.printf("%s", str);
}

void writeLcd(const char* str, int x, int y){
    lcd.locate(x, y);
    lcd.printf("%s", str);   
}


void lcdStart(){
    while(true){
        lcdPrint();
    }   
}

//=====================================
//ALARM

void alarmSet(){
    a_temp = a_time;
    if(alarm_set_up){// +1시간
        if(a_time < 82800){
            a_time += 3600;
        }else{
            a_time -= 86400;
            a_time += 3600;
        }
        alarm_set_up = 0;
    }else if(alarm_set_down){// -1시간
        if(a_time >= 3600){
            a_time -= 3600;   
        }else{
            a_time += 86400;
            a_time -= 3600;
        }
        alarm_set_down = 0;
    }else if(alarm_set_left){// +1분
        if(a_time < 86340){
            a_time += 60;
        }else{
            a_time -= 86400;
            a_time += 60;          
        }
        alarm_set_left = 0;
    }else if(alarm_set_right){// -1분
        if(a_time >= 60){
            a_time -= 60;   
        }else{
            a_time += 86400;
            a_time -= 60;
        }
        alarm_set_right = 0;
    }
}

void alarmReset(){
    a_time = 0;
    a_hour = 0;
    a_mins = 0;
    a_sec = 0;
    a_tm = 0;
    a_temp = 0;
    a_time_temp = 0;
    end_alarm = 0;
    start_alarm = 0;
    send_count = 0;
    alarm_trans_status = 0;
    alarm_trans_mode = 0;
    mbedMode = COM;
    tempMode = ALARM_SET;
    alarm_stop_lcd = 1;
    timer.stop();
    timer.reset();
}


void alarmCount(){
    while(true){
        if(alarm_trans_status){
            a_tm = timer.read();
            a_time_temp = a_time - a_tm - (end_alarm - start_alarm);
            
            
            if(a_time_temp > 0 && alarm_trans_status){
                a_hour = a_time_temp / 3600;
                a_time_temp = a_time_temp % 3600;
                a_mins = a_time_temp / 60;
                a_time_temp = a_time_temp % 60;
                a_sec = a_time_temp;
                thread_sleep_for(1000);           
            }else if(a_time_temp == 0 && alarm_trans_status){
                alarmReset();
            }
            
        }
    }
}

void alarmStart(){
    timer.reset();
    timer.start();
    thread_sleep_for(100);
    thread_Alarm.start(alarmCount);
}

void writeAlarm(){
    lcd.locate(0, 16);
    lcd.printf("Time Left: %d:%d:%d             ", a_hour, a_mins, a_sec);
}

//=====================================
//CLOCK

void clockInit(){
    //thread_Clock.start(getTime);
}

int i;
int j;

void getTime(){

        PC.printf("%s\r\n", esp_arr);
    
        for(i = 0; i < 10; i++){
            if(esp_arr[i] == 't' && esp_arr[i+1] == 'i' && esp_arr[i+2] == 'm' && esp_arr[i+3] == 'e'){
                j = 0;
                while(esp_arr[i] != 'H' && esp_arr[i] !='\0' && i != 20){
                    arr_time[j++] = esp_arr[i++];
                }
                arr_time[j] = '\0';
                break;
            }
        }
        
        PC.printf("%s\r\n", arr_time);
    
}

void writeTime(){
    getTime();
    lcd.locate(0, 16);
    lcd.printf("%s", arr_time);
    thread_sleep_for(500);
}


//=====================================
//JOYSTICK

void ISR_center(){
    switch(mbedMode){
        case MAIN:
            main_center = 1;
            break;
        case COM:
            com_center = 1;
            break;
        case ALARM:
            alarm_center = 1;
            break;
        case ALARM_SET:
            alarm_set_center = 1;
            break;
        case PERM:
            perm_center = 1;
            break;
        default:
            break;
    }
}

void ISR_up(){
    switch(mbedMode){
        case ALARM_SET:
            alarm_set_up = 1;
            break;
        default:
            break;
    }
}

void ISR_down(){
    switch(mbedMode){
        case ALARM_SET:
            alarm_set_down = 1;
            break;
        default:
            break;   
    }
}

void ISR_left(){
    switch(mbedMode){
        case COM:
            com_left = 1;
            break;
        case ALARM:
            alarm_left = 1;
            break;
        case ALARM_SET:
            alarm_set_left = 1;
            break;
        case PERM:
            perm_left = 1;
            break;
        default:
            break;   
    }
}

void ISR_rite(){
    switch(mbedMode){
        case COM:
            com_right = 1;
            break;
        case ALARM_SET:
            alarm_set_right = 1;
            break;
        case ALARM:
            alarm_right = 1;
            break;
        case PERM:
            perm_right = 1;
            break;
        default:
            break;
    }
}

void ISR_sw2(){
    switch(mbedMode){
        case COM:
        case ALARM:
        case ALARM_SET:
        case ALARM_SOUND:
        case ALARM_LED:
        case ALARM_SOUND_LED:
        case PERM:
        case PERM_SOUND:
        case PERM_LED:
        case PERM_SOUND_LED:
            button_back = 1;
            break;
        default:
            break;
    }
}

void ISR_sw3(){
    switch(mbedMode){
        case PERM_SOUND:
        case PERM_LED:
        case PERM_SOUND_LED:
            perm_stop = 1;
            break;
        default:
            break;
    }
}

void joyInit(){
     up.rise(&ISR_up);
     down.rise(&ISR_down);
     left.rise(&ISR_left);
     rite.rise(&ISR_rite);
     center.rise(&ISR_center);
     
     sw2.fall(&ISR_sw2);  
     sw3.fall(&ISR_sw3);
}

void perm_Stop(){
    mbedMode = COM;
    tempMode = PERM;
    perm_stop = 1;
    writeLcdCLS("Permanent Stop...", 0, 16);
    perm_trans_status = 0;
    perm_trans_mode = 0;
    thread_sleep_for(1500);
    lcd.cls();   
}

//================================ NodeMCU program ================================
NodeMCU_PGM http_server[] = { 
    "", 1,
    "wifi.setmode(wifi.STATION)", 1,
    "", 1,
    "station_cfg={}", 1,
    "station_cfg.ssid=\"IP_S\"", 1,
    "station_cfg.pwd=\"1kokrjg3un7i4\"", 1,
    "station_cfg.save=false", 1,
    "wifi.sta.config(station_cfg)", 1,
    "", 1,
    "wifi.sta.connect()", 80,
    "", 1,
    "print(wifi.sta.status())", 1,
    "print(wifi.sta.getip())", 1,
    "", 1,
    "", 1,
    "http_resp = \"HTTP/1.0 200 OK\\r\\nContent-Type: text/html\\r\\n\\r\\n\"", 1,    
    "html_1 = \"<!DOCTYPE html>\"", 1,
    "html_2 = \"<html lang=\\\"ko\\\">\"", 1,
    "html_3 = \"<head>\"", 1,
    "html_4 = \"    <meta charset=\\\"UTF-8\\\">\"", 1,
    "html_5 = \"    <title>clock1</title>\"", 1,
    "html_6 = \"</head>\"", 1,
    "html_7 = \"<body>\"", 1,
    "html_8 = \"    <h1 id=\\\"clock\\\" style=\\\"color:black;\\\">clock</h1>\"", 1,
    "", 1,
    "html_9 = \"    <script>\"", 1,
    "html_10 = \"       function clock() {\"", 1,
    "html_11 = \"           var time = new Date();\"", 1,
    "", 1,
    "html_12 = \"           var hours = time.getHours();\"", 1,
    "html_13 = \"           var minutes = time.getMinutes();\"", 1,
    "html_14 = \"           var seconds = time.getSeconds();\"", 1,
    "", 1,
    "html_text = \"         Target.innerText = `${hours < 10 ? `0${hours}` : hours}:${minutes < 10 ? `0${minutes}` : minutes}:${seconds < 10 ? `0${seconds}` : seconds}`;\"", 1,
    "html_15 = \"           location.replace(\\\"http://172.20.10.6\\\"+\\\"/?time=\\\"+hours.toString()+\\\":\\\"+minutes.toString()+\\\":\\\"+seconds.toString());\"", 1,
    "", 1,         
    "html_16 = \"        }\"", 1,
    "html_17 = \"        setInterval(clock, 1000);\"", 1,
    "html_18 = \"    </script>\"", 1,
    "html_19 = \"</body>\"", 1,
    "html_20 = \"</html>\"", 1,
    "", 1,
    "", 1,
    "srv = net.createServer(net.TCP)", 1,
    "srv:listen(80, function(conn)", 1,
    "   conn:on(\"receive\", function(sck, payload)", 1,
    "       print(payload)", 1,
    "       sck:send(http_resp)", 1,
    "       sck:send(html_1)", 1,
    "       sck:send(html_2)", 1,
    "       sck:send(html_3)", 1,
    "       sck:send(html_4)", 1,
    "       sck:send(html_5)", 1,
    "       sck:send(html_6)", 1,
    "       sck:send(html_7)", 1,
    "       sck:send(html_8)", 1,
    "       sck:send(html_9)", 1,
    "       sck:send(html_10)", 1,
    "       sck:send(html_11)", 1,
    "       sck:send(html_12)", 1,
    "       sck:send(html_13)", 1,
    "       sck:send(html_14)", 1,
    //"       sck:send(html_text)", 1,
    "       sck:send(html_15)", 1,
    "       sck:send(html_16)", 1,
    "       sck:send(html_17)", 1,
    "       sck:send(html_18)", 1,
    "       sck:send(html_19)", 1,
    "       sck:send(html_20)", 1,
    "       end)", 1,
    "   conn:on(\"sent\", function(sck) sck:close() end)", 1,
    "end)", 1,
    NULL, 0,
};

void receive_Data(){
    
    esp_data = ESP.getc();
    
    if(index < 20){
        esp_arr[index++] = esp_data;    
    }else if(index == 20){
        esp_arr[index] = '\0';
    }

}

void time_get(){
    
    index = 0;
}

void ledSet(){
    while(true){
        while(perm_trans_status || alarm_trans_status){
            led_r = 1;
            led_g = 0;
            thread_sleep_for(100);
            led_g = 1;
            thread_sleep_for(100);
        }
        led_r = 0;
        led_g = 1; 
    }   
}

//==========================================================================
//main
int main(){
    
    writeLcdCLS("Starting...           ", 24, 6);
    
    ESP.baud(115200);
    PC.baud(115200);
    
    pc.printf("\r\nReset ESP...\r\n"); 
    ESP_reset();

    PC.printf("Setup ESP noecho...\r\n"); 
    ESP_noecho();
    
    PC.printf("Execute a NodeMCU program...\r\n"); 
    ESP_call_multi(http_server);
    
    PC.printf("\r\nESP receive mode...\r\n");
    ESP.attach(receive_Data, Serial::RxIrq);
    
    ticker.attach(&time_get, 1.0);
    
    clockInit();
    thread_led.start(ledSet);
    thread_lcd.start(lcdStart);
    joyInit();
 
    thread_sleep_for(500);

    while(true){  
        
    }
}