#ifndef JOYSTICK_H
#define JOYSTICK_H

#define DIRECTION_TOLERANCE 0.25

AnalogIn VRy(dp10);

AnalogIn VRx(dp11);

DigitalIn SW(dp9); 

enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT
};
typedef struct JoyStick Joystick;
struct JoyStick {
    DirectionName direction;  // current direction
};
Joystick joystick;

void updateJoystick();


void updateJoystick()
{
        if (VRx<0.3) {
            joystick.direction = RIGHT;
        }
        else if (VRx>0.7) {
            joystick.direction = LEFT;
        }
        else if (VRy>0.3) {
            joystick.direction = UP;
        }
        else if (VRy>0.7) {
            joystick.direction = DOWN;
        }
}
#endif