#include "mbed.h"
#define dp23 P0_0


#include "stdio.h"
#include "SPI_TFT_ILI9341.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"


SPI_TFT_ILI9341 TFT(dp2,dp1,dp6,dp24,dp23,dp25,"TFT"); // mosi, miso, sclk, cs, reset, dc
AnalogIn napon(dp9);

int main() {
    
    float ocitavanje;
    float temperatura;
    int hor = 20;
    int ver = 170 - 1833*( napon-0.06);
    int vrijeme = 0;
    
    TFT.claim(stdout);
    TFT.set_orientation(1);
    TFT.background(White);     
    TFT.foreground(Black);    
    TFT.cls();                
    
    TFT.line(20, 170, 230, 170, Black); //x-osa
    TFT.line (25, 175, 25, 50, Black); //y-osa
    
    while(1) {

        ocitavanje = napon;
        if (ocitavanje*330<temperatura)
        koeficijent = 1;
        else 
        koeficijent = -1;
        
        temperatura = ocitavanje * 330;
        
        //240x320
        
        
        TFT.set_font((unsigned char*) Arial12x12);
        
        TFT.locate(160,10);
        printf("Napon: %f mV",ocitavanje*3300);
        
        TFT.locate(160,38);
        printf("Temp: %f C",ocitavanje*330);
        
        TFT.locate(160,66);
        printf("Vrijeme %d:",vrijeme);
        
        if (hor==170) break;
         
         
        TFT.line(hor, ver, hor + 10, (170 - 1833*( ocitavanje-0.06)), Red); 
        
        TFT.fillcircle(hor+10,170 - 1833*( ocitavanje-0.06),4,Black);
        
        hor = hor + 10;
        
        ver = 170 - 1833*( ocitavanje-0.06);
        
        wait_ms(950);
        
        vrijeme++;
        
      
    }
}









