#include "mbed.h"
#include "N5110.h"
#include "ds1307.h"//iskreno se nadam da je ovaj
#include <stdio.h>
#define dp23 P0_0
#define PI 3.14
//N5110 lcd(VCC,SCE,RST,DC,MOSI,SCLK,LED));
N5110 lcd(dp4,dp24,dp23,dp28,dp2,dp6,dp18);
DS1307 sat(dp5,dp27);
BusIn ulazi(dp9,dp10,dp11,dp13);
BusOut izlazi(dp25,dp26,dp17,dp15);

DigitalOut enable(dp14);

int h(0),m(0),s(0);
int dan, mjesec, godina,usedmici;
char buffer[4];
char taster;
Ticker tastatura;

//broj dana u mjesecu
int brojdana[12]= {31,29,31,30,31,30,31,31,30,31,30,31};
//provjerava prijestupne
bool DaLiJePrijestupna(int god)
{
    if (god%4==0) {
        if(god%100) {
            if(god%400) return true;
            return false;
        }
        return true;
    }
    return false;
}
//-----------------------------------------------
//varijable za alarm
int alarmH(0),alarmM(0);
bool alarmUkljucen(false);
Timer t;
//------------------------------------------------

int duzinaK1(5),duzinaK2(12),duzinaK3(15);//duzina kazaljki

//--------------------------------------------------------------------
//TACKE NA SATU (1-12) (pokusavam izbjeci staljno racunanje ovih
//varijabli, pa cu ih jednostavno ostaviti ovdje kao globalne)
float x[12]= {(42+18*cos(PI/2)),(42+18*cos(PI/3)),(42+18*cos(PI/6)),(42+18),(42+18*cos(11*PI/6)),
              (42+18*cos(5*PI/3)),(42+18*cos(3*PI/2)),(42+18*cos(4*PI/3)),(42+18*cos(7*PI/6)),(42+18*cos(PI)),(42+18*cos(5*PI/6)),(42+18*cos(2*PI/3))
             };
float y[12]= {(24+18*sin(PI/2)),(24+18*sin(PI/3)),(24+18*sin(PI/6)),(24),(24+18*sin(11*PI/6)),
              (24+18*sin(5*PI/3)),(24+18*sin(3*PI/2)),(24+18*sin(4*PI/3)),(24+18*sin(7*PI/6)),(24+18*sin(PI)),(24+18*sin(5*PI/6)),(24+18*sin(2*PI/3))
             };

//--------------------------------------------------------------------
//FUNKCIJA ZA KAZALJKE
void Crtajkazaljke ()
{
    //Kazaljka za sate
    float ugao1= (h%12 * 360/12 + m*30/60-90)*PI/180;
    float xK1=42+duzinaK1*cos(ugao1);
    float yK1=24+duzinaK1*sin(ugao1);
    //Kazaljka za minute
    float ugao2= (m%60*360/60-90)*PI/180;
    float xK2=42+duzinaK2*cos(ugao2);
    float yK2=24+duzinaK2*sin(ugao2);
    //Kazaljka za sekunde
    float ugao3= (s%60*360/60-90)*PI/180;
    float xK3=42+duzinaK3*cos(ugao3);
    float yK3=24+duzinaK3*sin(ugao3);

    //iscrtavanje kazaljki
    lcd.drawLine(42,24,xK1,yK1,1);
    lcd.drawLine(42,24,xK2,yK2,1);
    lcd.drawLine(42,24,xK3,yK3,1);

}
//-----------------------------------------------------------------------
//FUNKCIJA ZA CRTANJE SATA
void NacrtajSat()
{
    //krug
    lcd.clear();
    lcd.drawCircle(42,24,20,0);
    //tacke koje oznacavaju sate, izbjegavam for petlju zbog efikasnosti
    lcd.setPixel(x[0],y[0]);
    lcd.setPixel(x[1],y[1]);
    lcd.setPixel(x[2],y[2]);
    lcd.setPixel(x[3],y[3]);
    lcd.setPixel(x[4],y[4]);
    lcd.setPixel(x[5],y[5]);
    lcd.setPixel(x[6],y[6]);
    lcd.setPixel(x[7],y[7]);
    lcd.setPixel(x[8],y[8]);
    lcd.setPixel(x[9],y[9]);
    lcd.setPixel(x[10],y[10]);
    lcd.setPixel(x[11],y[11]);
    sprintf(buffer,"%d",dan);//treba namjestiti da se u ugao upise datum i alarm isto
    lcd.printString(buffer,71,3);
    sprintf(buffer,"%d",mjesec);
    lcd.printString(buffer,71,4);
    sprintf(buffer,"%d",godina);
    lcd.printString(buffer,71,5);
   
    if(alarmUkljucen)
    { 
    sprintf(buffer,"%d  ",alarmH);
    lcd.printString(buffer,0,0);
    sprintf(buffer,"%d  ",alarmM);
    lcd.printString(buffer,0,1);
    }
    Crtajkazaljke();
    lcd.refresh();

}
//------------------------------------------------------------------------
void Tastatura()
{
    izlazi[0] = 0;
    izlazi[1]= 0;
    izlazi[2]= 0;
    izlazi[3]= 0;

    izlazi[0] = 1;
    if(ulazi[0] == 1) {
        taster= '1';
        return;
    } else if(ulazi[1] == 1) {
        taster= '2';
        return;
    } else if(ulazi[2] == 1) {
        taster= '3';
        return;
    } else if(ulazi[3] == 1) {
        taster= 'A';
        return;
    }
    izlazi[0] = 0;

    izlazi[1] = 1;
    if(ulazi[0] == 1) {
        taster= '4';
        return;
    } else if(ulazi[1] == 1) {
        taster= '5';
        return;
    } else if(ulazi[2] == 1) {
        taster= '6';
        return;
    } else if(ulazi[3] == 1) {
        taster= 'B';
        return;
    }
    izlazi[1] = 0;

    izlazi[2] = 1;
    if(ulazi[0] == 1) {
        taster= '7';
        return;
    } else if(ulazi[1] == 1) {
        taster= '8';
        return;
    } else if(ulazi[2] == 1) {
        taster= '9';
        return;
    } else if(ulazi[3] == 1) {
        taster= 'C';
        return;
    }
    izlazi[2] = 1;

    izlazi[3] = 1;
    if(ulazi[0] == 1) {
        taster='*';
        return;
    } else if(ulazi[1] == 1) {
        taster= '0';
        return;
    } else if(ulazi[2] == 1) {
        taster= '#';
        return;
    } else if(ulazi[3] == 1) {
        taster='D';
        return;
    }
    izlazi[3] = 1;

    taster= ' ';
    return;
}
//---------------------------------------------------------------------------
void AlarmPodesavanje()
{
    int alarmUnosBrojac(0),alarmH1(0),alarmH2(0),alarmM1(0),alarmM2(0);
    char alarmstring [10];
    alarmH1=alarmH/10;
    alarmH%=10;
    alarmH2=alarmH;
    alarmM1=alarmM/10;
    alarmM%=10;
    alarmM2=alarmM;
    while (1) {
        lcd.clear();
        lcd.printString("Set alarm:",0,0);
        sprintf(alarmstring,"%d%d:%d%d",alarmH1,alarmH2,alarmM1,alarmM2);
        lcd.printString(alarmstring,0,1);
        lcd.refresh();
        if(taster=='C') {
            lcd.printString("Alarm is off",0,2);
            wait(0.3);
            alarmH1=0;
            alarmH2=0;
            alarmM1=0;
            alarmM2=0;
            alarmUnosBrojac=0;
            alarmUkljucen=false;
        } else if(taster=='D') {
            alarmH=10*alarmH1+alarmH2;
            alarmM=10*alarmM1+alarmM2;
            alarmUkljucen=true;
            return;
        } else if(taster>=0+'0' && taster<=9+'0') {
            switch (alarmUnosBrojac) {
                case 0:
                    if(taster<=2+'0') {
                        alarmH1=taster-'0';
                        alarmUnosBrojac++;
                    }
                    wait(0.2);
                    break;
                case 1:
                    if((alarmH1==2 && taster<=3+'0' )|| (alarmH1<2)) {
                        alarmH2=taster-'0';
                        alarmUnosBrojac++;
                    }
                    wait(0.2);
                    break;
                case 2:
                    if(taster<=5+'0') {
                        alarmM1=taster-'0';
                        alarmUnosBrojac++;
                    }
                    wait(0.2);
                    break;
                case 3:
                    alarmM2=taster-'0';
                    alarmUnosBrojac++;
                    wait(0.2);
                    break;
            }

        }


    }


}
//-----------------------------------------------------------------------------------------------------------------------------------
void PostavljanjeVremenaIDatuma()
{
    int UnosBrojac(0),H1(0),H2(0),M1(0),M2(0),D1(0),D2(0),MO1(0),MO2(0),Y1(0),Y2(0);
    char buffstring [22];
    H1=h/10;
    H2=h%10;
    M1=m/10;
    M2=m%10;
    D1=dan/10;
    D2=dan%10;
    MO1=mjesec/10;
    MO2=mjesec%10;
    Y1=godina/10;
    Y2=godina%10;
    usedmici=1;
    while (1) {
        lcd.printString("Set date and time:",0,0);
        sprintf(buffstring,"%d%d:%d%d",H1,H2,M1,M2);
        lcd.printString(buffstring,0,1);
                sprintf(buffstring,"%d%d/%d%d/%d%d",D1,D2,MO1,MO2,Y1,Y2);
        lcd.printString(buffstring,0,2);
        lcd.refresh();
        if(taster=='C') {
                H1=h/10;
    H2=h%10;
    M1=m/10;
    M2=m%10;
    D1=dan/10;
    D2=dan%10;
    MO1=mjesec/10;
    MO2=mjesec%10;
    Y1=godina/10;
    Y2=godina%10;
            UnosBrojac=0;
        } else if(taster=='D') {
            
            sat.settime(s, M1*10+M2, H1*10+H2, usedmici, D1*10+D2,M1*10+M2,Y1*10+Y2);
            return;
        } else if(taster-'0'>=0 && taster-'0'<=9) {
            switch (UnosBrojac) {
                case 0:
                    if(taster<=2+'0') {
                        H1=taster-'0';
                        UnosBrojac++;
                    }
                    wait(0.2);
                    break;
                case 1:
                    if((H1==2 && taster<=3+'0' )|| (H1<2)) {
                        H2=taster-'0';
                        UnosBrojac++;
                    }
                    wait(0.2);
                    break;
                case 2:
                    if(taster<=5+'0') {
                        M1=taster-'0';
                        UnosBrojac++;
                    }
                    wait(0.2);
                    break;
                case 3:
                    M2=taster-'0';
                    UnosBrojac++;
                    wait(0.2);
                    break;
                case 4:
                    if(taster<=3+'0') {
                        D1=taster-'0';
                        UnosBrojac++;
                    }
                    wait(0.2);
                    break;
                case 5:
                    if((D1==3 && taster<=1+'0' )|| (D1<3)) {
                        D2=taster-'0';
                        UnosBrojac++;
                    }
                    wait(0.2);
                    break;
                case 6:
                    if(taster<=1+'0') {
                        MO1=taster-'0';
                        UnosBrojac++;
                    }
                    wait(0.2);
                    break;
                case 7:
                    if((MO1==1 && taster<=2+'0' )|| (MO1<1)) {
                        if(10*D1+D2<=brojdana[10*MO1+taster-'0']) {
                            MO2=taster-'0';
                            UnosBrojac++;
                        } else {
                            lcd.printString("Bad date",0,3);
                            wait(0.3);
                            D1=dan/10;
                            D2=dan%10;
                            MO1=mjesec/10;
                            UnosBrojac=4;
                        }
                    }
                    wait (0.2);
                    break;
                case 8:
                    Y1=taster-'0';
                    UnosBrojac++;
                    wait(0.2);
                    break;
                case 9:
                    Y2=taster-'0';
                    UnosBrojac++;
                    wait(0.2);
                    break;
               

            }

        }


    }

}
//----------------------------------------------------------------------------------------
void Alarm()
{
    lcd.printString("TANK TIME",0,0);
    lcd.refresh();
    t.start();
    while (1) {
        if (t.read()==120 || taster =='D') {
            alarmUkljucen=false;
            lcd.clear();
            return;
        }
    }
    }
//--------------------------------------------------------------------------------------
    int main() {
        //deaktivacija led dioda
        enable=1;
        sat.start_clock();

        //inicijalizacija displeja
        lcd.init();
        tastatura.attach(&Tastatura,0.2);
                    

        while(1) {
            sat.gettime(&s,&m,&h, &usedmici, &dan, &mjesec, &godina);
            NacrtajSat();
            if (taster=='*') {
                lcd.clear();
                AlarmPodesavanje();
            }
            if (taster=='#') {
                lcd.clear();
                PostavljanjeVremenaIDatuma();
            }
                        if (h==alarmH && m==alarmM && alarmUkljucen) {
                lcd.clear();
                Alarm();
            }

            wait(0.2);
            lcd.clear();
        }
    }