#include "mbed.h"
#include "N5110.h"
#include "string.h"
#define dp23 P0_0

#define STRUJA 0.00033  // 3.3V/10kOhm = 0.33 mA
#define NAPAJANJE 3.3   // Vcc = 3.3V

//N5110 lcd(VCC,SCE,RST,DC,MOSI,SCLK,LED));
N5110 lcd(dp4,dp24,dp23,dp25,dp2,dp6,dp18);

DigitalOut enable(dp14);
AnalogIn napon(dp9);
DigitalIn taster(dp1);

char rezultat[5], buffer[5], strBuffer[14];

void ispisiNapon() {
    lcd.clear();
    
    float tmp2 = napon*NAPAJANJE;
    sprintf(strBuffer, "U = %2.2fV", tmp2);
    lcd.printString(strBuffer, 0, 0);
  
}

void ispisiOtpor() {
    lcd.clear();
    
    float tmp = (napon/STRUJA)*NAPAJANJE;
    sprintf(strBuffer, "R = %2.2fO", tmp);
    lcd.printString(strBuffer, 0, 0);
}


int counter = 0;

void klik() { 
    if(counter%2 == 1) {
        ispisiNapon();
        wait(0.4);
    }
    else {
        ispisiOtpor();
        wait(0.4);
    }   
}

int main() {
    enable = 1;
    lcd.init();    

    while(1) {
        if(taster == 1) counter++;
        klik();
        wait(0.2);
    }
}
