#include "mbed.h"
#include "N5110.h"
#define dp23 P0_0

DigitalOut enable(dp14);

//N5110 lcd(VCC,SCE,RST,D/C,MOSI,SCLK,LED)
N5110 lcd(dp4, dp24, dp23, dp25, dp2, dp6, dp18);

//Analogni ulazi sa dzojstika
AnalogIn    VRx(dp11);
AnalogIn    VRy(dp10);

Timer debounce;

//Taster sa dzojstika
InterruptIn   SW(dp9);

char mode = '0';
//0-prije pokretanja, 1-pocetni ekran, 2-meni, 3-player vs computer, 4-player vs player, 5-result
struct Pozicija {
    int x;
    int y;
    bool upisano;
    bool imaX;
    bool imaO;
};


bool pozvano=false;
int brRundi=0;
bool naReduCPU=false;
bool naReduX = true;
bool pobijedioX = false;
bool pobijedioO = false;

Pozicija pozicija[3][3];
Pozicija trenutnaPozicija;


int brPobjedaX = 0, brPobjedaO = 0;
int popunjenaPoljaCPU=0;
bool prviPotez=true;
int trenPoljeX=0,trenPoljeY=0;

void postavkaPolja()
{
    //koordinate pocetka kvadratica
//prvi red


    pozicija[0][0].x=0;
    pozicija[0][0].y=0;
    pozicija[0][1].x=0;
    pozicija[0][1].y=16;
    pozicija[0][2].x=0;
    pozicija[0][2].y=32;
    pozicija[0][0].upisano = false;
    pozicija[0][1].upisano = false;
    pozicija[0][2].upisano = false;

    pozicija[0][0].imaX = false;
    pozicija[0][1].imaX = false;
    pozicija[0][2].imaX = false;
    pozicija[0][0].imaO = false;
    pozicija[0][1].imaO = false;
    pozicija[0][2].imaO = false;


//drugi red
    pozicija[1][0].x=16;
    pozicija[1][0].y=0;
    pozicija[1][1].x=16;
    pozicija[1][1].y=16;
    pozicija[1][2].x=16;
    pozicija[1][2].y=32;
    pozicija[1][0].upisano = false;
    pozicija[1][1].upisano = false;
    pozicija[1][2].upisano = false;

    pozicija[1][0].imaX = false;
    pozicija[1][1].imaX = false;
    pozicija[1][2].imaX = false;
    pozicija[1][0].imaO = false;
    pozicija[1][1].imaO = false;
    pozicija[1][2].imaO = false;

//treci red
    pozicija[2][0].x=32;
    pozicija[2][0].y=0;
    pozicija[2][1].x=32;
    pozicija[2][1].y=16;
    pozicija[2][2].x=32;
    pozicija[2][2].y=32;
    pozicija[2][0].upisano = false;
    pozicija[2][1].upisano = false;
    pozicija[2][2].upisano = false;

    pozicija[2][0].imaX = false;
    pozicija[2][1].imaX = false;
    pozicija[2][2].imaX = false;
    pozicija[2][0].imaO = false;
    pozicija[2][1].imaO = false;
    pozicija[2][2].imaO = false;

    trenutnaPozicija = pozicija[0][0];
    popunjenaPoljaCPU=0;
}

//funkcija za izbor nacina igre PvP, PvC
void izborNacinaIgre()
{
    lcd.clear();
    mode = '2';
    lcd.printString("(Up) P vs C", 0, 2);
    lcd.printString("(Down) P vs P", 0, 4);


}
//funkcija za crtanje x
void nacrtajX(int x, int y)
{
    
    lcd.setPixel(x+3, y+3);
    lcd.setPixel(x+12, y+3);
    lcd.setPixel(x+4, y+4);
    lcd.setPixel(x+11, y+4);
    lcd.setPixel(x+5, y+5);
    lcd.setPixel(x+10, y+5);
    lcd.setPixel(x+6, y+6);
    lcd.setPixel(x+9, y+6);
    lcd.setPixel(x+7, y+7);
    lcd.setPixel(x+8, y+7);
    lcd.setPixel(x+7, y+8);
    lcd.setPixel(x+8, y+8);
    lcd.setPixel(x+6, y+9);
    lcd.setPixel(x+9, y+9);
    lcd.setPixel(x+5, y+10);
    lcd.setPixel(x+10, y+10);
    lcd.setPixel(x+4, y+11);
    lcd.setPixel(x+11, y+11);
    lcd.setPixel(x+3, y+12);
    lcd.setPixel(x+12, y+12);
    
    
    

}

//funkcija za crtanje o
void nacrtajO(int x, int y)
{
    lcd.setPixel(x+3, y+6);
    lcd.setPixel(x+3, y+7);
    lcd.setPixel(x+3, y+8);
    lcd.setPixel(x+3, y+9);
    
    lcd.setPixel(x+4, y+5);
    lcd.setPixel(x+4, y+10);
    
    lcd.setPixel(x+5, y+4);
    lcd.setPixel(x+5, y+11);
    
    lcd.setPixel(x+6, y+3);
    lcd.setPixel(x+6, y+12);
    lcd.setPixel(x+7, y+3);
    lcd.setPixel(x+7, y+12);
    lcd.setPixel(x+8, y+3);
    lcd.setPixel(x+8, y+12);
    lcd.setPixel(x+9, y+3);
    lcd.setPixel(x+9, y+12);
    
    lcd.setPixel(x+10, y+4);
    lcd.setPixel(x+10, y+11);
    
    lcd.setPixel(x+11, y+5);
    lcd.setPixel(x+11, y+10);
    
    lcd.setPixel(x+12, y+6);
    lcd.setPixel(x+12, y+7);
    lcd.setPixel(x+12, y+8);
    lcd.setPixel(x+12, y+9);
    
    
    
}
//funkcija za crtanje pozicije joystick-a za vrijeme igre
void nacrtajKursor(int x, int y)
{
    for (int i = x+1; i < x + 15; i++) {
        for(int j = y+1; j < y +15; j++) {
            if(((i == x+2|| i == x+13 ) && j!=y+1 && j!= y+14 ) || ((j== y+2 ||j == y + 13) && i!=x+1 && i!= x+14)) lcd.setPixel(i, j);
        }
    }
}

void izbrisiKursor(int x, int y)
{
    for (int i = x+1; i < x + 15; i++) {
        for(int j = y+1; j < y +15; j++) {
            if(((i == x+2|| i == x+13 ) && j!=y+1 && j!= y+14 ) || ((j== y+2 ||j == y + 13) && i!=x+1 && i!= x+14)) lcd.clearPixel(i, j);
        }
    }
}

void iscrtajGrid()
{
    //redovi
    for (int i = 0; i < 47; i++) lcd.setPixel(i, 0);
    for (int i = 0; i < 47; i++) lcd.setPixel(i, 15);
    for (int i = 0; i < 47; i++) lcd.setPixel(i, 31);
    for (int i = 0; i < 47; i++) lcd.setPixel(i, 47);

    //kolone
    for (int i = 0; i < 47; i++) lcd.setPixel(0, i);
    for (int i = 0; i < 47; i++) lcd.setPixel(15, i);
    for (int i = 0; i < 47; i++) lcd.setPixel(31, i);
    for (int i = 0; i < 47; i++) lcd.setPixel(47, i);

    //updateovanje displeja zbog promjena u pikselima
    lcd.refresh();
}

//funkcija za ciscenje mreze nakon odigrane igre
void ocistiGrid()
{
    for (int i = 0; i < 47; i++) {
        for (int j = 0; j < 47; j++) lcd.clearPixel(i,j);
    }

}
//funkcija za ispisivanje trenutnog rezultata i icrtavanje polja za novu rundu
void iscrtajPoljeNoveRunde ()
{
    if ((mode == '3' || mode == '4') && (brPobjedaO + brPobjedaX != 3)) {
        ocistiGrid();
        iscrtajGrid();
        postavkaPolja();
        trenPoljeX = 0;
        trenPoljeY = 0;
        if(brRundi%2 == 0) {
            naReduCPU=true;
            naReduX=false;
        }
        else {naReduCPU=false;
            naReduX=true;}
        prviPotez=true;
        brRundi++;
        nacrtajKursor(trenutnaPozicija.x, trenutnaPozicija.y);
        if(brPobjedaX==1 && brPobjedaO==0)
            lcd.printString("1 : 0", 50, 4);
        else if(brPobjedaX==2 && brPobjedaO==0)
            lcd.printString("2 : 0", 50, 4);
        else if(brPobjedaX==3 && brPobjedaO==0)
            lcd.printString("3 : 0", 50, 4);
        else if(brPobjedaX==0 && brPobjedaO==3)
            lcd.printString("0 : 3", 50, 4);
        else if(brPobjedaX==0 && brPobjedaO==2)
            lcd.printString("0 : 2", 50, 4);
        else if(brPobjedaX==1 && brPobjedaO==1)
            lcd.printString("1 : 1", 50, 4);
        else if(brPobjedaX==0 && brPobjedaO==1)
            lcd.printString("0 : 1", 50, 4);
        else if(brPobjedaX==2 && brPobjedaO==1)
            lcd.printString("2 : 1", 50, 4);
        else if(brPobjedaX==1 && brPobjedaO==2)
            lcd.printString("1 : 2", 50, 4);

    }
    lcd.refresh();

    popunjenaPoljaCPU = 0;
    pobijedioX = false;
    pobijedioO = false;
}

void gore()
{
    izbrisiKursor(trenutnaPozicija.x, trenutnaPozicija.y);
    if(trenPoljeY == 1 || trenPoljeY == 2) {
        trenPoljeY--;
        trenutnaPozicija = pozicija[trenPoljeX][trenPoljeY];
    } else if (trenPoljeY == 0) {
        trenutnaPozicija = pozicija[trenPoljeX][2];
        trenPoljeY = 2;
    }
    nacrtajKursor(trenutnaPozicija.x, trenutnaPozicija.y);
}
void dole()
{
    izbrisiKursor(trenutnaPozicija.x, trenutnaPozicija.y);
    if(trenPoljeY == 0 || trenPoljeY ==1 ) {
        trenPoljeY++;
        trenutnaPozicija = pozicija[trenPoljeX][trenPoljeY];
    }

    else if (trenPoljeY == 2 ) {
        trenPoljeY = 0;
        trenutnaPozicija = pozicija[trenPoljeX][trenPoljeY];
    }
    nacrtajKursor(trenutnaPozicija.x, trenutnaPozicija.y);
}
void lijevo()
{
    izbrisiKursor(trenutnaPozicija.x, trenutnaPozicija.y);
    if(trenPoljeX == 2 || trenPoljeX == 1) {
        trenPoljeX--;
        trenutnaPozicija = pozicija[trenPoljeX][trenPoljeY];

    } else if (trenPoljeX == 0) {
        trenutnaPozicija = pozicija[2][trenPoljeY];
        trenPoljeX=2;
    }
    nacrtajKursor(trenutnaPozicija.x, trenutnaPozicija.y);
}
void desno()
{
    izbrisiKursor(trenutnaPozicija.x, trenutnaPozicija.y);
    if(trenPoljeX == 0 || trenPoljeX == 1) {
        trenPoljeX++;
        trenutnaPozicija = pozicija[trenPoljeX][trenPoljeY];

    } else if (trenPoljeX == 2) {
        trenutnaPozicija = pozicija[0][trenPoljeY];
        trenPoljeX=0;
    }
    nacrtajKursor(trenutnaPozicija.x, trenutnaPozicija.y);
}

//provjerava ishod igre
bool provjeriPobjedu()
{
    int brojacRedovaX = 0, brojacDijagonalaX1 = 0, brojacDijagonalaX2 = 0, brojacKolonaX= 0, br =0;
    for(int i=0; i<3; i++) {
        for(int j=0; j<3; j++) {
            if (pozicija[i][j].imaX == true) brojacRedovaX++;
            if (pozicija[j][i].imaX == true) brojacKolonaX++;
            if (i == j && pozicija[i][j].imaX == true) brojacDijagonalaX1++;
            if (j == 3 - i -1 && pozicija[i][j].imaX == true) brojacDijagonalaX2++;
            //provjerava da li su sva polja popunjena (nerijesen ishod)
            if (pozicija[i][j].upisano) br++;

        }
        if(brojacRedovaX == 3 || brojacDijagonalaX1 == 3 || brojacKolonaX == 3 || brojacDijagonalaX2 == 3) {
            brPobjedaX++;
            pobijedioX = true;
            pobijedioO = false;
            return true;
        }
        brojacRedovaX = 0;
        brojacKolonaX = 0;

    }

    int brojacRedovaO = 0, brojacDijagonalaO1 = 0, brojacKolonaO = 0, brojacDijagonalaO2 = 0;
    for(int i=0; i<3; i++) {
        for(int j=0; j<3; j++) {
            if (pozicija[i][j].imaO == true) brojacRedovaO++;
            if (pozicija[j][i].imaO == true) brojacKolonaO++;
            if (i == j && pozicija[i][j].imaO == true) brojacDijagonalaO1++;
            if (j == 3 - i -1 && pozicija[i][j].imaO == true) brojacDijagonalaO2++;

        }
        if(brojacRedovaO == 3 || brojacDijagonalaO1 == 3 || brojacDijagonalaO2 == 3 || brojacKolonaO == 3  ) {
            brPobjedaO++;
            pobijedioX = false;
            pobijedioO = true;
            return true;

        }
        brojacRedovaO = 0;
        brojacKolonaO = 0;
    }

    if (br == 9) {
        pobijedioX = false;
        pobijedioO = false;
        return true;
    }
    pobijedioX = false;
    pobijedioO = false;
    return false;
}

void zavrsenaIgra()
{
    lcd.clear();
    lcd.printString("Final ", 0 ,1);
    if (brPobjedaX > brPobjedaO) {
        lcd.printString("Winner: X", 0, 1);
    } else lcd. printString ("Winner: O", 0, 2);

    wait(2);
    
    lcd.clear();

    lcd.printString("Game over!", 1, 1);
}

void zavrsenaRunda(char c)
{
    
    lcd.clear();

    if(c =='x') {
        lcd.printString("Winner: X", 0, 1);
    } else if(c =='o') lcd. printString ("Winner: O", 0, 2);
    else lcd.printString("Tie!", 0, 3);

    wait(2);
    lcd.clear();
    

}





bool pobjediBlokirajCPU()
{
    //Kompjuter prvo provjerava mogućnosti njegove pobjede, pa blokiranja pobjede drugog igrača
    int brojacRedovaO = 0, brojacDijagonalaO1 = 0, brojacDijagonalaO2 = 0, brojacKolonaO = 0;
    int brojacRedovaX = 0, brojacDijagonalaX1 = 0, brojacDijagonalaX2 = 0, brojacKolonaX = 0;
    int pobijediRed=0,pobijedikolona=0;
    int blokirajRed = 0, blokirajKolona = 0;
// prilika da cpu pobijedi -  ima dva O u redu/koloni/dijagonali
    for(int i=0; i<3; i++) {
        for(int j=0; j<3; j++) {
            if (pozicija[i][j].imaO == true) {
                brojacRedovaO++;
                pobijediRed=i;
            }
            if (pozicija[j][i].imaO == true) {
                brojacKolonaO++;
                pobijedikolona=i;
            }
            if ( i== j && pozicija[i][j].imaO == true) {
                brojacDijagonalaO1++;
            }
            if ( j == 3 - i -1 && pozicija [i][j].imaO== true) {
                brojacDijagonalaO2++;
            }

//CPU blokira protivnika ukoliko je brojac X=2

            if (pozicija[i][j].imaX == true) {
                brojacRedovaX++;
                blokirajRed = i;
            }
            if (pozicija[j][i].imaX == true) {
                brojacKolonaX++;
                blokirajKolona = i;
            }
            if ( i== j && pozicija[i][j].imaX == true)  brojacDijagonalaX1++;
            if ( j == 3 - i -1 && pozicija [i][j].imaX == true)  brojacDijagonalaX2++;

        }
//primjer za 2 u redu
        if(brojacRedovaO == 2) {
            for(int k=0; k<3; k++) {
                if(pozicija[pobijediRed][k].upisano==false) {
                    nacrtajO(pozicija[pobijediRed][k].x, pozicija[pobijediRed][k].y);
                    pozicija[pobijediRed][k].upisano=true;
                    pozicija[pobijediRed][k].imaO=true;
                    return true;
                }
            }
        } else if(brojacKolonaO== 2) {
            for(int k=0; k<3; k++) {
                if(pozicija[k][pobijedikolona].upisano==false) {
                    nacrtajO(pozicija[k][pobijedikolona].x, pozicija[k][pobijedikolona].y);
                    pozicija[k][pobijedikolona].upisano=true;
                    pozicija[k][pobijedikolona].imaO=true;
                    return true;
                }
            }
        } else if(brojacDijagonalaO1== 2) {
            for(int k=0; k<3; k++) {
                if(pozicija[k][k].upisano==false) {
                    nacrtajO(pozicija[k][k].x, pozicija[k][k].y);
                    pozicija[k][k].upisano=true;
                    pozicija[k][k].imaO=true;
                    return true;
                }
            }
        } else if(brojacDijagonalaO2== 2) {
            for(int k=0; k<3; k++) {
                if(pozicija[k][3-k-1].upisano==false) {
                    nacrtajO(pozicija[k][3-k-1].x, pozicija[k][3-k-1].y);
                    pozicija[k][3-k-1].upisano=true;
                    pozicija[k][3-k-1].imaO=true;
                    return true;
                }
            }
        }
        if (brojacRedovaX == 2) {
            for ( int k = 0; k<3; k++) {
                if (pozicija[blokirajRed][k].upisano == false) {
                    nacrtajO(pozicija[blokirajRed][k].x, pozicija[blokirajRed][k].y);
                    pozicija[blokirajRed][k].upisano = true;
                    pozicija[blokirajRed][k].imaO=true;
                    return true;
                }
            }
        } else if (brojacKolonaX == 2) {
            for ( int k = 0; k<3; k++) {
                if(pozicija[k][blokirajKolona].upisano == false) {
                    nacrtajO(pozicija[k][blokirajKolona].x, pozicija[k][blokirajKolona].y);
                    pozicija[k][blokirajKolona].imaO=true;
                    pozicija[k][blokirajKolona].upisano=true;

                    return true;
                }
            }
        } else if (brojacDijagonalaX1 == 2) {
            for ( int k = 0; k<3; k++) {
                if(pozicija[k][k].upisano == false) {
                    nacrtajO(pozicija[k][k].x, pozicija[k][k].y);
                    pozicija[k][k].imaO=true;
                    pozicija[k][k].upisano =true;
                    return true;
                }
            }
        } else if (brojacDijagonalaX2 == 2) {
            for ( int k = 0; k<3; k++) {
                if(pozicija[k][3 - k - 1].upisano == false) {
                    nacrtajO(pozicija[k][3- k -1].x, pozicija[k][3 - k - 1].y);
                    pozicija[k][3- k -1].imaO=true;
                    pozicija[k][3 - k - 1].upisano = true;
                    return true;
                }
            }
        }
        brojacRedovaO = 0;
        brojacKolonaO = 0;
        brojacRedovaX = 0;
        brojacKolonaX = 0;
    }
    return false;
}

bool provjeriUgloveCPU()
{

    if(pozicija[0][0].upisano==false) {
        nacrtajO(pozicija[0][0].x, pozicija[0][0].y);
        pozicija[0][0].imaO=true;
        pozicija[0][0].upisano=true;
        return true;
    } else if(pozicija[0][2].upisano==false) {
        nacrtajO(pozicija[0][2].x, pozicija[0][2].y);
        pozicija[0][2].imaO=true;
        pozicija[0][2].upisano=true;
        return true;
    } else if(pozicija[2][0].upisano==false) {
        nacrtajO(pozicija[2][0].x, pozicija[2][0].y);
        pozicija[2][0].imaO=true;
        pozicija[2][0].upisano=true;
        return true;
    } else if(pozicija[2][2].upisano==false) {
        nacrtajO(pozicija[2][2].x, pozicija[2][2].y);
        pozicija[2][2].imaO=true;
        pozicija[2][2].upisano=true;
        return true;
    }
    return false;
}
bool generisiPotezCPU()
{

    int brojacRedovaO = 0, brojacKolonaO = 0;
    int odigrajRed=0,odigrajkolona=0;
    for(int i=0; i<3; i++) {
        for(int j=0; j<3; j++) {
            if (pozicija[i][j].imaO == true) {
                if(pozicija[i][j].imaX == true) {
                    brojacRedovaO = 0;
                    break;
                }
                brojacRedovaO++;
                odigrajRed=i;
            }
            if (pozicija[j][i].imaO == true) {
                if(pozicija[i][j].imaX == true) {
                    brojacKolonaO = 0;
                    break;
                }
                brojacKolonaO++;
                odigrajkolona=i;
            }
        }
        if(brojacRedovaO == 1) {
            for(int k=0; k<3; k++) {
                if(pozicija[odigrajRed][k].upisano==false) {
                    nacrtajO(pozicija[odigrajRed][k].x, pozicija[odigrajRed][k].y);
                    pozicija[odigrajRed][k].upisano=true;
                    pozicija[odigrajRed][k].imaO=true;
                    return true;
                }
            }
        } else if(brojacKolonaO== 1) {
            for(int k=0; k<3; k++) {
                if(pozicija[k][odigrajkolona].upisano==false) {
                    nacrtajO(pozicija[k][odigrajkolona].x, pozicija[k][odigrajkolona].y);
                    pozicija[k][odigrajkolona].upisano=true;
                    pozicija[k][odigrajkolona].imaO=true;
                    return true;
                }
            }

        }
        brojacRedovaO = 0;
        brojacKolonaO = 0;
    }
    return false;
}
void potezKompjutera()
{
    if(popunjenaPoljaCPU==1 && provjeriUgloveCPU() && brRundi%2 !=  0 ) {
        return;
    }
    //ako CPU igra prvi, zapocinje sa oznakom u centru
    else if(popunjenaPoljaCPU==0 && pozicija[1][1].upisano==false) {
       // wait(0.5);
        nacrtajO(pozicija[1][1].x, pozicija[1][1].y);
        pozicija[1][1].imaO=true;
        pozicija[1][1].upisano=true;

        return;
    } else if(pobjediBlokirajCPU()) {
        return;
    }

    else if(generisiPotezCPU()) {
        return;
    } else if(provjeriUgloveCPU()) {
        return;
    }


    popunjenaPoljaCPU++;
}

void odigrajPotez ()
{
    if(debounce.read_ms() > 200) {
        if (trenutnaPozicija.upisano == false) {
            if (naReduX || (naReduCPU && mode=='3') || (!prviPotez && mode=='3' && brRundi%2!=0)  ) { /*ReduCPU*/
                if(!naReduCPU && mode=='3') {
                    if(pozicija[trenPoljeX][trenPoljeY].upisano == false) {
                        nacrtajX(trenutnaPozicija.x, trenutnaPozicija.y);
                        pozicija[trenPoljeX][trenPoljeY].imaX = true;
                        pozicija[trenPoljeX][trenPoljeY].upisano = true;
                    }
                } else if(mode=='4') {
                    if(pozicija[trenPoljeX][trenPoljeY].upisano == false) {
                        nacrtajX(trenutnaPozicija.x, trenutnaPozicija.y);
                        pozicija[trenPoljeX][trenPoljeY].imaX = true;
                        pozicija[trenPoljeX][trenPoljeY].upisano = true;
                    }
                }
                if(mode=='4') //Ako je player vs player- pređi na Oks igrača
                    naReduX = false;
                else if(mode=='3') {
                    potezKompjutera();
                    naReduCPU=false; //Ako je player vs CPU - preskoči Oks igrača (prvi ostaje true)- idi na CPU potez
                }

            } else if (!naReduX && mode=='4') {
                if(pozicija[trenPoljeX][trenPoljeY].upisano == false) {
                    nacrtajO(trenutnaPozicija.x, trenutnaPozicija.y);
                    pozicija[trenPoljeX][trenPoljeY].imaO = true;
                    pozicija[trenPoljeX][trenPoljeY].upisano = true;
                    naReduX = true;
                }
            }

        }
        prviPotez=false;
        if
        (provjeriPobjedu()) {
            lcd.refresh();
            if(pobijedioX==true)zavrsenaRunda('x');
            else if(pobijedioO==true) zavrsenaRunda('o');
            else zavrsenaRunda('t');
            
            iscrtajPoljeNoveRunde();
        }
        if (brPobjedaX + brPobjedaO == 3)zavrsenaIgra();
    }
    debounce.reset();
}
//funkcija za ispisivanje pocetnog ekrana
void startniMode()
{
    lcd.clear();
    lcd.printString("Tic-Tac-Toe",1, 2);
    wait(2);
    mode = '1';
    //Prelazak na ekran odabira nakon 2 sekunde
    izborNacinaIgre();
}
void glavniMode()
{
    iscrtajGrid();
    if (mode == '4') {
        lcd.printString("P vs P",50,0);
    }
    if (mode == '3') {
        lcd.printString("P vs CPU ",50,1);
    }
    nacrtajKursor(trenutnaPozicija.x, trenutnaPozicija.y);
    lcd.printString("0:0",50,4);
}

int main()
{
    //deaktivacija led dioda
    enable = 1;
    //inicijalizacija displeja
    lcd.init();

    //Aktivacija pull-up otpornika
    SW.mode(PullUp);

    //pozivanje pocetnog ekrana
    startniMode();
    trenPoljeX = 0;
    trenPoljeY = 0;
    postavkaPolja();


    debounce.start();
    SW.rise(&odigrajPotez); //potez igrača

    while(1) {
        // pozicijaJoysticka();
        if (mode == '2') {
            //Klikom na taster
            if( VRy > 2.0/3.0) {
                mode = '3';
            }

            //donji klik na taster
            else if (VRy < 1.0/3.0) {
                mode = '4';

            }
        }
        //wait (0.01);
        if(pozvano ==false) {
            if(mode == '3' || mode == '4') {
                lcd.clear();
                glavniMode();

                pozvano=true;

            }
        }
        if(pozvano==true) {
            lcd.printString("",0,0);
            
            if (VRy < 1.0/3.0) {
                dole();
                wait(0.3);
            } else if(VRy > 2.0/3.0) {
                gore();
                wait(0.3);
            } else if (VRx < 1.0/3.0) {
                desno();
                wait(0.3);
            } else if(VRx > 2.0/3.0) {
                lijevo();
                wait(0.3);
            }
        }

    }
}

