#include "mbed.h"
#define dp23 P0_0

Serial pc(USBTX, USBRX); // tx, rx

AnalogIn VRx(dp11);
AnalogIn VRy(dp10);

DigitalIn SW(dp9);
Timer timer;

int smijer = 0; // 1 - lijevo, 3 - gore, 2 - desno, 4 - dole, 5 - centar

void usmjerenje(int noviSmijer)
{
        if(noviSmijer != smijer)
        {
        smijer = noviSmijer;
        char text[300];
        
        if(smijer == 1)
        {
            sprintf(text, "lijevo\n");
            pc.printf(text);
        }else if(smijer == 2)
        {
            sprintf(text, "desno\n");
            pc.printf(text);
        }else if(smijer == 3)
        {
            sprintf(text, "gore\n");
            pc.printf(text);
        }else if(smijer == 4)
        {
            sprintf(text, "dole\n");
            pc.printf(text);
        }else if(smijer == 5)
        {
            sprintf(text, "centar\n");
            pc.printf(text);
        }
    }
    
}

int main() {
    SW.mode(PullUp);
    timer.start();
    while (1)
    {
        if(VRx < 1.0/3.0) 
            usmjerenje(1); // lijevo
        else if(VRx < 2.0/3.0)
            usmjerenje(5); // centar
        else
            usmjerenje(2); // desno
            
        if(VRy < 1.0/3.0) 
            usmjerenje(3); // gore
        else if(VRy < 2.0/3.0)
            usmjerenje(5); // centar
        else
            usmjerenje(4); // dole        
        wait(1);
    }
}
