#include "mbed.h"
#define dp23 P0_0
 
#include "stdio.h"
#include "SPI_TFT_ILI9341.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"

SPI_TFT_ILI9341 TFT(dp2,dp1,dp6,dp24,dp23,dp25,"TFT"); // mosi, miso, sclk, cs, reset, dc

// LM35 temperaturni senzor daje na izlazu napon u funkciji od temperature
// 0V->0C; 1V->100C
AnalogIn napon(dp9);

int vratiNapon_mV(float napon){
    // Mnozimo sa 1000 da dobijemo napon u mili voltima
    // jer se trazi tacnost od 1mV
    napon *= 1000;
    int cijeliDio = (int)napon;
    float ostatak = napon - cijeliDio;
    
    // Zaokruzivanje
    if(ostatak > 0.5) cijeliDio++;
    return cijeliDio;
}

float vratiTemperaturu(float napon){
    // Vracamo temperaturu u stepenima Celzijusa
    return napon * 100;
}

void ispisiString(char *ispis, int duzina, int x, int y){
    // Ispisuje poslani string na lokaciju (x,y)
    TFT.locate(x,y);
    for(int i=0; i<duzina; i++)
        TFT._putc(*(ispis+i));
}

void ispisiINT(int broj, int x, int y){
    // Ispisuje INT na lokaciju (x,y)
    int vel = 0;
    int cifre[10];
    while(broj > 0){
        cifre[vel++] = broj%10;
        broj /= 10;
    }
    TFT.locate(x,y);
    for(int i=vel-1; i>=0; i--)
        TFT._putc(cifre[i]);
}

void ispisiTemperaturu(float t, int x, int y){
    // Ispisuje temperaturu na lokaciju (x,y) u formatu CIJELI.OSTATAK
    int cijeli = int(t);
    float ostatak = t - (int)t;
    int ostatak_CD = int(ostatak);
    float ostatak2 = ostatak_CD - (int)ostatak_CD;
    if(ostatak2 > 0.5)
        ostatak_CD++;
    ispisiINT(cijeli, x, y);
    TFT._putc('.');
    ispisiINT(ostatak_CD, x, y);   
}

int vrati_Y_osu(float temperatura){
    // Proracun Y-ose na osnovu temperature
    int cijeli = int(temperatura);
    temperatura = (temperatura - (int)temperatura)*100;   
  /*  if(temperatura>12.&&temperatura<=37.)
        cijeli++;
    else if(temperatura>37.&&temperatura<=62.)
        cijeli+=2;
    else if(temperatura>62.&&temperatura<=87.)
        cijeli+=3;
    else if(temperatura>87)
        cijeli+=4;*/
    
    return cijeli;
}

int main() {

    //Inicijalizacija;
    TFT.claim(stdout);
    TFT.set_orientation(1);
    TFT.background(Blue);     // set background to black
    TFT.foreground(White);    // set chars to white
    TFT.cls();                // clear the screen
    
    // Trenutni trenutak u vremenu
    int aktivnoVrijeme = 0;
    float aktivnaTemp = vratiTemperaturu(napon);
    float bivsaTemp = 0;
    
    while(1) {
        // Iscrtavamo X i Y osu te njihove labele
        // BROJ PIXELA TFTa: 240x320
        TFT.set_font((unsigned char*) Arial12x12);
        // funkcija line(int x0, int y0, int x1, int y1, int colour)
        TFT.line(20,20,20,220,Black); // Osa Y
        TFT.line(20,220,300,220,Black); // Osa X
        
        // Po Y osi crtamo vrijednosti temperature
        int osa_temperatura=0;
        for(int y=200; y>20; y-=20)
        {
            osa_temperatura+=5;
            // Postavljamo kursor na poziciju (x,y)
            TFT.locate(26,y);
            if(osa_temperatura/10>0)
                TFT._putc(osa_temperatura/10+48);
            TFT._putc(osa_temperatura%10+48);
        }
        
        for(int i=20; i<300; i+=20){
            int Y_aktivna = vrati_Y_osu(aktivnaTemp);
            int Y_bivsa = vrati_Y_osu(bivsaTemp);
            int x = aktivnoVrijeme%14;
          //  TFT.fillcircle(x, Y_aktivna, 5, Red);
          //  if(aktivnoVrijeme%14 > 0)
                TFT.line(aktivnoVrijeme-1, Y_bivsa, aktivnoVrijeme, Y_aktivna, Black);
        }
        
        char* U = "Napon:   ";
        char* T = "Temp:    ";
        char* t = "Vrijeme: ";
        
        // Racunamo potrebni red piksela za red i znak radi ispisivanja
        int PXL_red=240./TFT.rows();
        int PXL_znak=320./TFT.columns();
        
        ispisiString(U, 10, 200, 20);
        ispisiINT(vratiNapon_mV(napon), 200+9*PXL_znak, 20);
        TFT._putc('m');
        TFT._putc('V');
        
        ispisiString(T, 10, 200, 2*PXL_red+20);
        ispisiTemperaturu(aktivnaTemp, 200+9*PXL_znak, PXL_red+20);
        TFT._putc('C');
        
        ispisiString(t, 10, 200+9*PXL_znak, 2*PXL_red+20);
        TFT._putc('s');
        
        wait(0.9);
        bivsaTemp = aktivnaTemp;
        aktivnaTemp = vratiTemperaturu(napon);
        aktivnoVrijeme++;
    }
}
