#include "mbed.h"
#include "N5110.h"
#include "string.h"

#define dp23 P0_0

// N5110lcd (VCC, SCE, RST, DC, MOSI, SCLK, LED)) ;
N5110 lcd (dp4, dp24, dp23, dp25, dp2, dp6, dp18);
DigitalOut enable (dp14); 

// Program mjeri trenutni otpor potenciometra izmedju
// tacaka dp9 i GND

DigitalIn taster(dp1);

AnalogIn voltMetar_napon(dp9);

int main() {
    // Analogni napon 0-3.3V sa analognog ulaza se 
    // preslikava u float vrijednosti 0.0-1.0
    float otpor = 0;
    
    //deaktivacija led dioda
    enable=1;
    
    //inicijalizacija displeja
    lcd.init();
    // ("String", koordinata X, koordinata Y)
    
    int brojac = 0;
    
    while(1) {
        // R = U*I
        if(taster==1){
            brojac++;
            if(brojac>1) brojac=0;   
        }
        
        otpor = voltMetar_napon.read() * 10000;
        
        if(brojac==0){
        //    lcd.clear();
            lcd.printString("Napon: ", 0, 0);
            char ispis_napona[6];
            // Format punjenja: (buffer, format, podaci)
            sprintf(ispis_napona, "%.2f", (float)voltMetar_napon*3.3);
            ispis_napona[5]='\0';
            // Ispis na LCD
            lcd.printString(ispis_napona, 50, 0);
        }
        else if(brojac==1){
         //   lcd.clear();
            lcd.printString("Otpor: ", 0, 0);
            char ispis_otpora[6];
            sprintf(ispis_otpora, "%.2f", otpor);
            ispis_otpora[5]='\0';
            lcd.printString(ispis_otpora, 50, 0);
        }
        
        wait(0.5);
    }
}
