#include "mbed.h"
#define dp23 P0_0
 
DigitalOut enable(dp14);

DigitalOut D2(dp23); // 7 segmentni displej
DigitalOut D3(dp24);
DigitalOut D4(dp25);
DigitalOut A(dp26);
DigitalOut B(dp27);
DigitalOut C(dp5);
DigitalOut D(dp6);
DigitalOut E(dp28);
DigitalOut F(dp4);
DigitalOut G(dp18);
DigitalOut DP(dp17);

void ispisiCifru(int cifra1, int druga)
{        
    if(cifra1==0)
    {
        A=B=C=D=E=F=0;
        G=1;
        if(druga==1) DP=0;
    }
    else if(cifra1==1)
    {
        B=C=0;
        A=E=D=F=G=1;
        if(druga==1) DP=0;
    }
    else if(cifra1==2)
    {
        F=C=1;
        G=E=D=B=A=0;
        if(druga==1) DP=0;
    }
    else if(cifra1==3)
    {
        F=E=1;
        G=D=C=B=A=0;
        if(druga==1) DP=0;
    }
    else if(cifra1==4)
    {
        E=D=A=1;
        G=F=C=B=0;
        if(druga==1) DP=0;
    }
    else if(cifra1==5)
    {
        E=B=1;
        G=F=D=C=A=0;
        if(druga==1) DP=0;
    }
    else if(cifra1==6)
    {
        B = 1;
        G=F=E=D=C=A=0;
        if(druga==1) DP=0;
    }
    else if(cifra1==7)
    {
        G=F=E=D=1;
        C=B=A=0;  
        if(druga==1) DP=0;
    }
    else if(cifra1==8)
    {
        G=F=E=D=C=B=A=0;
        if(druga==1) DP=0;
    }
    else if(cifra1==9)
    {
        E=1;
        G=F=D=C=B=A=0;
        if(druga==1) DP=0;
    }
    wait(0.001);
}

void ispisiBroj(int broj)
{
        int cifra1 = broj%10;
        broj /= 10;
        int cifra2 = broj%10;
        broj /= 10;
        int cifra3 = broj%10;
       
        A=B=C=D=E=F=G=DP=1;
        D4=0;
        ispisiCifru(cifra1,0);
        D4=1;
        wait(0.001);  
       
        A=B=C=D=E=F=G=DP=1;
        D3=0;
        ispisiCifru(cifra2,1);
        D3=1;
        wait(0.001);
       
        A=B=C=D=E=F=G=DP=1;
        D2=0;
        ispisiCifru(cifra3,0);
        D2=1;
        wait(0.001);
}

int main() {
    enable = 1;
    
    A=B=C=D=E=F=G=DP=1;
    
    int brojac = 0;
    
    wait(2);
    
    while(1) {
        if(brojac>=124){
            ispisiBroj(124);
        }
        else{
            for(int i=0; i<13; i++){
                ispisiBroj(brojac);
            }
            brojac++;
        }
    }
}
