#include "ESP8266.h"
#include <string>

using namespace std;

class WiFi
{
private:
    char rcv[2048];
    char snd[255];
    ESP8266 * esp;
    Serial * pc;
    
public:
    WiFi(char * ssid, char * pw, Serial * pc)
    {
        this->pc = pc;
        this->pc->baud(115200);
        esp = new ESP8266(PTE0, PTE1, 115200);
        
        SetupModule();
        ConnectToWifi(ssid, pw);
    }
    
    string GetPage(string ip, string page)
    {
        strcpy(snd, "AT+CIPSTART=0,\"TCP\",\"173.236.171.131\",80");
        esp->SendCMD(snd);
        esp->RcvReply(rcv, 400);
        pc->printf("%s", rcv);
        
        wait(2);
        strcpy(snd, "AT+CIPSEND=0,39");
        esp->SendCMD(snd);
        esp->RcvReply(rcv, 2048);
        pc->printf("%s", rcv);
        wait(2);
        
        strcpy(snd, "GET / HTTP/1.1\r\nHost: liliumdev.com\r\n\r\n");
        esp->SendCMD(snd);
        while(true)
        {
            esp->RcvReply(rcv, 2048);
            pc->printf("%s", rcv);   
        }
    }        
        
    bool SetupModule()
    {
        wait(3);    
        pc->printf("Sending AT\r\n");
        strcpy(snd, "AT");
        esp->SendCMD(snd);
        esp->RcvReply(rcv, 400);
        pc->printf("%s", rcv);
        wait(2);
        pc->printf("Set mode to STA\r\n");
        esp->SetMode(1);
        esp->RcvReply(rcv, 1000);
        pc->printf("%s", rcv);
        
        strcpy(snd, "AT+CIPMUX=1");
        esp->SendCMD(snd);
        esp->RcvReply(rcv, 400);
        
        return true;
    }
    
    bool ConnectToWifi(char * ssid, char * pw)
    {
        pc->printf("Receiving Wifi List\r\n");
        esp->GetList(rcv);
        pc->printf("%s", rcv);
        
        pc->printf("Connecting to AP\r\n");
        esp->Join(ssid, pw);
        esp->RcvReply(rcv, 1000);
        pc->printf("%s", rcv);
        wait(8);
        pc->printf("Getting IP\r\n");
        esp->GetIP(rcv);
        
        pc->printf("%s", rcv);
        
        return true;
    }
};