#include "Bird.h"

void Bird::init()
{
    _y = 20;
    _head = 24;
    _speed = 2;

}

void Bird::set_speed(int speed) 
{
    _speed = speed;

}


void Bird::draw(N5110 &lcd)
{
    lcd.drawRect(0, _y, 4, 3, FILL_BLACK);
    lcd.setPixel(4, _y+1, true);
    lcd.setPixel(1,_head,true);
    lcd.setPixel(2,_head,true);

}

void Bird::update(Gamepad &pad)
{
    if(pad.check_event(Gamepad::A_PRESSED) == true) {
        _y -= 4;
        _head = _y-1;
    } else {
        _y += _speed;
        _head = _y+3;
    }
}


void Bird::background(N5110 &lcd)
{
    lcd.inverseMode();
    wait(0.2);
    lcd.normalMode();
    wait(0.2);
    lcd.inverseMode();
    wait(0.2);
    lcd.normalMode();
    wait(0.2);

}



int Bird::get_y ()
{
    return _y;
}






