
#include "Cylinder.h"
#include "Bird.h"

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Bird bird;
Cylinder cylinder;

void init();
void welcome();
void play();
void reset();
void restart();

int y;
int a = 0; 
int high_score;


//ELEC2645 Embedded Systems Project
//School of Electronic & Electrical Engineering
//University of Leeds
//Name: Mmeng Yang
//Username: el16ym@leeds.ac.uk
//Student ID Number: 201089063
//Date: 5th/May/2019


int main()
{

    init();
    welcome();
    cylinder.select(lcd,pad);

    while(1) {

        play();

        if(y >= 44) {
            reset();
        } if (y  <= 2) {
            reset();
            }
        
        wait(0.1);
    }
}


void init()
{

    lcd.init();
    lcd.setContrast(0.5);
    lcd.normalMode();
    lcd.setBrightness(0.5);

    pad.init();
    bird.init();
    cylinder.init();

}

void play()
{
    lcd.clear();


    cylinder.check();
    cylinder.print_score(lcd);

    bird.update(pad);
    y = bird.get_y();

    cylinder.draw(lcd);
    bird.draw(lcd);
    Data data = cylinder.get_data();

    lcd.refresh();
    if(y <= data.height1+1 | y >= data.height1 + data.gap1-4) {
        if(data.x1 <= 4) {
            reset();
        }
    }
    if(y <= data.height2+1 | y >= data.height2 + data.gap2-4) {
        if(data.x2 <= 4) {
            reset();
        }
    }
    if(y <= data.height3+1 | y >= data.height3 + data.gap3-4) {
        if(data.x3 <= 4) {
            reset();
        }
    }
    
    
    cylinder.update();

    wait(0.1);
}

void reset()
{  
    pad.init();
    cylinder.init();
    bird.init();
    restart();

}

void welcome()
{
    lcd.printString(" Flappy Bird  ",0,1);
    lcd.printString(" Press Start ",0,4);
    lcd.refresh();
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
    wait(0.2);
}

void restart()
{
    bird.background(lcd);
    lcd.clear();
    high_score = cylinder.get_highest_score(a);
    a = high_score;
    cylinder.print_yourscore(lcd);
    char buffer1[14];
    sprintf(buffer1,"HighScore = %2d ",high_score);
    lcd.printString(buffer1,0,0);
    lcd.printString(" Press Start  ",0,3);
    lcd.printString(" to continue  ",0,4);
    
    lcd.refresh();
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
    pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
    wait(0.2);
    cylinder.select(lcd,pad);
}




