#ifndef CYLINDER_H
#define CYLINDER_H

#include "Bird.h"




/**
*@brief Data struct contains position data of barrier
*/
struct Data {
    int x1; /**< int for x1 value */
    int x2; /**< int for x2 value */
    int x3; /**< int for x3 value */
    int height1; /**< int for height1 value */
    int height2; /**< int for height2 value */
    int height3; /**< int for height3 value */
    int gap1; /**< int for gap1 value */
    int gap2; /**< int for gap1 value */
    int gap3; /**< int for gap3 value */
    };


/** Cylinder Class

*@brief Library to create the barrier
*@author Meng Yang
*@date May 2017

@code

#include "Cylinder.h"
#include "Bird.h"

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
Bird bird;
Cylinder cylinder;

void init();
void welcome();
void play();
void reset();
void restart();

int y;
int a = 0; 
int high_score;


//ELEC2645 Embedded Systems Project
//School of Electronic & Electrical Engineering
//University of Leeds
//Name: Mmeng Yang
//Username: el16ym@leeds.ac.uk
//Student ID Number: 201089063
//Date: 5th/May/2019


int main()
{

    init();
    welcome();
    cylinder.select(lcd,pad);

    while(1) {

        play();

        if(y >= 44) {
            reset();
        } if (y  <= 2) {
            reset();
            }
        
        wait(0.1);
    }
}


void init()
{

    lcd.init();
    lcd.setContrast(0.5);
    lcd.normalMode();
    lcd.setBrightness(0.5);

    pad.init();
    bird.init();
    cylinder.init();

}

void play()
{
    lcd.clear();


    cylinder.check();
    cylinder.print_score(lcd);

    bird.update(pad);
    y = bird.get_y();

    cylinder.draw(lcd);
    bird.draw(lcd);
    Data data = cylinder.get_data();

    lcd.refresh();
    if(y <= data.height1+1 | y >= data.height1 + data.gap1-4) {
        if(data.x1 <= 4) {
            reset();
        }
    }
    if(y <= data.height2+1 | y >= data.height2 + data.gap2-4) {
        if(data.x2 <= 4) {
            reset();
        }
    }
    if(y <= data.height3+1 | y >= data.height3 + data.gap3-4) {
        if(data.x3 <= 4) {
            reset();
        }
    }
    
    
    cylinder.update();

    wait(0.1);
}

void reset()
{  
    pad.init();
    cylinder.init();
    bird.init();
    restart();

}

void welcome()
{
    lcd.printString(" Flappy Bird  ",0,1);
    lcd.printString(" Press Start ",0,4);
    lcd.refresh();
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
    wait(0.2);
}

void restart()
{
    bird.background(lcd);
    lcd.clear();
    high_score = cylinder.get_highest_score(a);
    a = high_score;
    cylinder.print_yourscore(lcd);
    char buffer1[14];
    sprintf(buffer1,"HighScore = %2d ",high_score);
    lcd.printString(buffer1,0,0);
    lcd.printString(" Press Start  ",0,3);
    lcd.printString(" to continue  ",0,4);
    
    lcd.refresh();
    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
    pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
    wait(0.2);
    cylinder.select(lcd,pad);
}
@endcode
*/

class Cylinder {
    public:
    
    /** 
    *@brief Initialise all the parameters of the barrier 
    */
    void init();
    
    /** 
    *@brief Draw two selections
    *@param lcd, pad 
    *@details Use this method to use the functions within N5110.h and Gamepad.h file
    */
    void select(N5110 &lcd, Gamepad &pad);
    
    /** 
    *@brief Draw the barriers
    *@param lcd
    *@details Use this method to use the functions within N5110.h file
    */
    void draw(N5110 &lcd);
    
    /** 
    *@brief update the position date of the barriers
    */
    void update();
    
    /** 
    *@brief check the specific situation
    */
    void check();
    
    /** 
    *@brief print score during playing
    *@param lcd
    *@details Use this method to use the functions within N5110.h file
    */
    void print_score(N5110 &lcd);
    
    /** 
    *@brief print score when game over
    *@param lcd
    *@details Use this method to use the functions within N5110.h file
    */
    void print_yourscore(N5110 &lcd);
    
    /** 
    *@brief get highest score
    *@param high_score 
    *@returns The highest score
    */
    int get_highest_score(int high_score);
    
    /** 
    *@brief get certain data of barriers
    *@returns a struct contains position data of barriers
    */
    Data get_data();

    
    
    
    private:
    int _a;
    int _b;
    int _c;
    int _x1;
    int _x2;
    int _x3;
    int _height1;
    int _height2;
    int _height3;
    int _gap1;
    int _gap2;
    int _gap3;
    int _score;
    int _yourscore;
    int _state;
    int _speed;
    Bird _bird;
    Data _data;


};

#endif
    

