#include "Cylinder.h"

void Cylinder::init()
{
    _x1 = 72;
    _x2 = 102;
    _x3 = 132;
    _height1 = rand()%11+10;
    _height2 = rand()%11+10;
    _height3 = rand()%11+10;
    _gap1 = rand()%11+15;
    _gap2 = rand()%11+15;
    _gap3 = rand()%11+15;
    _speed = 2;
    _score = 0;
    _state = 0;

}

void Cylinder::select(N5110 &lcd, Gamepad &pad)
{
    pad.init();
    while( pad.check_event(Gamepad::START_PRESSED) == false ) {
        lcd.clear();
        lcd.printString("Normal", 0,0);
        lcd.printString("Difficult", 0,2);
        lcd.printString(" Press Start  ",0,4);
        lcd.printString(" to continue  ",0,5);
        Direction d = pad.get_direction();
        if(d == S) {
            _state = _state + 1;
        }
        if(d == N) {
            _state = _state - 1;
        }
        if (_state < 0) {
            _state = 1;
        }
        if(_state > 1) {
            _state = 0;
        }
        switch(_state) {
            //get the first option
            case 0 :

                lcd.drawRect(42,3,13,3,FILL_BLACK);
                lcd.drawRect(37,0,5,9,FILL_BLACK);
                lcd.setPixel(36,4,true);
                lcd.setPixel(37,0,false);
                lcd.setPixel(38,0,false);
                lcd.setPixel(39,0,false);
                lcd.setPixel(37,1,false);
                lcd.setPixel(38,1,false);
                lcd.setPixel(37,2,false);
                lcd.setPixel(37,6,false);
                lcd.setPixel(37,7,false);
                lcd.setPixel(38,7,false);
                lcd.setPixel(37,8,false);
                lcd.setPixel(38,8,false);
                lcd.setPixel(39,8,false);

                break;
            case 1 :

                lcd.drawRect(63,18,13,3,FILL_BLACK);
                lcd.drawRect(58,15,5,9,FILL_BLACK);
                lcd.setPixel(57,19,true);
                lcd.setPixel(58,15,false);
                lcd.setPixel(59,15,false);
                lcd.setPixel(60,15,false);
                lcd.setPixel(58,16,false);
                lcd.setPixel(59,16,false);
                lcd.setPixel(58,17,false);
                lcd.setPixel(58,21,false);
                lcd.setPixel(58,22,false);
                lcd.setPixel(59,22,false);
                lcd.setPixel(58,23,false);
                lcd.setPixel(59,23,false);
                lcd.setPixel(60,23,false);
                _height1 = rand()%9+10;
                _height2 = rand()%9+10;
                _height3 = rand()%9+10;
                _gap1 = rand()%3+13;
                _gap2 = rand()%3+13;
                _gap3 = rand()%3+13;
                _speed = 3;
                _bird.set_speed(6);

                break;
        }
        lcd.refresh();
        wait(0.3);
    }

}


void Cylinder::draw(N5110 &lcd)
{
    lcd.drawRect(0,0,84,48,FILL_TRANSPARENT);
    lcd.drawRect(64,0,20,20,FILL_TRANSPARENT);
    if(_x1 > 60 ) {
        _a = 1;
        _b = _height2;
        _c = _height3;
    } else if (_x2 > 60) {
        _a = _height1;
        _b = 1;
        _c = _height3;
    } else if (_x3 > 60) {
        _a = _height1;
        _b = _height2;
        _c = 1;
    } else {
        _a = _height1;
        _b = _height2;
        _c = _height3;
    }


    lcd.drawRect(_x1,0,4,_a,FILL_BLACK);
    lcd.drawRect(_x1,_height1+_gap1,4,49-_height1-_gap1,FILL_BLACK);
    lcd.drawRect(_x2,0,4,_b,FILL_BLACK);
    lcd.drawRect(_x2, _height2+_gap2,4,49-_height2-_gap2,FILL_BLACK);
    lcd.drawRect(_x3,0,4,_c,FILL_BLACK);
    lcd.drawRect(_x3, _height3+_gap3, 4, 49-_height3-_gap3, FILL_BLACK);

}

void Cylinder::update()
{
    _x1 -= _speed;
    _x2 -= _speed;
    _x3 -= _speed;

}

void Cylinder::check()
{
    if(_state == 0 )
    {
    if(_x1 < 0) {
        _x1 = 86;
        _height1 = rand()%11+10;
        _gap1 = rand()%11+15;
        _score += 1;
    }
    if(_x2 < 0) {
        _x2 = 86;
        _height2 = rand()%11+10;
        _gap2 = rand()%11+15;
        _score += 1;
    }
    if(_x3 < 0) {
        _x3 = 86;
        _height3 = rand()%11+10;
        _gap3 = rand()%11+15;
        _score += 1;
    }
    }
    if(_state == 1) {
            if(_x1 < 0) {
        _x1 = 86;
        _height1 = rand()%9+10;
        _gap1 = rand()%3+13;
        _score += 1;
    }
    if(_x2 < 0) {
        _x2 = 86;
        _height2 = rand()%9+10;
        _gap2 = rand()%3+13;
        _score += 1;
    }
    if(_x3 < 0) {
        _x3 = 86;
        _height3 = rand()%9+10;
        _gap3 = rand()%3+13;
        _score += 1;
    }
    }
}

void Cylinder::print_score(N5110 &lcd)
{
    _yourscore = _score;
    char buffer[1];
    int score = _yourscore;
    sprintf(buffer, "%2d", score);
    lcd.printString(buffer, 65,1);

}

void Cylinder::print_yourscore(N5110 &lcd)
{
    char buffer2[14];
    int yourscore = _yourscore;
    sprintf(buffer2,"YourScore = %2d ",yourscore);
    lcd.printString(buffer2,0,1);
}

int Cylinder::get_highest_score(int high_score)
{
    if (high_score <= _yourscore) {
        high_score = _yourscore;
    }
    return high_score;
}


Data Cylinder::get_data()
{
    _data.x1 = _x1;
    _data.x2 = _x2;
    _data.x3 = _x3;

    _data.height1 = _height1;
    _data.height2 = _height2;
    _data.height3 = _height3;

    _data.gap1 = _gap1;
    _data.gap2 = _gap2;
    _data.gap3 = _gap3;

    return _data;

}




