#ifndef BIRD_H
#define BIRD_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Bird Class

*@brief Library to create the bird
*@author Meng Yang
*@date May 2017

*/

class Bird

{
    public :
    
    /** 
    *@brief Initialise all the parameters of the bird 
    */
    void init();
    
    /** 
    *@brief Set the speed of the bird
    *@param speed 
    *@details The speed of the bird
    */
    void set_speed(int speed);
    
    /** 
    *@brief Draw the bird
    *@param lcd The name of N5110 object
    *@details Use this method to use the functions within N5110.h file
    */
    void draw(N5110 &lcd);
    
    /**
    *@brief update the data of the bird
    *@param pad The name of Gamepad object
    *@details Use this method to use the functions within Gamepad.h file
    */
    void update(Gamepad &pad);
    
    /**
    *@brief set lcd mode when game over
    *@param lcd The name of N5110 object
    *@details Use this method to use the functions within N5110.h file
    */
    void background(N5110 &lcd);
    
    /**
    *@brief get position of the bird
    *@returns position of the bird
    */
    int get_y();

    
    
    private :
    int _y;
    int _head;
    int _speed;

};

#endif
    