#include "mbed.h"
#include "RHT03.h" //Include neede to use the RHT03 lib

Serial pc(USBTX, USBRX);
I2C i2c(p28,p27); //sda=p28. scl=p27

Serial xBee(p9, p10); //xBee pins

int done=0;
float temp,hum;

RHT03 humtemp(p21); //Initalise the RHT03 (change pin number to the pin its connected to)

DigitalOut lysdiode(p14);

void tickerFunction() {
    //I2C CO2
    const char cmd[4] = {0x22,0x00,0x08,0x2A};
    i2c.write(0xD0, cmd, 4);
    char data[4] = {0x00,0x00,0x00,0x00};
    wait_ms(50);
    i2c.read(0xD1, data, 4);
    int CO2i2c = (int)data[1]*0x100 + (int)data[2];
    
    

    //Print data
    pc.printf("CO2: %d\n", CO2i2c);

    //Hum & Temp
    while(!done) { //Loop keeps running until RHT03 is read succesfully
        wait(2); //Needed to make sure the sensor has time to initalise and so its not polled too quickly
        if(humtemp.readData() == RHT_ERROR_NONE) done=1; //Request data from the RHT03
    }

    done = 0;
    temp = humtemp.getTemperatureC(); //Gets the current temperature in centigrade
    hum = humtemp.getHumidity(); //Gets the current humidity in percentage

    if (hum > 50 || temp > 23 || CO2i2c > 1000) {
            lysdiode = 0;
        } else {
            lysdiode = 1;    
        }

//Print data
    pc.printf("Hum: %0.2f, Temp: %0.2f\n", hum, temp);
    xBee.printf("xxxx;indeklima;%0.2f;%0.2f;%i\r\n", hum, temp, CO2i2c);
        
}

Ticker ticker;

int main()
{

    pc.printf("Hello\n");

    i2c.frequency(100000); //mBed default frequency = 100kHz = max frequency of CO2 sensor
    ticker.attach(&tickerFunction, 5.0); //update every 1 sec

    while (1) {
    }
}
