/** Pokemon Class
@brief Used for containing Pokemon Stats within the game, and doing the some of the calculations for the battles
@brief Also uses xp to determine wether your pokeon should level up or not

@brief Revision 2

@author Aaron Lad
@date   3rd May 2017
*/

#include <string>
#include "N5110.h"

typedef signed int uns;

extern std::string TypeString[3];
extern std::string name[3];
typedef enum Type {Fire, Grass, Water} PokeType; //3 different pokemon types in the game

class Pokemon
{

public:
    Pokemon();
    
    /* Pokemon Class for the chosen pokemon.
     * @param uns - A signed variable used for the Level and HP of the Pokemon
     * @param PokeType - The typing for the chosen pokemon
    */
    Pokemon(uns, uns, PokeType); 
    
    /* set Type used to update the Typing for a Pokemon within the class
     * @param PokeType - variable of either Grass, Fire or Water
    */
    void setType(PokeType);
    
    /* level up used to incrememnt the level of the Players pokemon
    */
    void levelUp();
    
    /* win, used to increase the exp of the players pokemon, and to check if a level up is needed
     * @param N5110 &lcd - allows the function the use of the N5110 class
     */
    void win(N5110 &lcd);
    
    // String to define the Name of the Players Pokemons Name
    std::string Name(void);
    
    //String to define the Name of the Players Pokemons Type
    std::string Type(void);
    
    //String to define the Name of the Players Pokemons HealthPoints
    std::string HP(void);
    
    //String to define the Name of the Players Pokemons level
    std::string Level(void);
    
    /* Determines the damage done by your pokemon
     * @param Pokemon e - The stats of the opposing pokemon
     * @returns
     *
     *      damage2    -    pokemons damage
    */
    int YourTurn(Pokemon e);
    
    /* Determines the damage done by the opposing Pokemon
     * @param Pokemon e - The stats of the opposing pokemon
     * @returns
     *
     *      damage1    -    pokemons damage
     */
    int OpponentTurn(Pokemon e);//battle simulation
    
    /* Gives the max Healthpoints for the opposing pokemon 
     * @param Pokemon e - The stats of the opposing pokemon
     * @returns
     *
     *      uns e.healthPoints;
     */
    int HPO(Pokemon e);
    
    /* Gives the max HP for your Pokemon
     * @returns 
     *      
     *      uns healthPoints;
    */
    int HPA();


private:                //stats for pokemon

//--------vairables-----------
    PokeType typing;
    uns level;
    uns healthPoints;
    uns exp;
    uns lvlUp;
};



