#include "Pokemon.h"
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Bitmap.h"

std::string pokeNames[3] = {"Charmander","Bulbasaur","Squirtle"};
std::string TypeString[3] = {"Fire", "Grass", "Water"};

Pokemon::Pokemon(void)
{
    //Standard layout for adding information to the class
    Pokemon(5,20,Fire);
}


Pokemon::Pokemon(uns lvl, uns HP, PokeType type)
{
    //setting the information given from the use of this function to use in the class
    level = lvl;
    healthPoints = HP;
    typing = type;
    lvlUp = 20;
}


void Pokemon::setType(PokeType Type)
{
    //initial setup of partner pokemon
    typing = Type;
    healthPoints = 20;
    level = 5;

}


void Pokemon::levelUp()
{
    //increasing the value of the level and Health point variables, and resetting the exp variable when pokemon levels up
    level ++;
    healthPoints += 2;
    exp = 0;
}

std::string Pokemon::Name(void)
{
    //copying the Pokemon name to a character buffer
    char name[25];
    strncpy(name,pokeNames[typing].c_str(), sizeof(name));
    return name;
}

std::string Pokemon::Type(void)
{
    //copying the Pokemon Type to a character buffer
    char typ[15];
    strncpy(typ,TypeString[typing].c_str(), sizeof(typ));
    char typeBuffer[30];
    sprintf(typeBuffer, "Type: %s", typ);
    return typeBuffer;
}

std::string Pokemon::HP(void)
{
    //copying the Pokemon Health Point stat to a character buffer
    char stats[50];
    sprintf(stats, "HP: %u", healthPoints);
    return stats;
}

std::string Pokemon::Level(void)
{
    //copying the Pokemon level to a character buffer
    char levels[50];
    sprintf(levels, "Lvl:%u", level);
    return levels;
}

int Pokemon::OpponentTurn(Pokemon e)
{
    //setting starting damage to 2 less than Pokemon level
    int damage1 = e.level-2;
    //comparing Pokemon types and Adjusting damage accordingly
    if ((e.typing == Fire && typing == Water )|| (e.typing == Grass && typing == Fire) || (e.typing == Water && typing == Grass)) {//half damage
        damage1 = 0.5 * damage1;
    } else if ((e.typing == Fire && typing == Grass)||(e.typing == Grass && typing == Water)||(e.typing == Water && typing == Fire)) {//double damage
        damage1 = 2 * damage1;
    }
    //returning final value for damage
    return damage1;
}


int Pokemon::YourTurn(Pokemon e)
{
     //setting starting damage to 2 less than Pokemon level
    int damage2 = level -2;
    //comparing Pokemon types and Adjusting damage accordingly
    if ((e.typing == Fire && typing == Water )|| (e.typing == Grass && typing == Fire) || (e.typing == Water && typing == Grass)) {//double damage
        damage2 = 2 * damage2;
    } else if ((e.typing == Fire && typing == Grass)||(e.typing == Grass && typing == Water)||(e.typing == Water && typing == Fire)) {//half damage
        damage2 = 0.5 * damage2;
    }
    //returning final value for damage
    return damage2;
}

void Pokemon::win(N5110 &lcd)
{
    //increasing exp by 2 for a win
    exp = exp + 20;
    //Checking for level up
    if (exp >= lvlUp) {
        ///printf("levelup");
        Pokemon::levelUp();
        //increasing value of exp needed for level up 
        lvlUp = lvlUp + 10;
        wait(1.0);
        lcd.clear();
        lcd.printString("LEVEL UP!!",12,3);
        lcd.refresh();
        wait(1.0);
    }
}

int Pokemon::HPO(Pokemon e)
{
    //getting value for healthpoints
    int HP1 = e.healthPoints;
    return HP1;
}

int Pokemon::HPA()
{
    //getting value for healthpoints
    int HP2 = healthPoints;
    return HP2;
}