/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.
@brief Reverse Parking Sensor
@author Andreas Konstantinou 
@date   April 2015
*/
 
#ifndef MAIN_H
#define MAIN_H
#include "mbed.h"
#include "N5110.h"
#include "SRF02.h"
#include "beep.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"

#define USR_POWERDOWN (0x140)

/**  
@namespace srf02
@brief ultrasonic distance sensor connects to I2C pins SDA and SCL
*/
SRF02 srf02(p28,p27); 


/**  
@namespace leds
@brief The four LEDs on mbed 
*/
BusOut leds(LED4, LED3, LED2, LED1);
 
/**  
@namespace lcd
@brief NOKIA 5110 LCD display   
*/
 N5110 lcd(p7,p8, p9, p10,p11, p13,p26); //vcc,sce,rst,dc,mosi,clk,led  
 /**  
@namespace buzzer
@brief a piezo buzzer connected to PWM pin 
*/
Beep buzzer(p21); 

 /**  
@namespace led_red
@brief Red led connected to PWM pin for brightness
*/
DigitalOut led_red(p24);

 /**  
@namespace led_yellow
@brief Yellowonnected to PWM pin for brightness
*/
DigitalOut led_yellow(p23);

 /**  
@namespace led_green
@brief Green led connected to PWM pin for brightness    
*/
DigitalOut led_green(p22);

 /**  
@namespace ain2
@brief Analog input for the potentiometer to control the frequency of the buzzer    
*/
AnalogIn ain2(p20);

 /**  
@namespace ain1
@brief Analog input for the potentiometer to control the brightness of the lcd    
*/
AnalogIn ain1(p19);

 /**  
@namespace button_1
@brief Set button_1 to be interrupt, coonected to GPIO   
*/
InterruptIn button_1(p17);

/**  
@namespace button_2
@brief set button_2 to be interrupt, coonected to GPIO       
*/
InterruptIn button_2(p18);

/**  
@namespace button_3
@brief set button_3 to be interrupt, coonected to GPIO       
*/

InterruptIn button_3(p16);

/**  
@namespace button_4
@brief set button_4 to be interrupt, coonected to GPIO       
*/
InterruptIn button_4(p15);

/**  
@namespace timer_red
@brief ticker object used to control the time of red LED   
*/
Ticker timer_red; 

/**  
@namespace timer_yellow
@brief ticker object used to control the time of yellow LED   
*/
Ticker timer_yellow;

/**  
@namespace timer_green
@brief ticker object used to control the time of green LED   
*/
Ticker timer_green;

/** Get Avegare distance
    *
    *   This function gets the avegare distance of 5 values of the sensor   
    */
void Get_Average();

/** Timer Expired red led 
    *
    *   This function sets the flag of the red led to high    
    */
void timerExpired_red();

/** Button1 Pressed
    *
    *   This function sets the flag of button 1 to high   
    */
void button1_Pressed();

/** Button2 Pressed
    *
    *   This function sets the flag of button 2 to high   
    */
void button2_Pressed();

/** Button3 Pressed
    *
    *   This function sets the flag of button 3 to high   
    */
void button3_Pressed();

/** Button4 Pressed
    *
    *   This function sets the flag of button 4 to high   
    */
void button4_Pressed();
    
/** Timer Expired yellow led 
    *
    *   This function sets the flag of the yellow led to high    
    */
void timerExpired_yellow();

/** Timer Expired green led 
    *
    *   This function sets the flag of the green led to high  
    */
void timerExpired_green();

 /**  Check states of the buttons
    *
    *   This function checks the status between the buttons 2, 3, and 4 and based on the status of each one then executes the appropiate process   
    */
void ButtonsOperation();
 
 /** Check state of button 1
    *
    *   This function checks the state of the button 1. if button1 is pressed then 
    *   the leds and buzzer start blinking and making sound,repsectively, based on the measurements of the sensor  
    */  
void buttonOperation_1();
 
 /** Check state of button 2
    *
    *   This functions checks the status of the button 2. if it is pressed then converts 
    *   the units of the sensor's measurements from meters to centimeters and displays them on the lcd
    */
void buttonOperation_2();
 
 /** Check state of button 3
    *
    *   This functions checks the status of the button 3. if it is pressed then a new pattern is showed in the lcd 
    *   and displays the measured distance.  
    */
void buttonOperation_3();

 /** Check state of button 4
    *
    *   This functions checks the status of the button 4. if it is pressed then  
    *   a new pattern is displayed on lcd and displays the sensor's measurements
    */
void buttonOperation_4();

 /** Print Current Time and Date 
    *
    *   This function sets the current time and date and prints them on the dispaly
    */
void Print_Time_Date();

int timerflag_red = 0; /*!< timer flag red LED set in ISR */
int timerflag_yellow = 0;/*!< timer flag yellow LED set in ISR */
int timerflag_green = 0;/*!< timer flag green LED set in ISR */
int setTimeFlag = 0;/*!<  time flag set in ISR */
int button1_flag=0; /*!< button 1 flag set in ISR */
int button2_flag=0;/*!< button 2 flag set in ISR */
int button3_flag=0;/*!< button 3 flag set in ISR */
int button4_flag=0;/*!< button 4 flag set in ISR */
char buffer[5];  /*!< buffer used to display characters on lcd, each character is 6 pixels wide, screen is 84 pixels (84/6 = 14maximum)*/
float a1;/*!< a1 used to control the brightness of the LED background display by getting the value of the potentiometer1 */
float a2;/*!< a2 used to control the frequency of the buzzer by getting the value of the potentiometer2*/
float distance=0;/*!<this global variable used to get the average of 5 values of sensor */ 
float Distance_Array[5]; /*!< Distance_Array used to store 5 values of the sensor*/

#endif
