/**
@file main.cpp
@brief Reverse Parking Sensor Project
*/

#include "main.h"

void Get_Average() 
{  
  distance =0;//set the distance to 0
  int counter =0; //set the counter to 0 
  
  //for loop to store 5 sensor's values
   for ( counter =0; counter<5; counter++) {
            
             Distance_Array [counter] =srf02.getDistanceCm(); //store the value of the sensor in the array 
     } 
    
    distance= (Distance_Array[0] + Distance_Array[1]+Distance_Array[2] + Distance_Array[3]+Distance_Array[4])/5; // get the average of the five values of the sensor  
}
    
//set power down the USB interface
int semihost_powerdown()
{
    uint32_t arg;
    return __semihost(USR_POWERDOWN, &arg);
    
    }
    
//Interrupt Service Routine
void button1_Pressed()
{
    button1_flag = !button1_flag; //set flag
}
void button2_Pressed()
{
    button2_flag = !button2_flag; //set flag
}
void button3_Pressed()
{
    button3_flag = !button3_flag; //set flag
}
void button4_Pressed()
{
    button4_flag = !button4_flag; //set flag
}

void Print_Time_Date()
{
    char buffer_time_lcd[14];// buffer to store the time into the 14 characters each char has 6 pixels,so 84/6 = 14
    char buffer_date_lcd[14];
    time_t seconds = time(NULL); // get current time

    // format time and date into 2 strings (time and date)
    strftime(buffer_time_lcd, 14 , "%r",localtime(&seconds));
    strftime(buffer_date_lcd, 14 , "%d %b %G ",localtime(&seconds));

    // print current date and time value on the LCD
    lcd.printString(buffer_time_lcd,0,4);
    lcd.printString(buffer_date_lcd,0,5);
}

// Interrupt Service Routine
void timerExpired_red()
{
    timerflag_red = 1; // set flag
}

void timerExpired_yellow()
{
    timerflag_yellow= 1; // set flag
}

void timerExpired_green()
{
    timerflag_green = 1; // set flag
}

void buttonOperation_1()
{
    // if button1 is pressed
    if (button1_flag) {
        a2=ain2.read(); // read value of potentiometer
        if (distance <= 16) {
            //set the values of leds
            led_yellow =0;
            led_green =0;
            led_red =  1;
            buzzer.beep(500+a2*1000,2.0);// buzzer makes sound with a delay of 2 seconds
        }
        if (distance > 16 && distance < 100) {
            if (timerflag_red) { // if flag is set
                timerflag_red = 0; // reset flag
                led_yellow =0;
                led_green =0;
                led_red = ! led_red;
                buzzer.beep(500+a2*1000,0.2);// buzzer makes sound with a delay of 2 seconds
            }
        }
        if(distance >= 100 && distance < 300) {
            if (timerflag_yellow) { // if flag is set
                timerflag_yellow = 0; // reset flag
                led_red =0;
                led_green =0;
                led_yellow = ! led_yellow;
                buzzer.beep(500+a2*1000,0.5); // buzzer makes sound with a delay of 0.5 seconds
            }
        }

        if (distance >= 300 && distance <=600 ) {
            if (timerflag_green) { // if flag is set
                timerflag_green = 0; // reset flag
                led_red =0;
                led_yellow =0;
                led_green = ! led_green;
                buzzer.beep(500+a2*1000,0.8); // buzzer makes sound with a delay of 0.5 seconds
            }
        }

        if (distance >600 ) {
            led_red =0;
            led_yellow =0;
            led_green =0;
        }
    }

    else  {
        if (distance < 100) {
            led_yellow =0;
            led_green =0;
            led_red = 1;
        } else
            led_red =0;


        if (distance >= 100 && distance < 300) {
            led_red =0;
            led_green =0;
            led_yellow = 1;
        } else
            led_yellow =0;

        if (distance >= 300 && distance <=600 ) {
            led_red =0;
            led_yellow =0;
            led_green = 1;
        } else
            led_green =0;

        if (distance >600 ) {
            led_red =0;
            led_yellow =0;
            led_green =0;
        }
    }
}

void buttonOperation_2()
{
    
    if (button2_flag==0 && button3_flag==0 && button4_flag==0) {

        int length = sprintf(buffer,"%.fcm",distance); // print formatted data to buffer
        // it is important the format specifier ensures the length will fit in the buffer
        if (length == 5 ) { // if string will fit on display

            lcd.clear(); // clear LCD
            lcd.refresh(); // refresh LCD
            lcd.printString(buffer,25,2);// display on screen
        }

        if (length < 5 ) { // if string will fit on display
            lcd.clear();
            lcd.refresh();
            lcd.printString(buffer,29,2);// display on screen
        }
    }

    if (button2_flag==1 && button3_flag==0 && button4_flag==0) {

        int length = sprintf(buffer,"%.2fm",distance/100);
        if (length <= 5) { // if string will fit on display
            lcd.clear();
            lcd.refresh();
            lcd.printString(buffer,26,2);// display on screen
        }

    }

    if (distance < 16) {
        lcd.clear();
        lcd.refresh();
        lcd.printString("STOP",28,2);
        lcd.printString("YOU WILL CRASH",0,0);

    }

    if (distance < 100 && distance >=16) {

        lcd.printString("***DANGER***",5,0);//display on the N5110 LCD
    }

    else if (distance >=  100 && distance <300) {

        lcd.printString("Be Careful",12,0);

    } else if (distance >=  300 && distance <=600) {

        lcd.printString("***Move***",11,0);
    }

    else if (distance >  600) {

        lcd.clear();
        lcd.refresh();
        lcd.printString("*Out of range*",0,0);
        lcd.printString("MOVE",28,2);
    }

    //draw rectacular and lines on the screen
    lcd.drawRect(20,10,40,18,0);
    lcd.drawRect(21,11,38,16,0);
    lcd.drawRect(22,12,36,14,0);
    lcd.drawLine(0,19,20,19,1);
    lcd.drawLine(60,19,83,19,1);
    //call the function
    Print_Time_Date();

}
void buttonOperation_3()
{

    int length = sprintf(buffer,"%.2fm",distance/100); // print formatted data to buffer
    // it is important the format specifier ensures the length will fit in the buffer
    if (length <= 5 && distance>=16 && distance<=600) { // if string will fit on display
        lcd.printString(buffer,28,3);
    }

    int counter_Y = 40;//initial variable for the y-axes of the screen
    int counter_X_L = 0; // initial variable for the x-axes on the left side of the screen
    int counter_X_R = 83;// initial variable for the x-axes on the right side of the screen

    if (distance < 16) {
        lcd.printString("STOP",30,3);
        lcd.printString("YOU WILL CRASH",0,0);

        while (counter_Y>=15) {
            // for loop to set the pixels
            for (int i = counter_Y; i<41; i++) {
                lcd.setPixel(counter_X_L,i);
                lcd.setPixel(counter_X_R,i);
            }
            counter_Y = counter_Y -1;
            counter_X_L = counter_X_L +1;
            counter_X_R = counter_X_R -1;
        }
    }

    if (distance >= 16 && distance <= 40) {
        lcd.printString("***DANGER***",5,0);//display on the N5110 LCD

        while (counter_Y>=17) {

            for (int i = counter_Y; i<41; i++) {
                lcd.setPixel(counter_X_L,i);
                lcd.setPixel(counter_X_R,i);
            }

            counter_Y = counter_Y -1;
            counter_X_L = counter_X_L +1;
            counter_X_R = counter_X_R -1;
        }
    }
    if (distance > 40 && distance <= 100) {
        lcd.printString("***DANGER***",5,0);

        while (counter_Y>=19) {

            for (int i = counter_Y; i<41; i++) {
                lcd.setPixel(counter_X_L,i);
                lcd.setPixel(counter_X_R,i);
            }

            counter_Y = counter_Y -1;
            counter_X_L = counter_X_L +1;
            counter_X_R = counter_X_R -1;
        }
    }
    if (distance > 100 && distance<=150) {
        lcd.printString("Be Careful",12,0);

        while (counter_Y>=21) {

            for (int i = counter_Y; i<41; i++) {
                lcd.setPixel(counter_X_L,i);
                lcd.setPixel(counter_X_R,i);
            }

            counter_Y = counter_Y -1;
            counter_X_L = counter_X_L +1;
            counter_X_R = counter_X_R -1;
        }
    }

    if (distance > 150 && distance<=200) {
        lcd.printString("Be Careful",12,0);

        while (counter_Y>=23) {

            for (int i = counter_Y; i<41; i++) {
                lcd.setPixel(counter_X_L,i);
                lcd.setPixel(counter_X_R,i);
            }

            counter_Y = counter_Y -1;
            counter_X_L = counter_X_L +1;
            counter_X_R = counter_X_R -1;
        }
    }
    if (distance > 200 && distance<=250) {
        lcd.printString("***Move***",11,0);

        while (counter_Y>=25) {

            for (int i = counter_Y; i<41; i++) {
                lcd.setPixel(counter_X_L,i);
                lcd.setPixel(counter_X_R,i);
            }

            counter_Y = counter_Y -1;
            counter_X_L = counter_X_L +1;
            counter_X_R = counter_X_R -1;
        }
    }
    if (distance > 250 && distance<=300) {
        lcd.printString("***Move***",11,0);

        while (counter_Y>=27) {

            for (int i = counter_Y; i<41; i++) {
                lcd.setPixel(counter_X_L,i);
                lcd.setPixel(counter_X_R,i);
            }

            counter_Y = counter_Y -1;
            counter_X_L = counter_X_L +1;
            counter_X_R = counter_X_R -1;
        }
    }
    if (distance > 300 && distance<=350) {
        lcd.printString("***Move***",11,0);

        while (counter_Y>=29) {

            for (int i = counter_Y; i<41; i++) {
                lcd.setPixel(counter_X_L,i);
                lcd.setPixel(counter_X_R,i);
            }

            counter_Y = counter_Y -1;
            counter_X_L = counter_X_L +1;
            counter_X_R = counter_X_R -1;
        }
    }
    if (distance > 350 && distance<=400) {
        lcd.printString("***Move***",11,0);

        while (counter_Y>=31) {

            for (int i = counter_Y; i<41; i++) {
                lcd.setPixel(counter_X_L,i);
                lcd.setPixel(counter_X_R,i);
            }

            counter_Y = counter_Y -1;
            counter_X_L = counter_X_L +1;
            counter_X_R = counter_X_R -1;
        }

    }
    if (distance > 400 && distance<=450) {
        lcd.printString("***Move***",11,0);

        while (counter_Y>=33) {

            for (int i = counter_Y; i<41; i++) {
                lcd.setPixel(counter_X_L,i);
                lcd.setPixel(counter_X_R,i);
            }

            counter_Y = counter_Y -1;
            counter_X_L = counter_X_L +1;
            counter_X_R = counter_X_R -1;
        }
    }
    if (distance > 450 && distance<=500) {
        lcd.printString("***Move***",11,0);

        while (counter_Y>=35) {

            for (int i = counter_Y; i<41; i++) {
                lcd.setPixel(counter_X_L,i);
                lcd.setPixel(counter_X_R,i);
            }

            counter_Y = counter_Y -1;
            counter_X_L = counter_X_L +1;
            counter_X_R = counter_X_R -1;
        }
    }
    if (distance > 500 && distance<=550) {
        lcd.printString("***Move***",11,0);

        while (counter_Y>=37) {

            for (int i = counter_Y; i<41; i++) {
                lcd.setPixel(counter_X_L,i);
                lcd.setPixel(counter_X_R,i);
            }

            counter_Y = counter_Y -1;
            counter_X_L = counter_X_L +1;
            counter_X_R = counter_X_R -1;
        }
    }
    if (distance > 550 && distance<=600) {
        lcd.printString("***Move***",11,0);
        lcd.setPixel(0,40);
        lcd.setPixel(1,40);
        lcd.setPixel(1,39);
        lcd.setPixel(83,40);
        lcd.setPixel(82,40);
        lcd.setPixel(82,39);
    }
    if (distance>600) {
        lcd.printString("*Out of range*",0,0);
        lcd.printString("Move",30,3);
    }
}
void buttonOperation_4()
{
    //draw circles, lines and rectacular for the car on the NOKIA 5110 display
    lcd.drawCircle(15,37,7,1);
    lcd.drawLine(16,23,6,33,1);
    lcd.drawLine(0,35,35,35,1);
    lcd.drawLine(15,12,35,21,1);
    lcd.drawLine(35,34,35,21,1);
    lcd.drawLine(0,12,15,12,1);
    lcd.drawRect(3,16,11,6,0);
    lcd.drawLine(18,16,29,22,1);
    lcd.drawLine(18,15,18,22,1);
    lcd.drawLine(18,22,28,22,1);
    lcd.drawLine(16,14,16,23,1);
    lcd.drawLine(1,14,16,14,1);
    lcd.drawLine(1,14,1,33,1);
    lcd.drawLine(1,33,6,33,1);
    lcd.drawLine(1,23,16,23,1);
    lcd.drawCircle(40,33,2,1);
    lcd.drawRect(62,8,14,38,1);

  
    int length = sprintf(buffer,"%.2fm",distance/100);
    if (length <= 5 && distance>= 16 && distance<= 600)  // if string and distance>=16 and distance<=600 will fit on display
        lcd.printString(buffer,25,1);// display on screen

    if (distance< 16 ) {
        lcd.printString("Stop",30,1);// display on screen
        lcd.printString("YOU WILL CRASH",0,0);// display on screen
        lcd.drawLine(45,32,45,34,1);
        lcd.drawLine(48,30,48,36,1);
        lcd.drawLine(51,28,51,38,1);
        lcd.drawLine(54,26,54,40,1);
        lcd.drawLine(57,24,57,42,1);
        lcd.drawLine(60,22,60,44,1);
    }

    if (distance>=16 && distance < 30) {
        lcd.printString("Stop",30,0);// display on screen
        //draw lines on the screen
        lcd.drawLine(45,32,45,34,1);
        lcd.drawLine(48,30,48,36,1);
        lcd.drawLine(51,28,51,38,1);
        lcd.drawLine(54,26,54,40,1);
        lcd.drawLine(57,24,57,42,1);
        lcd.drawLine(60,22,60,44,1);
    }
    if (distance >= 30 && distance < 100) {
        lcd.printString("***DANGER***",5,0);//display on the N5110 LCD
        lcd.drawLine(45,32,45,34,1);
        lcd.drawLine(48,30,48,36,1);
        lcd.drawLine(51,28,51,38,1);
        lcd.drawLine(54,26,54,40,1);
        lcd.drawLine(57,24,57,42,1);
    }
    if (distance >= 100 && distance <200 ) {
        lcd.printString("Be Careful",12,0);
        lcd.drawLine(45,32,45,34,1);
        lcd.drawLine(48,30,48,36,1);
        lcd.drawLine(51,28,51,38,1);
        lcd.drawLine(54,26,54,40,1);
    }
    if (distance >= 200 && distance <300 ) {
        lcd.printString("***Move***",11,0);
        lcd.drawLine(45,32,45,34,1);
        lcd.drawLine(48,30,48,36,1);
        lcd.drawLine(51,28,51,38,1);
    }
    if (distance >= 300 && distance <400 ) {
        lcd.printString("***Move***",11,0);
        lcd.drawLine(45,32,45,34,1);
        lcd.drawLine(48,30,48,36,1);
    }
    if (distance >= 400 && distance <=600 ) {
        lcd.printString("***Move***",11,0);
        lcd.drawLine(45,32,45,34,1);
    }
    if (distance > 600) {
        lcd.printString("*Out of range*",0,0);
    }
}

void ButtonsOperation()
{
    if (button3_flag == 0 && button4_flag==0)  { // check the status of the button 3 and 4

        buttonOperation_2(); // call function
    }

    if (button3_flag == 1 && button4_flag==0)  { // check the status of the button 3 and 4

        lcd.clear();//clear display
        lcd.refresh();//refresh display
        buttonOperation_3(); // call function
        button_4.rise(NULL); // button_4 becomes disable
        button_2.rise(NULL); // button_2 becomes disable
    }

    else
        button_4.rise(&button4_Pressed); // event generated on rising edge
    button_2.rise(&button2_Pressed); // event generated on rising edge
    lcd.refresh();

    if
    (button4_flag == 1  && button3_flag==0 ) {

        lcd.clear();
        lcd.refresh();
        buttonOperation_4();
        button_3.rise(NULL); // button_3 becomes disable
        button_2.rise(NULL); // button_2 becomes disable


    } else
        button_3.rise(&button3_Pressed); // event generated on rising edge
    button_2.rise(&button2_Pressed); // event generated on rising edge
    lcd.refresh();

}

int main()
{
    lcd.init();//initialise display
    //set intial values of the leds
    led_red = 0;
    led_yellow=0;
    led_green=0;
    
    int result = semihost_powerdown();// power down the USB interface

    timer_red.attach(&timerExpired_red, 0.2); // call ISR every 0.2 seconds
    timer_yellow.attach(&timerExpired_yellow, 0.5); // call ISR every 0.5 seconds
    timer_green.attach(&timerExpired_green, 0.8); // call ISR every 0.8 seconds

    button_1.rise(&button1_Pressed); // event generated on rising edge
    button_2.rise(&button2_Pressed); // event generated on rising edge
    button_3.rise(&button3_Pressed); // event generated on rising edge
    button_4.rise(&button4_Pressed); // event generated on rising edge

    //set_time(1431299403); // initialise time to current time

    //print welcome messages
    lcd.printString("Parking_Sensor",0,0);//display on the N5110 LCD
    lcd.printString("By",35,2);//display on the N5110 LCD
    lcd.printString("Andreas",20,3);//display on the N5110 LCD
    lcd.printString("Konstantinou",5,4);//display on the N5110 LCD

    // draw lines and circles for the car on the right side of the display
    lcd.drawLine(83,20,83,14,1);
    lcd.drawLine(63,20,83,20,1);
    lcd.drawLine(63,20,63,14,1);
    lcd.drawLine(63,14,67,14,1);
    lcd.drawLine(67,14,73,10,1);
    lcd.drawLine(73,10,79,10,1);
    lcd.drawLine(79,10,83,14,1);
    lcd.drawCircle(67,20,2,1);
    lcd.drawCircle(79,20,2,1);
    // draw lines and circles for the car on the left side of the display
    lcd.drawLine(20,20,20,14,1);
    lcd.drawLine(0,20,20,20,1);
    lcd.drawLine(0,20,0,14,1);
    lcd.drawLine(0,14,4,14,1);
    lcd.drawLine(4,14,10,10,1);
    lcd.drawLine(10,10,16,10,1);
    lcd.drawLine(16,10,20,14,1);
    lcd.drawCircle(4,20,2,1);
    lcd.drawCircle(16,20,2,1);

    //draw lines for the road
    lcd.drawLine(0,41,83,41,1);
    lcd.drawLine(0,44,83,44,2);
    lcd.drawLine(0,47,83,47,1);

    wait(2.5);// 2.5 seconds delay
    lcd.clear();//clear the screen
    lcd.refresh();//refresh the display

    for (int j= 0; j>-83; j--) {
        lcd.printString("*University*",5,0);//display on the N5110 LCD
        lcd.printString("**Of Leeds**",5,1);//display on the N5110 LCD
        //draw lines for the road on the screen
        lcd.drawLine(0,30,83,30,1);
        lcd.drawLine(0,32,83,32,2);
        lcd.drawLine(0,35,83,35,1);

        // draw lines and circles for the cars on the display
        lcd.drawLine(83+j,30,83+j,24,1);
        lcd.drawLine(63+j,30,83+j,30,1);
        lcd.drawLine(63+j,30,63+j,24,1);
        lcd.drawLine(63+j,24,67+j,24,1);
        lcd.drawLine(67+j,24,73+j,20,1);
        lcd.drawLine(73+j,20,79+j,20,1);
        lcd.drawLine(79+j,20,83+j,24,1);
        lcd.drawCircle(67+j,30,2,1);
        lcd.drawCircle(79+j,30,2,1);

        lcd.drawLine(53+j,30,53+j,24,1);
        lcd.drawLine(33+j,30,53+j,30,1);
        lcd.drawLine(33+j,30,33+j,24,1);
        lcd.drawLine(33+j,24,37+j,24,1);
        lcd.drawLine(37+j,24,43+j,20,1);
        lcd.drawLine(43+j,20,49+j,20,1);
        lcd.drawLine(49+j,20,53+j,24,1);
        lcd.drawCircle(37+j,30,2,1);
        lcd.drawCircle(49+j,30,2,1);

        wait(0.10);//small delay
        lcd.clear();
        lcd.refresh();
    }

    while(1) {// infinite loop
       
       
        a1=ain1.read(); // read the value of potentiometer
        lcd.setBrightness(a1);// function to change LED backlight brightness using the potentiometer
        
        //call the functions
        Get_Average(); 
        ButtonsOperation();
        buttonOperation_1();

        Sleep();
    }
}
