#include "mbed.h"
#include "mb_pins.h"
#include "platform/mbed_thread.h"
#include "MQTTClientMbedOs.h"
#include <Adafruit_GFX.h>
#include <Adafruit_GFX_Config.h>
#include <Adafruit_SSD1306.h>


#define BLINKING_RATE_MS                                                     250
#define VOLTAGE_SCALER                                                      3.3f
#define YIELD_TIMEOUT_MS                                                    1000
#define MAX_NETWORKS                                                          15
#define PRINTF_DELAY_MS                                                       10

#define SCL PB_13
#define SDA PB_14
#define I2C_ADDRESS 0x3c
#define I2C_ADDRESS_MBED I2C_ADDRESS << 1
#define OLED_HEIGHT 64
#define OLED_LENGTH 128
#define REFRESH_RATE 5

I2C i2c_obj(SDA, SCL);
Adafruit_SSD1306_I2c myOLED(i2c_obj, PB_5, I2C_ADDRESS_MBED, 
OLED_HEIGHT, OLED_LENGTH);

AnalogIn pot1(MB_POT1);
InterruptIn sw1(MB_SW1);
DigitalOut led2(MB_LED2);
WiFiInterface *wifi;
TCPSocket socket;
MQTTClient client(&socket);
MQTT::Message message;

char* topic = "pubpim25";
char* topic_sub = "subpim";
int arrivedcount = 0;
int button_pressed=0;
const char* hostname = "broker.hivemq.com";
int port = 1883;
const char *sec2str(nsapi_security_t sec)
{
    switch (sec) 
    {
        case NSAPI_SECURITY_NONE:
            return "None";
        case NSAPI_SECURITY_WEP:
            return "WEP";
        case NSAPI_SECURITY_WPA:
            return "WPA";
        case NSAPI_SECURITY_WPA2:
            return "WPA2";
        case NSAPI_SECURITY_WPA_WPA2:
            return "WPA/WPA2";
        case NSAPI_SECURITY_UNKNOWN:
        default:
            return "Unknown";
    }
}

int scan_networks(WiFiInterface *wifi)
{
    printf("Scan:\n");
    int count = wifi->scan(NULL, 0);
    if (count <= 0)
    {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }
    count = count < MAX_NETWORKS ? count : MAX_NETWORKS;
    WiFiAccessPoint *ap = new WiFiAccessPoint[count];
    count = wifi->scan(ap, count);
    
    if (count <= 0) 
    {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }
    
    for (int i = 0; i < count; i++) 
    {
        printf("Network: %s secured: %s BSSID: %hhX:%hhX:%hhX:%hhx:%hhx:%hhx RSSI: %hhd Ch: %hhd\n", ap[i].get_ssid(),
               sec2str(ap[i].get_security()), ap[i].get_bssid()[0], ap[i].get_bssid()[1], ap[i].get_bssid()[2],
               ap[i].get_bssid()[3], ap[i].get_bssid()[4], ap[i].get_bssid()[5], ap[i].get_rssi(), ap[i].get_channel());
        thread_sleep_for(PRINTF_DELAY_MS);
    }
    printf("%d networks available.\n", count);
    
    delete[] ap;
    return count;
}

void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Message from the browser: %.*s\r\n", message.payloadlen, (char*)message.payload);
    ++arrivedcount;
}

void buttonFunction() {
    
    button_pressed=1;
   
}

int main()
{
    sw1.fall(&buttonFunction);
     
    myOLED.begin();
    i2c_obj.frequency(400000);
    
    wifi = WiFiInterface::get_default_instance();
    if (!wifi) {
        printf("ERROR: No WiFiInterface found.\n");
        return -1;
    }
    
    int count = scan_networks(wifi);
    if (count == 0) {
        printf("No WIFI APs found - can't continue further.\n");
        return -1;
    }
    
    printf("\nConnecting to %s...\n", MBED_CONF_APP_WIFI_SSID);
    int ret = wifi->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0) {
        printf("\nConnection error: %d\n", ret);
        return -1;
    }
    
    printf("Success\n\n");
    printf("MAC: %s\n", wifi->get_mac_address());
    printf("IP: %s\n", wifi->get_ip_address());
    printf("Netmask: %s\n", wifi->get_netmask());
    printf("Gateway: %s\n", wifi->get_gateway());
    printf("RSSI: %d\n\n", wifi->get_rssi());   
    
    socket.open(wifi);
    socket.connect(hostname, port);
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "pim-25";
    
    int rc = 0;
    if ((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d\r\n", rc);

    if ((rc = client.subscribe(topic_sub, MQTT::QOS2, messageArrived)) != 0)
        printf("rc from MQTT subscribe is %d\r\n", rc);
      
      int xs = 0;
    while (true) {
        //led2 = !led2;
        thread_sleep_for(BLINKING_RATE_MS);
        if (button_pressed == 1) {
            button_pressed=0;     
            xs++; 
            char buf[100];
            sprintf(buf, "V(POT1) = %1.2f\r\n", pot1*VOLTAGE_SCALER);
            message.qos = MQTT::QOS0;
            message.retained = false;
            message.dup = false;
            message.payload = (void*)buf;
            message.payloadlen = strlen(buf)+1;
            client.publish(topic, message);
            myOLED.clearDisplay();
            myOLED.fillRect(15+xs,15+xs,15,15,WHITE);
            myOLED.display();
        }
        //if (client.publish(topic_sub)) { // nzm kako da procitam poruku sa topica...................................................................
//            button_pressed=0;     
//            xs++; 
//            char buf[100];
//            sprintf(buf, "V(POT1) = %1.2f\r\n", pot1*VOLTAGE_SCALER);
//            message.qos = MQTT::QOS0;
//            message.retained = false;
//            message.dup = false;
//            message.payload = (void*)buf;
//            message.payloadlen = strlen(buf)+1;
//            client.publish(topic, message);
//            client.
//            myOLED.clearDisplay();
//            myOLED.fillRect(15+xs,15+xs,15,15,WHITE);
//            myOLED.display();
//        }
        client.yield(YIELD_TIMEOUT_MS);
    }
}