#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "TextLCD.h"
//CNN Tech News RSS Feed - get web page with XML
// displays titles on LCD  from XML "<title>....title text...</title>"
TextLCD lcd(p26,p25,p24,p23,p22,p20,p19,TextLCD::LCD20x4); // rs, e, d0-d3
EthernetNetIf eth;
HTTPClient http;
HTTPResult result;
bool completed = false;
void loadZVVNews();
void request_callback(HTTPResult r)
{
    result = r;
    completed = true;
}

int main()
{

    // the eth and HTTP code has be taken directly from the HTTPStream documentation page
    // see http://mbed.org/cookbook/HTTP-Client-Data-Containers
    lcd.cls();
    lcd.printf("net setup");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        lcd.printf("\n\r net error");
        return -1;
    }
    lcd.printf("\n\r net ok");
    wait(0.5);
    lcd.cls();
    /*  HTTPStream stream;
      char BigBuf[2048 + 1] = {0};
      stream.readNext((byte*)BigBuf, 2048); //Point to buffer for the first read
      //CNN Tech News RSS Feed - get web page with XML
      HTTPResult r = http.get("http://online.fahrplan.zvv.ch/bin/help.exe/dn?tpl=rss_feed_VBZ", &stream, request_callback);
      while (!completed) {
          Net::poll(); // Polls the Networking stack
          if (stream.readable()) { // check for end of file
              BigBuf[stream.readLen()] = 0; // Transform this buffer in a zero-terminated char* string
              tsptr = BigBuf;
              // displays titles on LCD  from XML "<title>....title text...</title>"
              do {
                  tsptr = strstr(tsptr,tstartXML); // find <title> in string - NULL if not
                  teptr = strstr(tsptr,tendXML); // find <\title> in string - NULL if not
                  if (tsptr!=NULL) tsptr = tsptr + strlen(tstartXML);// move to char after "<title>"
                  if ((tsptr!=NULL)&&(teptr!=NULL)) {
                      //i=0;
                      // loop to scroll characters slowly across LCD
                      for (j=0; j<(strlen(tsptr)-strlen(teptr)); j++) {
                          //lcd.cls(); // clear screen before writing a new line
                          // loop to output a line on the LCD
                          for (i=0; ((i<16)&&(tsptr[i+j-1] != '<')); i++) {
                              lcd.putc(tsptr[i+j]);
                          }
      lcd.putc(tsptr[j]);
       //if (j==0) wait(1.2); //add first line delays for scroll timing
       wait(.1); //delay for charcter scroll timing
    }
    wait(.4);
    lcd.cls(); //clear LCD between news items
    wait(.2);
    }
    } while (tsptr!=NULL); // No more "<title>"s in BigBuf to display
    stream.readNext((byte*)BigBuf, 2048); //Buffer has been read, now we can put more data in it
    }
    }*/
    loadZVVNews();
    while(true) {
        completed = false;
        if (result == HTTP_OK) {
            wait(2);
            lcd.cls();
            loadZVVNews();

            //lcd.cls();
            //lcd.printf(" Read complete\n\r");
        } else {
            lcd. printf(" Error %d\n", result);
            wait(1.2);
            lcd.cls();
            loadZVVNews();
        }
    }
}

void loadZVVNews()
{
    char *tstartXML = "<title>"; //RSS XML start title
    char *tendXML ="</title>"; //RSS XML end title
    char *tsptr;
    char *teptr;
    int j=0;
    HTTPStream stream;
    char BigBuf[4096 + 1] = {0};
    stream.readNext((byte*)BigBuf, 4096); //Point to buffer for the first read
    //CNN Tech News RSS Feed - get web page with XML
    HTTPResult r = http.get("http://online.fahrplan.zvv.ch/bin/help.exe/dn?tpl=rss_feed_VBZ", &stream, request_callback);
    while (!completed) {
        Net::poll(); // Polls the Networking stack
        if (stream.readable()) { // check for end of file
            BigBuf[stream.readLen()] = 0; // Transform this buffer in a zero-terminated char* string
            tsptr = BigBuf;
            // displays titles on LCD  from XML "<title>....title text...</title>"
            do {
                tsptr = strstr(tsptr,tstartXML); // find <title> in string - NULL if not
                teptr = strstr(tsptr,tendXML); // find <\title> in string - NULL if not
                if (tsptr!=NULL) tsptr = tsptr + strlen(tstartXML);// move to char after "<title>"
                if ((tsptr!=NULL)&&(teptr!=NULL)) {
                    //i=0;
                    // loop to scroll characters slowly across LCD
                    for (j=0; j<(strlen(tsptr)-strlen(teptr)); j++) {
                        //lcd.cls(); // clear screen before writing a new line
                        // loop to output a line on the LCD
                        /*for (i=0; ((i<16)&&(tsptr[i+j-1] != '<')); i++) {
                            lcd.putc(tsptr[i+j]);
                        }*/
                        lcd.putc(tsptr[j]);
                        //if (j==0) wait(1.2); //add first line delays for scroll timing
                         //delay for charcter scroll timing
                    }
                    if(tsptr!=NULL) wait(2.5);
                    lcd.cls(); //clear LCD between news items
                    
                }
            } while (tsptr!=NULL); // No more "<title>"s in BigBuf to display
            stream.readNext((byte*)BigBuf, 4096); //Buffer has been read, now we can put more data in it
        }
    }
}