/* mbed Microcontroller Library
* Copyright (c) 2006-2016 ARM Limited
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/**
  ******************************************************************************
  * @file    x_nucleo_ihm07m1_targets.h 
  * @author  STMicroelectronics
  * @brief   Header file with pin definitions for X-NUCLEO-IHM07M1 board
  ******************************************************************************
  * @copy
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2016 STMicroelectronics</center></h2>
  */ 

/* Define to prevent from recursive inclusion --------------------------------*/
#ifndef __X_NUCLEO_IHM07M1_TARGETS_H_
#define __X_NUCLEO_IHM07M1_TARGETS_H_

// Default pin configuration for X-NUCLEO-IHM07M1 with STM32 Nucleo-64 boards

// Logic input pins
#define P_IN1 PA_8
#define P_IN2 PA_9
#define P_IN3 PA_10

// Enable channel pins
//#define P_EN1 PC_10  //IHM07
//#define P_EN2 PC_11
//#define P_EN3 PC_12

#define P_EN1 PA_7      //IHM08
#define P_EN2 PB_0 
#define P_EN3 PB_1 

// Hall sensors pins
#define P_HALL1 PA_15
#define P_HALL2 PB_3
#define P_HALL3 PB_10

// Temperature pin
#define P_TEMP PC_2

// Fault LED
#define P_FAULT PB_2

// Speed potentiometer
//#define P_SPEED PB_1    //IHM07 
#define P_SPEED PA_4        //IHM

// Back EMF pins
//#define P_BEMF1 PC_3  //IHM07 
//#define P_BEMF2 PB_0  
//#define P_BEMF3 PA_7  

#define P_BEMF1 PC_3    //IHM08
#define P_BEMF2 PC_4
#define P_BEMF3 PC_5

// Current pins
#define P_CURR1 PA_0
#define P_CURR2 PC_1
#define P_CURR3 PC_0

// Voltage bus pin
#define P_VBUS PA_1

#endif // __X_NUCLEO_IHM07M1_TARGETS_H_
