#include "BLDCmotorDriver.h"

BLDCmotorDriver::BLDCmotorDriver(PinName pGH_A, PinName pGH_B, PinName pGH_C, PinName pGL_A, PinName pGL_B, PinName pGL_C,
                    PinName pH1, PinName pH2, PinName pH3,PinName pC1, PinName pC2, PinName pC3, PinName pFault) : 
                    GH_A(pGH_A), GH_B(pGH_B), GH_C(pGH_C), GL_A(pGL_A), GL_B(pGL_B), GL_C(pGL_C),
                    H1(pH1), H2(pH2), H3(pH3),C1(pC1),C2(pC2),C3(pC3),Fault(LED1){
                     
    sampleTime = 1e-3;
    switchingPeriod = 1.0 / 20e3;
    dutyCycle = tempDutyCycle = 0;
    GH_A.period(switchingPeriod); // applies to all PwmOut instances
    rl.setLimits(0.1, -0.1, 0, sampleTime); // initial 10 second ramp
    //H1.mode(PullNone);
    //H2.mode(PullNone);
    //H3.mode(PullNone);
    H1.rise(this, &BLDCmotorDriver::commutation);
    H2.rise(this, &BLDCmotorDriver::commutation);
    H3.rise(this, &BLDCmotorDriver::commutation);
    H1.fall(this, &BLDCmotorDriver::commutation);
    H2.fall(this, &BLDCmotorDriver::commutation);
    H3.fall(this, &BLDCmotorDriver::commutation);
}
void BLDCmotorDriver::configure(float sampleTime, float switchingFrequency, float rampUpSlope, float rampDownSlope) {
    if (sampleTime < 1e-6)
        sampleTime = 1e-3;
    if (switchingFrequency < 100)
        switchingFrequency = 20e3;
    if (rampUpSlope < 0 || rampUpSlope > 1)
        rampUpSlope = 0.1;
    if (rampDownSlope > 0 || rampDownSlope < -1)
        rampDownSlope = -0.1;
    this->sampleTime = sampleTime;
    switchingPeriod = 1.0 / switchingFrequency;
    rl.setLimits(rampUpSlope, rampDownSlope, 0, sampleTime);
}
int BLDCmotorDriver::getSector(){           // hall 120°
    
    h1 = H1.read();  
    h2 = H2.read();
    h3 = H3.read();
    
     
    if(h1 == 0 && h2 == 0 && h3 == 1){          
            _currentSector = 0;
             }    
    else if(h1 == 0 && h2 == 1 && h3 == 1){
            _currentSector = 1;        
            }        
    else if(h1 == 0 && h2 == 1 && h3 == 0){  
            _currentSector = 2;       
            }  
    else if(h1 == 1 && h2 == 1 && h3 == 0){
            _currentSector = 3;
            } 
    else if(h1 == 1 && h2 == 0 && h3 == 0){
            _currentSector = 4;
            }
    else if(h1 == 1 && h2 == 0 && h3 == 1){
            _currentSector = 5;
            }           
     previousSector = _currentSector - 1;
     difference = _currentSector - previousSector;
     if (difference == 1){
       currentSector = _currentSector;
       Fault = 0;
       }
     else Fault = 1; 
return currentSector;                
}  

void BLDCmotorDriver::commutation()  {
 dutyCycle = rl.out(tempDutyCycle);
 currentSector = getSector();
    if (dutyCycle > 0) {
        currentSector++;
        if(currentSector > 5)currentSector = 0;
        switch(currentSector) {  
        
          case 0:               //001     
                GH_A = dutyCycle;
                GL_A = 0;
                GH_B = 0;
                GL_B = 0;
                GH_C = 0;
                GL_C = 1;
                break;
           case 1:            
                GH_A = 0;
                GL_A = 0;
                GH_B = dutyCycle;
                GL_B = 0;
                GH_C = 0;
                GL_C = 1; 
                break;
           case 2:             
                GH_A = 0;
                GL_A = 1;
                GH_B = dutyCycle;
                GL_B = 0;
                GH_C = 0;
                GL_C = 0;
                break;
            case 3:             
                GH_A = 0;
                GL_A = 1;
                GH_B = 0;
                GL_B = 0;
                GH_C = dutyCycle;
                GL_C = 0;
                break;
            case 4:              
                GH_A = 0;
                GL_A = 0;
                GH_B = 0;
                GL_B = 1;
                GH_C = dutyCycle;
                GL_C = 0; 
                break;    
            case 5:              
                GH_A = dutyCycle;
                GL_A = 0;
                GH_B = 0;
                GL_B = 1;
                GH_C = 0;
                GL_C = 0; 
                break;
        }
    } else if (dutyCycle < 0) { 
        currentSector--;
        if(currentSector < 0)currentSector = 5;
        switch(currentSector) {
          case 0:              
                GH_A = -dutyCycle;
                GL_A = 0;
                GH_B = 0;
                GL_B = 1;
                GH_C = 0;
                GL_C = 0; 
                break;
          case 1:                 
                GH_A = -dutyCycle;
                GL_A = 0;
                GH_B = 0;
                GL_B = 0;
                GH_C = 0;
                GL_C = 1;
                break;
           case 2:            
                GH_A = 0;
                GL_A = 0;
                GH_B = -dutyCycle;
                GL_B = 0;
                GH_C = 0;
                GL_C = 1; 
                break;
           case 3:             
                GH_A = 0;
                GL_A = 1;
                GH_B = -dutyCycle;
                GL_B = 0;
                GH_C = 0;
                GL_C = 0;
                break;
            case 4:             
                GH_A = 0;
                GL_A = 1;
                GH_B = 0;
                GL_B = 0;
                GH_C = -dutyCycle;
                GL_C = 0;
                break;
            case 5:              
                GH_A = 0;
                GL_A = 0;
                GH_B = 0;
                GL_B = 1;
                GH_C = -dutyCycle;
                GL_C = 0; 
                break;    
                }                
        }else {
        coast();
    }
}
void BLDCmotorDriver::setDutyCycle(float dc) {
    if (dc >= -1 && dc <= 1) {
        ticker.attach(this, &BLDCmotorDriver::commutation, sampleTime);
        tempDutyCycle = dc;
    } else {
        coast();
    }
}
/*void BLDCmotorDriver::adjustDutyCycle() {
    dutyCycle = rl.out(tempDutyCycle);
    float diff = tempDutyCycle - dutyCycle;
    if (diff < 0.01 || diff > -0.01)
        ticker.detach();
}*/
void BLDCmotorDriver::coast() {
    GH_A = 0;
    GL_A = 0;
    GH_B = 0;
    GL_B = 0;
    GH_C = 0;
    GL_C = 0;
    dutyCycle = tempDutyCycle = 0;
    rl.reset();
    ticker.detach();
}
float BLDCmotorDriver::getDutyCycle() {
    return dutyCycle;
}